/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.smf.ClientCtrlTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;

public class TlvParameterFactoryClientCtrl {
    private static TlvParameterFactoryClientCtrl _self = new TlvParameterFactoryClientCtrl();

    private TlvParameterFactoryClientCtrl() {
    }

    public static TlvParameterFactoryClientCtrl instance() {
        return _self;
    }

    public ClientCtrlTLVParameter getSoftwareVersion(String s) {
        byte[] enc = TlvCoderUtil.truncateNullTermBinaryString(TlvCoderUtil.toNullTermAscii(s), 255);
        return new ClientCtrlTLVParameter(0, 0, enc);
    }

    public ClientCtrlTLVParameter getSoftwareDate(String s) {
        byte[] enc = TlvCoderUtil.truncateNullTermBinaryString(TlvCoderUtil.toNullTermAscii(s), 255);
        return new ClientCtrlTLVParameter(0, 1, enc);
    }

    public ClientCtrlTLVParameter getPlatform(String s) {
        byte[] enc = TlvCoderUtil.truncateNullTermBinaryString(TlvCoderUtil.toNullTermAscii(s), 255);
        return new ClientCtrlTLVParameter(0, 2, enc);
    }

    public ClientCtrlTLVParameter getUserId(String s) {
        byte[] enc = TlvCoderUtil.truncateNullTermBinaryString(TlvCoderUtil.toNullTermAscii(s), 255);
        return new ClientCtrlTLVParameter(0, 3, enc);
    }

    public ClientCtrlTLVParameter getClientDescription(String s) {
        byte[] enc = TlvCoderUtil.truncateNullTermBinaryString(TlvCoderUtil.toNullTermAscii(s), 255);
        return new ClientCtrlTLVParameter(0, 4, enc);
    }

    public ClientCtrlTLVParameter getClientName(String s) {
        byte[] enc = TlvCoderUtil.truncateNullTermBinaryString(TlvCoderUtil.toNullTermUtf8(s), 161);
        return new ClientCtrlTLVParameter(0, 5, enc);
    }

    public ClientCtrlTLVParameter getMsgVpnName(String s) {
        byte[] enc = TlvCoderUtil.truncateNullTermBinaryString(TlvCoderUtil.toNullTermUtf8(s), 33);
        return new ClientCtrlTLVParameter(1, 6, enc);
    }

    public ClientCtrlTLVParameter getDeliverToOnePriority(int localPriority, int networkPriority) {
        byte[] val = new byte[]{NetworkByteOrderNumberUtil.intToOneByte(localPriority), NetworkByteOrderNumberUtil.intToOneByte(networkPriority)};
        return new ClientCtrlTLVParameter(0, 7, val);
    }

    public ClientCtrlTLVParameter getNoLocal() {
        byte[] val = new byte[]{1};
        return new ClientCtrlTLVParameter(0, 15, val);
    }

    public ClientCtrlTLVParameter getAuthenticationScheme(int scheme) {
        byte[] val = new byte[]{NetworkByteOrderNumberUtil.intToOneByte(scheme)};
        return new ClientCtrlTLVParameter(1, 17, val);
    }

    public ClientCtrlTLVParameter getRequiresRelease7_0() {
        byte[] emptyByte = new byte[]{};
        return new ClientCtrlTLVParameter(1, 20, emptyByte);
    }

    public ClientCtrlTLVParameter getConnectionType(ConnectionType connectionType) {
        return new ClientCtrlTLVParameter(0, 18, new byte[]{connectionType.getValue()});
    }

    public ClientCtrlTLVParameter getSSLDowngradeProtocol(int proto) {
        byte[] val = new byte[]{NetworkByteOrderNumberUtil.intToOneByte(proto)};
        return new ClientCtrlTLVParameter(1, 21, val);
    }

    public ClientCtrlTLVParameter getClientCapabilities() {
        byte[] val = new byte[]{1, -128};
        return new ClientCtrlTLVParameter(0, 23, val);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionType {
        Basic(0),
        XA(1);

        private byte _value;

        private ConnectionType(byte value) {
            this._value = value;
        }

        public byte getValue() {
            return this._value;
        }
    }
}

