/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.sdt;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.common.util.SolByteBuffer;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.RawSMFMessage;
import com.solacesystems.jcsmp.SDTEOFException;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTFormatException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.SDTUnknownType;
import com.solacesystems.jcsmp.impl.sdt.Formatter;
import com.solacesystems.jcsmp.impl.sdt.MapTLVBuffer;
import com.solacesystems.jcsmp.impl.sdt.PermissiveFormatter;
import com.solacesystems.jcsmp.impl.sdt.SDTMapIF;
import com.solacesystems.jcsmp.impl.sdt.SDTSerializable;
import com.solacesystems.jcsmp.impl.sdt.StreamImpl;
import com.solacesystems.jcsmp.impl.sdt.TLVBuffer;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapImpl
implements SDTMapIF,
SDTSerializable {
    private static final Log Trace = LogFactory.getLog(MapImpl.class);
    private static final int DEFAULT_INITIAL_SIZE = 1024;
    protected MapTLVBuffer mBuffer;
    protected boolean mBufferInvalid;
    protected HashMap<String, Object> mMap;
    protected HashMap<String, MapEntry> mSDTMapMap;
    protected HashMap<String, StreamEntry> mSDTStreamMap;
    protected Formatter mFmter;
    protected SDTException mException;
    protected long mVersion;

    public MapImpl() {
        this(1024);
    }

    public MapImpl(int capacity) {
        this.mBuffer = new MapTLVBuffer(capacity);
        this.mBufferInvalid = true;
        this.mMap = new HashMap();
        this.mSDTMapMap = new HashMap();
        this.mSDTStreamMap = new HashMap();
        this.mFmter = PermissiveFormatter.OnlyInstance;
        this.mException = null;
        this.mVersion = 0L;
    }

    public MapImpl(MapTLVBuffer buffer) {
        this.mBuffer = buffer;
        this.mBufferInvalid = false;
        this.mMap = null;
        this.mSDTMapMap = null;
        this.mSDTStreamMap = null;
        this.mFmter = PermissiveFormatter.OnlyInstance;
        this.mException = null;
        this.mVersion = 0L;
    }

    public long getVersion() {
        return this.mVersion;
    }

    @Override
    public void setFormatter(Formatter fmter) {
        this.mFmter = fmter;
    }

    public void invalidateChangedBuffers() {
        if (!this.mBufferInvalid) {
            boolean incrementVersion = false;
            if (this.mMap != null) {
                Entry entry;
                for (String key : this.mSDTMapMap.keySet()) {
                    entry = this.mSDTMapMap.get(key);
                    if (entry.map == null) continue;
                    entry.map.invalidateChangedBuffers();
                    if (entry.version == entry.map.getVersion()) continue;
                    this.mBufferInvalid = true;
                    incrementVersion = true;
                    entry.version = entry.map.getVersion();
                }
                for (String key : this.mSDTStreamMap.keySet()) {
                    entry = this.mSDTStreamMap.get(key);
                    if (((StreamEntry)entry).stream == null || ((StreamEntry)entry).version == ((StreamEntry)entry).stream.getVersion()) continue;
                    this.mBufferInvalid = true;
                    incrementVersion = true;
                    ((StreamEntry)entry).version = ((StreamEntry)entry).stream.getVersion();
                }
            }
            if (incrementVersion) {
                ++this.mVersion;
            }
        }
    }

    @Override
    public void serialize(TLVBuffer buffer) {
        if (this.mMap == null) {
            buffer.getSolByteBuffer().writeBytes(this.mBuffer.getSolByteBuffer().getBackingArray(), this.mBuffer.getSolByteBuffer().getBackingArrayOffset(), this.mBuffer.getSolByteBuffer().getLength());
        } else {
            SolByteBuffer byteBuffer = buffer.getSolByteBuffer();
            int index = byteBuffer.getLength() + 1;
            buffer.writeTag((byte)10, (byte)3);
            byteBuffer.writeBytes(TLVBuffer.EMPTY_SDT);
            for (String key : this.mMap.keySet()) {
                Object value = this.mMap.get(key);
                buffer.write(key);
                if (value instanceof SDTSerializable) {
                    ((SDTSerializable)value).serialize(buffer);
                    continue;
                }
                buffer.write(value);
            }
            byteBuffer.writeUInt(index, byteBuffer.getLength() - index + 1);
        }
    }

    @Override
    public ByteArray asByteArray() {
        this.invalidateChangedBuffers();
        if (this.mBufferInvalid) {
            this.mBuffer = new MapTLVBuffer(100);
            for (String key : this.mMap.keySet()) {
                Object value = this.mMap.get(key);
                this.mBuffer.write(key);
                this.mBuffer.write(value);
            }
            this.mBufferInvalid = false;
        }
        return this.mBuffer.asByteArray();
    }

    @Override
    public boolean containsKey(String key) {
        this.initializeNoThrow();
        return this.mMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.initializeNoThrow();
        return this.mMap.containsValue(value);
    }

    @Override
    public void remove(String key) {
        this.initializeNoThrow();
        this.mMap.remove(key);
        this.mSDTMapMap.remove(key);
        this.mSDTStreamMap.remove(key);
        this.mBufferInvalid = true;
        ++this.mVersion;
    }

    @Override
    public void clear() {
        if (this.mMap == null) {
            this.mMap = new HashMap();
            this.mSDTMapMap = new HashMap();
            this.mSDTStreamMap = new HashMap();
        } else {
            this.mMap.clear();
            this.mSDTMapMap.clear();
            this.mSDTStreamMap.clear();
        }
        this.mBufferInvalid = true;
        ++this.mVersion;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MapImpl) {
            MapImpl other = (MapImpl)obj;
            this.initializeNoThrow();
            other.initializeNoThrow();
            return this.mMap.equals(other.mMap);
        }
        return false;
    }

    public int hashCode() {
        return this.mMap.hashCode();
    }

    @Override
    public Object get(String key) throws SDTException {
        this.initialize();
        return this.mMap.get(key);
    }

    @Override
    public Boolean getBoolean(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getBoolean(this.mMap.get(key));
    }

    @Override
    public Byte getByte(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getByte(this.mMap.get(key));
    }

    @Override
    public byte[] getBytes(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getBytes(this.mMap.get(key));
    }

    @Override
    public ByteArray getByteArray(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getByteArray(this.mMap.get(key));
    }

    @Override
    public Character getCharacter(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getCharacter(this.mMap.get(key));
    }

    @Override
    public Destination getDestination(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getDestination(this.mMap.get(key));
    }

    @Override
    public Double getDouble(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getDouble(this.mMap.get(key));
    }

    @Override
    public Float getFloat(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getFloat(this.mMap.get(key));
    }

    @Override
    public Integer getInteger(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getInteger(this.mMap.get(key));
    }

    @Override
    public Long getLong(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getLong(this.mMap.get(key));
    }

    @Override
    public SDTMap getMap(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getMap(this.mMap.get(key));
    }

    @Override
    public RawSMFMessage getMessage(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getMessage(this.mMap.get(key));
    }

    @Override
    public Short getShort(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getShort(this.mMap.get(key));
    }

    @Override
    public SDTStream getStream(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getStream(this.mMap.get(key));
    }

    @Override
    public String getString(String key) throws SDTException {
        this.initialize();
        return this.mFmter.getString(this.mMap.get(key));
    }

    @Override
    public boolean isEmpty() {
        this.initializeNoThrow();
        return this.mMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        this.initializeNoThrow();
        return this.mMap.keySet();
    }

    @Override
    public void putAll(SDTMap map) throws SDTException {
        this.initializeNoThrow();
        if (map != null) {
            for (String key : map.keySet()) {
                Object value = map.get(key);
                this.putValidObject(key, value);
            }
        }
    }

    public void putBigInteger(String key, BigInteger value) {
        if (value != null && (value.compareTo(BigInteger.ZERO) < 0 || value.compareTo(TLVBuffer.MAX_ULONG) > 0)) {
            throw new IllegalArgumentException("BigInteger value out of range - " + value);
        }
        this.putValidObject(key, value);
    }

    @Override
    public void putBoolean(String key, Boolean value) {
        this.putValidObject(key, value);
    }

    @Override
    public void putByte(String key, Byte value) {
        this.putValidObject(key, value);
    }

    @Override
    public void putBytes(String key, byte[] value) {
        if (value == null) {
            this.putValidObject(key, value);
        } else {
            this.putBytes(key, value, 0, value.length);
        }
    }

    @Override
    public void putBytes(String key, byte[] value, int offset, int length) {
        this.putByteArray(key, new ByteArray(value, offset, length));
    }

    @Override
    public void putByteArray(String key, ByteArray value) {
        this.putValidObject(key, value);
    }

    @Override
    public void putCharacter(String key, Character value) {
        this.putValidObject(key, value);
    }

    @Override
    public void putDestination(String key, Destination value) {
        this.putValidObject(key, value);
    }

    @Override
    public void putDouble(String key, Double value) {
        this.putValidObject(key, value);
    }

    @Override
    public void putFloat(String key, Float value) {
        this.putValidObject(key, value);
    }

    @Override
    public void putInteger(String key, Integer value) {
        this.putValidObject(key, value);
    }

    @Override
    public void putLong(String key, Long value) {
        this.putValidObject(key, value);
    }

    @Override
    public void putMap(String key, SDTMap value) {
        this.putValidObject(key, value);
        this.mSDTMapMap.put(key, this.createMapEntry(value));
    }

    @Override
    public void putMessage(String key, RawSMFMessage value) {
        this.putValidObject(key, value);
    }

    public void putUnknownType(String key, SDTUnknownType value) {
        this.putValidObject(key, value);
    }

    @Override
    public void putObject(String key, Object value) {
        if (value == null) {
            this.putValidObject(key, value);
        } else if (value instanceof Boolean) {
            this.putBoolean(key, (Boolean)value);
        } else if (value instanceof Byte) {
            this.putByte(key, (Byte)value);
        } else if (value instanceof byte[]) {
            this.putBytes(key, (byte[])value);
        } else if (value instanceof ByteArray) {
            this.putByteArray(key, (ByteArray)value);
        } else if (value instanceof Character) {
            this.putCharacter(key, (Character)value);
        } else if (value instanceof Destination) {
            this.putDestination(key, (Destination)value);
        } else if (value instanceof Double) {
            this.putDouble(key, (Double)value);
        } else if (value instanceof Float) {
            this.putFloat(key, (Float)value);
        } else if (value instanceof Integer) {
            this.putInteger(key, (Integer)value);
        } else if (value instanceof Long) {
            this.putLong(key, (Long)value);
        } else if (value instanceof RawSMFMessage) {
            this.putMessage(key, (RawSMFMessage)value);
        } else if (value instanceof SDTMap) {
            this.putMap(key, (SDTMap)value);
        } else if (value instanceof Short) {
            this.putShort(key, (Short)value);
        } else if (value instanceof SDTStream) {
            this.putStream(key, (SDTStream)value);
        } else if (value instanceof String) {
            this.putString(key, (String)value);
        } else if (value instanceof SDTUnknownType) {
            this.putUnknownType(key, (SDTUnknownType)value);
        } else if (value instanceof BigInteger) {
            this.putBigInteger(key, (BigInteger)value);
        } else {
            throw new IllegalArgumentException("Invalid type as value - " + value.getClass().getSimpleName());
        }
    }

    @Override
    public void putShort(String key, Short value) {
        this.putValidObject(key, value);
    }

    @Override
    public void putStream(String key, SDTStream value) {
        this.putValidObject(key, value);
        this.mSDTStreamMap.put(key, this.createStreamEntry(value));
    }

    @Override
    public void putString(String key, String value) {
        this.putValidObject(key, value);
    }

    private void putValidObject(String key, Object value) {
        this.initializeNoThrow();
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.mMap.remove(key);
        this.mSDTMapMap.remove(key);
        this.mSDTStreamMap.remove(key);
        this.mMap.put(key, value);
        this.mBufferInvalid = true;
        ++this.mVersion;
    }

    @Override
    public int size() {
        this.initializeNoThrow();
        return this.mMap.size();
    }

    public String toString() {
        this.initializeNoThrow();
        if (this.mMap == null) {
            return this.mBuffer.toString();
        }
        return this.mMap.toString();
    }

    @Override
    public Collection<Object> values() {
        this.initializeNoThrow();
        return this.mMap.values();
    }

    public Map<String, Object> getMap() {
        this.initializeNoThrow();
        return this.mMap;
    }

    private MapEntry createMapEntry(SDTMap value) {
        MapEntry entry = new MapEntry();
        entry.map = (MapImpl)value;
        entry.version = value != null ? entry.map.getVersion() : 0L;
        return entry;
    }

    private StreamEntry createStreamEntry(SDTStream value) {
        StreamEntry entry = new StreamEntry();
        entry.stream = (StreamImpl)value;
        entry.version = value != null ? entry.stream.getVersion() : 0L;
        return entry;
    }

    private void initializeNoThrow() {
        try {
            this.initialize();
        }
        catch (SDTException sDTException) {
            // empty catch block
        }
    }

    private void initialize() throws SDTException {
        if (this.mMap == null) {
            this.mMap = new HashMap();
            this.mSDTMapMap = new HashMap();
            this.mSDTStreamMap = new HashMap();
            try {
                this.mBuffer.skip(5);
                while (this.mBuffer.hasRemaining()) {
                    Object obj = this.mBuffer.read();
                    if (obj instanceof String) {
                        String key = (String)obj;
                        Object value = this.mBuffer.read();
                        this.mMap.put(key, value);
                        if (value instanceof SDTMap) {
                            this.mSDTMapMap.put(key, this.createMapEntry((SDTMap)value));
                            continue;
                        }
                        if (!(value instanceof SDTStream)) continue;
                        this.mSDTStreamMap.put(key, this.createStreamEntry((SDTStream)value));
                        continue;
                    }
                    if (Trace.isErrorEnabled()) {
                        Trace.error((Object)("Map key is not a String - " + obj));
                    }
                    this.mException = new SDTFormatException("map format error - key not a string");
                    throw this.mException;
                }
            }
            catch (SDTEOFException e) {
                if (Trace.isErrorEnabled()) {
                    Trace.error((Object)"Error loading map", (Throwable)((Object)e));
                }
                this.mException = e;
                throw e;
            }
        } else if (this.mException != null) {
            throw this.mException;
        }
    }

    public static SDTMap valueOf(Map<String, Object> map) {
        MapImpl retMap;
        block4: {
            if (map == null) {
                return null;
            }
            retMap = new MapImpl();
            try {
                for (Map.Entry<String, Object> e : map.entrySet()) {
                    retMap.putObject(e.getKey(), e.getValue());
                }
            }
            catch (SDTException e) {
                if (!Trace.isErrorEnabled()) break block4;
                Trace.error((Object)"Error converting map", (Throwable)((Object)e));
            }
        }
        return retMap;
    }

    protected class StreamEntry
    extends Entry {
        public StreamImpl stream;

        protected StreamEntry() {
        }
    }

    protected class MapEntry
    extends Entry {
        public MapImpl map;

        protected MapEntry() {
        }
    }

    protected class Entry {
        public long version;

        protected Entry() {
        }
    }
}

