/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.Arrays;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public final class ContentBuffer {
    public static final int DEFAULT_SZ = 4096;
    private ByteBuffer mDirBuf;
    private byte[] rd_buf;
    private int limit;
    private boolean useDirect = false;

    public ContentBuffer() {
        this(4096, false);
    }

    public ContentBuffer(boolean useDirect) {
        this(4096, useDirect);
    }

    public ContentBuffer(int sz, boolean useDirect) {
        this.useDirect = useDirect;
        this.mDirBuf = ContentBuffer.getBuffer(sz, this.useDirect);
        this.limit = 0;
    }

    private static ByteBuffer getBuffer(int sz, boolean useDirect) {
        if (useDirect) {
            return ByteBuffer.allocateDirect(sz);
        }
        return ByteBuffer.allocate(sz);
    }

    public ContentBuffer(ContentBuffer toclone) {
        if (toclone.mDirBuf != null) {
            this.mDirBuf = ContentBuffer.cloneBuffer(toclone.mDirBuf.capacity(), toclone.mDirBuf);
        }
        this.rd_buf = toclone.rd_buf == null ? null : Arrays.copyOf(toclone.rd_buf);
        this.limit = toclone.limit;
    }

    static ByteBuffer cloneBuffer(int newsize, ByteBuffer toclone) {
        ByteBuffer newbuf = ContentBuffer.getBuffer(newsize, toclone.isDirect());
        return ContentBuffer.cloneBufferTo(toclone, newbuf);
    }

    static ByteBuffer cloneBufferTo(ByteBuffer toclone, ByteBuffer dst) {
        int sav_limit = toclone.limit();
        int sav_position = toclone.position();
        toclone.flip();
        dst.put(toclone);
        toclone.limit(sav_limit);
        toclone.position(sav_position);
        return dst;
    }

    public final void reset() {
        this.limit = 0;
        this.mDirBuf.clear();
        if (this.mDirBuf.capacity() > 4096) {
            this.mDirBuf = ContentBuffer.getBuffer(4096, this.useDirect);
        }
    }

    public int getLimit() {
        return this.limit;
    }

    protected void setLimit(int limit) {
        this.limit = limit;
    }

    public int appendFromBytes(byte[] source, int offset, int len) {
        if (offset > 0 && offset > source.length - 1) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPAttachmentContainer.offsetTooLarge"));
        }
        if (offset < 0) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPAttachmentContainer.offsetMustBePositive"));
        }
        int lenToRead = len;
        if (lenToRead == -1) {
            lenToRead = source.length - offset;
        }
        if (offset + lenToRead > source.length) {
            throw new BufferUnderflowException();
        }
        if (this.limit + lenToRead > this.mDirBuf.capacity()) {
            ByteBuffer newBuf;
            int newsize = Math.max(this.mDirBuf.capacity() * 2, this.limit + lenToRead);
            this.mDirBuf = newBuf = ContentBuffer.cloneBuffer(newsize, this.mDirBuf);
        }
        this.mDirBuf.put(source, offset, lenToRead);
        this.limit += lenToRead;
        return lenToRead;
    }

    public int writeFromBytes(byte[] source, int offset, int len) {
        if (len == 0) {
            return 0;
        }
        if (offset > 0 && offset > source.length - 1) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPAttachmentContainer.offsetTooLarge"));
        }
        if (offset < 0) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPAttachmentContainer.offsetMustBePositive"));
        }
        this.limit = 0;
        this.mDirBuf.clear();
        return this.appendFromBytes(source, offset, len);
    }

    public int writeFromStream(InputStream istr, int offset, int length) throws IOException {
        if (offset < 0) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPAttachmentContainer.offsetMustBePositive"));
        }
        int offset_skip = offset;
        while (offset_skip > 0) {
            offset_skip = (int)((long)offset_skip - istr.skip(offset_skip));
        }
        this.mDirBuf.clear();
        int lenToRead = length;
        this.limit = 0;
        if (lenToRead == -1) {
            if (this.rd_buf == null) {
                this.rd_buf = new byte[4096];
            }
            int lenRead = 0;
            while ((lenRead = istr.read(this.rd_buf)) > -1) {
                if (lenRead > this.mDirBuf.remaining()) {
                    ByteBuffer newBuf;
                    int newSz = Math.max(this.mDirBuf.capacity() * 2, this.mDirBuf.capacity() + lenRead);
                    this.mDirBuf = newBuf = ContentBuffer.cloneBuffer(newSz, this.mDirBuf);
                }
                this.mDirBuf.put(this.rd_buf, 0, lenRead);
                this.limit += lenRead;
            }
        } else {
            if (lenToRead > this.mDirBuf.capacity()) {
                ByteBuffer newBuf;
                this.mDirBuf = newBuf = ContentBuffer.getBuffer(lenToRead, this.useDirect);
            }
            int bytesRead = 0;
            int localOffset = 0;
            this.rd_buf = new byte[lenToRead];
            while (lenToRead > 0) {
                bytesRead = istr.read(this.rd_buf, localOffset, lenToRead);
                lenToRead -= bytesRead;
                localOffset += bytesRead;
                if (bytesRead >= 0) continue;
            }
            this.limit = localOffset;
            this.mDirBuf.put(this.rd_buf);
        }
        return this.limit;
    }

    public int read(int srcPos, byte[] destination, int destPos, int length) {
        if (this.limit == 0) {
            return -1;
        }
        int lenToRead = length;
        lenToRead = Math.min(lenToRead, this.limit - srcPos);
        if ((lenToRead = Math.min(lenToRead, destination.length - destPos)) <= 0) {
            return -1;
        }
        this.mDirBuf.position(srcPos);
        this.mDirBuf.get(destination, destPos, lenToRead);
        return lenToRead;
    }

    public byte[] getBufferRefInternal() {
        if (this.mDirBuf.isDirect()) {
            byte[] buf = new byte[this.mDirBuf.capacity()];
            this.mDirBuf.flip();
            this.mDirBuf.get(buf, 0, this.limit);
            this.mDirBuf.position(this.limit);
            this.mDirBuf.limit(this.mDirBuf.capacity());
            return buf;
        }
        return this.mDirBuf.array();
    }

    public ByteBuffer getByteBufferRefInternal() {
        return this.mDirBuf;
    }

    protected void setByteBufferRefInternal(ByteBuffer buf) {
        this.mDirBuf = buf;
    }
}

