/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solacesystems.common.HostInfo;
import com.solacesystems.common.SolReserved;
import com.solacesystems.common.util.ThreadUtil;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFatalErrorException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPReconnectEventHandler;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.JndiMessage;
import com.solacesystems.jcsmp.ReplayStartLocation;
import com.solacesystems.jcsmp.SessionEvent;
import com.solacesystems.jcsmp.SessionEventArgs;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.VersionNotSupportException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.ContentBuffer;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.InternalConnectEvent;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPUtils;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.JndiMessageImpl;
import com.solacesystems.jcsmp.impl.MsgIdInfo;
import com.solacesystems.jcsmp.impl.PubADManager;
import com.solacesystems.jcsmp.impl.ReconnectFreqManager;
import com.solacesystems.jcsmp.impl.SessionEventArgsImpl;
import com.solacesystems.jcsmp.impl.SessionModeSupport;
import com.solacesystems.jcsmp.impl.client.ClientRequestResponse;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.flow.FlowTask;
import com.solacesystems.jcsmp.impl.flow.SubFlowManagerImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionManager;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionImpl;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionManager;
import com.solacesystems.jcsmp.protocol.CSMPPublisherChannel;
import com.solacesystems.jcsmp.protocol.CSMPPublisherChannelObserver;
import com.solacesystems.jcsmp.protocol.CSMPSubscriberChannel;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.SeqNumAllocator;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.ChannelOpStrategy;
import com.solacesystems.jcsmp.protocol.impl.ChannelOpStrategyClient;
import com.solacesystems.jcsmp.protocol.impl.ChannelOpStrategyPubdata;
import com.solacesystems.jcsmp.protocol.impl.ChannelOpStrategySubdata;
import com.solacesystems.jcsmp.protocol.impl.ClientMessageFactory;
import com.solacesystems.jcsmp.protocol.impl.PubMsgHeaderDecodingSupport;
import com.solacesystems.jcsmp.protocol.impl.SmfUhUtil;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.impl.WriteDroppedException;
import com.solacesystems.jcsmp.protocol.nio.SubscriberWireMessageHandler;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFPubMsgHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SSLSmfClient;
import com.solacesystems.jcsmp.protocol.smf.SimpleSmfClient;
import com.solacesystems.jcsmp.protocol.smf.SimpleSmfClientFactory;
import com.solacesystems.jcsmp.protocol.smf.SmfClientIOException;
import com.solacesystems.jcsmp.protocol.smf.SmpHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.BinaryMetadataEncoder;
import com.solacesystems.jcsmp.protocol.smf.impl.MessageElementDescription;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFPubMsgHeaderEncoder;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactorySmf;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterParser;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;
import com.solacesystems.jcsmp.secure.SecureProperties;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpClientChannel
extends TcpChannel
implements CSMPPublisherChannel,
CSMPSubscriberChannel,
SubscriberWireMessageHandler {
    private ChannelMode _channelMode;
    private ReconnectStartStrategy _channelReconStgy;
    private Object _channelReconStgyLock = new Object();
    private static final Log Trace = LogFactory.getLog(TcpClientChannel.class);
    private ChannelOpStrategy _opStrategy = null;
    private ChannelData _channelData;
    protected CSMPPublisherChannelObserver _pubobserver;
    protected boolean _pubExplicitAckEnabled = false;
    public Queue<ClientRequestResponse> _outstandingReqs;
    public Queue<ClientRequestResponse> _subOutstandingReqs;
    protected JCSMPReconnectEventHandler _reconEvtHandler;
    protected int seqCounter = 0;
    protected long _producerId = -1L;
    protected final int _readTimeoutInMillis;
    protected final String _sessionId;
    protected JCSMPBasicSession _session;
    protected ReconnectFreqManager _reconMgr;
    protected volatile boolean _state_started = false;
    protected boolean _ever_connected = false;
    protected SMFPubMsgHeaderEncoder _smfEncoder = new SMFPubMsgHeaderEncoder();
    protected BinaryMetadataEncoder _binmetaEncoder = new BinaryMetadataEncoder();
    protected SubFlowManagerImpl _subFlowMgr;
    protected TransactedSessionManager _txsessionMgr = null;
    protected XASessionManager _xasessionMgr = null;
    private SessionModeSupport _sessionModeSup = null;
    private ClientMessageFactory _clientMsgFactory = null;
    private volatile Future<Object> _reconnectFuture = null;
    private volatile Future<Object> _freqDisconnectFuture = null;
    private SmpInterceptState _smpRespInterceptState = null;
    private final boolean _session_ign_duplicatesub;
    private final boolean _session_ign_notfoundsub;
    private final boolean _session_calculateExpiration;
    private static volatile int _rcid_counter = 0;
    private AtomicInteger _last_success_reconn_id = new AtomicInteger(0);
    ThreadLocal<ByteBuffer[]> tl_maxlen_bbuf = new ThreadLocal<ByteBuffer[]>(){

        @Override
        protected ByteBuffer[] initialValue() {
            return new ByteBuffer[250];
        }
    };
    final String tmpl_msg_conn_attempting = "Connecting to host '%s' (host %s of %s, smfclient %s, attempt %s of %s, this_host_attempt: %s of %s)";
    final String tmpl_msg_conn_ok = "Connected to host '%s' (smfclient %s)";
    final String tmpl_msg_conn_failed = "Connection attempt failed to host '%s'";

    public TcpClientChannel(JCSMPProperties props, SecureProperties secureProps, JCSMPSessionStats stats, String sessionId, JCSMPBasicSession session, ContextImpl context, ChannelMode channelMode) {
        super(props, secureProps, "client_channel", stats, context);
        this._sessionId = sessionId;
        this._session = session;
        this._clientMsgFactory = new ClientMessageFactory(session);
        this._outstandingReqs = new LinkedBlockingQueue<ClientRequestResponse>(1);
        this._subOutstandingReqs = new LinkedBlockingQueue<ClientRequestResponse>(1);
        this._readTimeoutInMillis = this.properties.getReadTimeoutInMillis();
        this._reconMgr = new ReconnectFreqManager(this, context);
        this._smfSecureClient = null;
        this._smfNonSecureClient = null;
        for (int i = 0; i < this._hostList.size(); ++i) {
            if (((HostInfo)this._hostList.get(i)).isSecure() && this._smfSecureClient == null) {
                this._smfSecureClient = SimpleSmfClientFactory.constructAndInit(props, this.properties, secureProps, (HostInfo)this._hostList.get(i), stats, context);
                continue;
            }
            if (((HostInfo)this._hostList.get(i)).isSecure() || this._smfNonSecureClient != null) continue;
            this._smfNonSecureClient = SimpleSmfClientFactory.constructAndInit(props, this.properties, secureProps, (HostInfo)this._hostList.get(i), stats, context);
        }
        this._smfClient = ((HostInfo)this._hostList.get(0)).isSecure() ? this._smfSecureClient : this._smfNonSecureClient;
        try {
            if (this.localIP != null && this.localIP.trim().length() > 0) {
                InetAddress localInetAddress = InetAddress.getByName(this.localIP);
                this._smfClient.setLocalAddress(localInetAddress);
            }
        }
        catch (UnknownHostException e) {
            Trace.warn((Object)e);
        }
        this._channelMode = channelMode;
        this._opStrategy = this._channelMode.newOpStgy(this);
        this._channelData = new ChannelData();
        this._channelData.sessionProperties = this.sessionProperties;
        this._channelData.sessionId = this._sessionId;
        this._channelData.channelProperties = this.properties;
        this._channelData.sessionStats = this.sessionStats;
        this._channelData.p2pTopicBase = null;
        this._channelData.smfClient = this._smfClient;
        this._channelData.sessionModeSup = this._sessionModeSup;
        this._channelData.session = session;
        this._channelData.hostList = this._hostList;
        this._opStrategy.populateChannelRefs(this._channelData);
        this._session_ign_duplicatesub = this.sessionProperties.getBooleanProperty("IGNORE_DUPLICATE_SUBSCRIPTION_ERROR");
        this._session_ign_notfoundsub = this.sessionProperties.getBooleanProperty("IGNORE_SUBSCRIPTION_NOT_FOUND_ERROR");
        this._session_calculateExpiration = this.sessionProperties.getBooleanProperty("calculate_message_expiration");
        this._smpRespInterceptState = new SmpInterceptState.SmpInterceptNormal(this);
    }

    public String getDbgId() {
        String clientName = (String)this._session.getJCSMPProperties().getProperty("client_name");
        String clientDesc = (String)this._session.getJCSMPProperties().getProperty("application_description");
        return this._smfClient != null ? String.format("(smfclient %s, name=%s, desc=%s)", this._smfClient.getSmfClientId(), clientName, clientDesc) : "?";
    }

    public Integer getConnCounterTag() {
        return this._smfClient != null ? this._smfClient.getConnCounterTag() : null;
    }

    @Override
    protected TcpChannel.KeepaliveWriteResult writeKAMessage(WireMessage wm) throws JCSMPException {
        try {
            wm.getSmfHeader().setSmfVersion(3);
            int ka_ret = this._smfClient.doSmfSharedWrite(wm, null, false, false, true, false, false, false);
            return new TcpChannel.KeepaliveWriteResult(this._smfClient.getBytesWritten(), ka_ret == 0);
        }
        catch (IOException e) {
            throw new JCSMPTransportException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.errorCommWithRouter"), e);
        }
        catch (InterruptedException ex) {
            throw new JCSMPTransportException("Write interrupted.", ex);
        }
    }

    @Override
    void handleKeepaliveException(Exception ex) {
        this.handleException(ex, false);
    }

    @Override
    public boolean autoConnect() {
        return false;
    }

    @Override
    public void drainOutstandingNonADMsgsTo(List<JCSMPXMLMessage> msgs) {
    }

    @Override
    public PubADManager getADSettings() {
        return null;
    }

    @Override
    public DeliveryMode getDefaultDeliveryMode() {
        return DeliveryMode.DIRECT;
    }

    @Override
    public boolean isExplicitAckEnabled() {
        return this._pubExplicitAckEnabled;
    }

    @Override
    public boolean connected() {
        return this._smfClient.isClientConnected();
    }

    public boolean socketConnected() {
        return this._smfClient.connected();
    }

    @Override
    public void open() throws JCSMPException {
        super.open();
        this.open(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(boolean isReconn) throws JCSMPException {
        if (this.socketConnected()) {
            return;
        }
        try {
            if (!isReconn && this.connected()) {
                Trace.info((Object)"TcpClientChannel:open(isReconn=false) while connected, return.");
                return;
            }
            if (!isReconn) {
                this._smfClient.initState();
            }
            if (!this._ever_connected) {
                block12: {
                    Object object = this._channelReconStgyLock;
                    synchronized (object) {
                        this._channelReconStgy = new ReconnectStartNotYetInitConnected();
                    }
                    this._ever_connected = true;
                    int tries = this.properties.getConnectRetries() == -1 ? Integer.MAX_VALUE : this.properties.getConnectRetries();
                    ClientChannelConnect c_task = new ClientChannelConnect(Math.max(tries, 1), this.properties.getReconnectRetryWaitInMillis(), this.attemptsPerHost);
                    try {
                        c_task.call();
                    }
                    catch (Exception e) {
                        if (e instanceof JCSMPException) {
                            throw (JCSMPException)((Object)e);
                        }
                        if (!(e instanceof RuntimeException)) break block12;
                        throw (RuntimeException)e;
                    }
                }
                return;
            }
            this.performOpenSingle(isReconn);
        }
        catch (JCSMPException e) {
            this.close();
            throw e;
        }
    }

    private void performOpenSingle(boolean isReconn) throws JCSMPException {
        switch (this._channelMode) {
            case CLIENT: 
            case SUBDATA: 
            case PUBDATA: {
                this._opStrategy.performOpen(isReconn);
                break;
            }
        }
    }

    public void updateClientDescription(String clientDesc) throws JCSMPException {
        Trace.debug((Object)String.format("Update ClientDescription to: %s", clientDesc));
        this._opStrategy.updateClientDescription(clientDesc);
    }

    public void updateClientName(String uniqueName, String defaultName) throws JCSMPException {
        Trace.debug((Object)String.format("Update ClientName to: %s", uniqueName));
        this._opStrategy.updateClientName(uniqueName, defaultName);
    }

    @Override
    public void cleanupBuffers() {
        super.cleanupBuffers();
    }

    @Override
    public void close() {
        this.close(false);
    }

    private void close(boolean isReconn) {
        this.stop();
        JCSMPTransportException cause = new JCSMPTransportException("Closing channel");
        if (!isReconn) {
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)("Channel Closed (smfclient " + this._smfClient.getSmfClientId() + ")"));
            }
            if (this._freqDisconnectFuture != null) {
                this._freqDisconnectFuture.cancel(false);
            }
            if (this._reconnectFuture != null) {
                this._reconnectFuture.cancel(false);
            }
            for (ClientRequestResponse activereq : this._outstandingReqs) {
                activereq.cancel(cause);
            }
            for (ClientRequestResponse activereq : this._subOutstandingReqs) {
                activereq.cancel(cause);
            }
            this._outstandingReqs.clear();
            this._subOutstandingReqs.clear();
        }
        if (this._smfClient != null) {
            try {
                this._smfClient.close(isReconn);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._sessionModeSup != null) {
            this._sessionModeSup.closeControlChannel();
        }
        if (this._subFlowMgr != null) {
            this._subFlowMgr.notifyTcpClientClosed(isReconn);
        }
        if (!isReconn) {
            this._ever_connected = false;
        }
    }

    private void registerChannelToReactor() {
        this._smfClient.registerClientRead();
    }

    @Override
    public void deregisterChannelToReactor() {
        this._smfClient.deregisterClientRead();
    }

    @Override
    public void resume() {
    }

    protected void finalize() throws Throwable {
        if (this.tl_maxlen_bbuf != null) {
            this.tl_maxlen_bbuf.set(null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int send(JCSMPXMLMessage[] entries, int offset, int length, boolean newMsg, JCSMPXMLMessageProducer producer, boolean allowBlock, Integer expectedChannelTag, boolean dropOnWouldBlock, boolean allowStateSub) throws JCSMPException {
        int retval;
        if (newMsg) {
            producer.waitOnSpinlockSendBlockedWithThrow();
        }
        ByteBuffer[] tmp_send_vec = this.tl_maxlen_bbuf.get();
        int tmp_send_count = 0;
        JCSMPXMLMessage first_msg_hack = null;
        try {
            int send_vec_count = 0;
            for (int i = offset; i < offset + length; ++i) {
                JCSMPXMLMessage message = entries[i];
                Destination destination = message.getDestinationSent();
                JCSMPXMLMessage jCSMPXMLMessage = first_msg_hack = first_msg_hack == null ? message : first_msg_hack;
                if (Trace.isDebugEnabled()) {
                    Trace.debug((Object)String.format("[%s] Want to send: " + message.toString(), this._sessionId));
                }
                this._opStrategy.checkSendDestination(destination);
                PubADManager pubAdManager = producer.getPubADManager();
                long msgId_64bit = 0L;
                msgId_64bit = message.getMessageIdLong();
                assert (msgId_64bit != -1L);
                if (producer.isTransacted()) {
                    this._opStrategy.buildSendMsgHeader(message, destination, msgId_64bit, pubAdManager.flow_Id, -1L, newMsg);
                } else {
                    this._opStrategy.buildSendMsgHeader(message, destination, msgId_64bit, pubAdManager.flow_Id, pubAdManager.pub_Id, newMsg);
                }
                send_vec_count += this.encodeToBBVector(message, this._smfEncoder, tmp_send_vec, send_vec_count);
                if (Trace.isDebugEnabled()) {
                    Trace.debug((Object)String.format("[%s] encoded to bufs: " + msgId_64bit, this._sessionId));
                }
                if (message.getDeliveryMode().equals((Object)DeliveryMode.DIRECT)) continue;
                this.sessionStats.setPublishedAD(true);
            }
            ByteBuffer[] send_vec = new ByteBuffer[send_vec_count];
            System.arraycopy(tmp_send_vec, 0, send_vec, 0, send_vec_count);
            tmp_send_count = send_vec_count;
            retval = this.sendPubMsgBuffer(send_vec, first_msg_hack, length, allowBlock, expectedChannelTag, dropOnWouldBlock, allowStateSub);
            if (retval == 0 && this._pubobserver != null) {
                this._pubobserver.handlePubMsgSent(first_msg_hack, producer);
            }
        }
        catch (JCSMPInterruptedException e) {
            try {
                if (this._pubobserver != null) {
                    this._pubobserver.handlePubMsgSent(first_msg_hack, producer);
                }
                throw e;
                catch (UnsupportedEncodingException e2) {
                    throw new JCSMPFatalErrorException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.cannotEncodeMsg"), e2);
                }
                catch (IOException e3) {
                    throw new JCSMPTransportException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.errorCommWithRouter"), e3);
                }
            }
            catch (Throwable throwable) {
                while (true) {
                    if (tmp_send_count < 0) {
                        throw throwable;
                    }
                    tmp_send_vec[tmp_send_count--] = null;
                }
            }
        }
        while (tmp_send_count >= 0) {
            tmp_send_vec[tmp_send_count--] = null;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendPubMsgBuffer(ByteBuffer[] outputMsgBB, JCSMPXMLMessage messageObj, int msgCount, boolean allowBlock, Integer expectedConnIdTag, boolean dropOnWouldBlock, boolean allowStateSub) throws JCSMPException {
        int handle_ret;
        int num_bytes = SimpleSmfClient.remainingBytes(outputMsgBB);
        JCSMPTransportException t_ex = null;
        try {
            t_ex = null;
            boolean isAd = JCSMPUtils.isAdMessage(messageObj);
            Integer expectedConnIdDropTag = isAd ? expectedConnIdTag : null;
            int smfwritecode = this._smfClient.doSmfSharedWrite(null, outputMsgBB, false, false, dropOnWouldBlock, allowStateSub, true, expectedConnIdDropTag, null, null, null, false);
            if (smfwritecode == 1) {
                Trace.debug((Object)"Couldn't send(), drop+reschedule AD message.");
                int n = smfwritecode;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (IOException e) {
            t_ex = new JCSMPTransportException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.errorCommWithRouter"), e);
        }
        catch (InterruptedException e) {
            messageObj.setSendAttemptedOnce(true);
            messageObj.incrementSendCount();
            this.startReconnect(new JCSMPTransportException("Message write interrupted", e), allowBlock);
            throw new JCSMPInterruptedException("Message write interrupted", e);
        }
        catch (JCSMPTransportException e) {
            t_ex = e;
        }
        finally {
            messageObj.setSendAttemptedOnce(true);
            messageObj.incrementSendCount();
            this.updateTxStats(messageObj, num_bytes, msgCount);
        }
        if (Trace.isErrorEnabled()) {
            if (t_ex != null && t_ex.getCause() != null && t_ex.getCause().getMessage() != null && t_ex.getCause().getMessage().contains("An operation on a socket could not be performed because the system lacked sufficient buffer space or because a queue was full")) {
                Trace.error((Object)("sendTrMsgBuffer exception from write: " + (Object)((Object)t_ex)), (Throwable)((Object)t_ex));
            }
        } else if (Trace.isDebugEnabled()) {
            Trace.debug((Object)("sendTrMsgBuffer exception from write: " + (Object)((Object)t_ex)));
        }
        if ((handle_ret = this.handleException((Exception)((Object)t_ex), allowBlock)) == 1 && t_ex != null) {
            throw t_ex;
        }
        return 0;
    }

    public void putRef(ContentBuffer cb, ByteBuffer[] vec, int pos) {
        ByteBuffer cbuf = cb.getByteBufferRefInternal();
        cbuf.position(cb.getLimit());
        cbuf.limit(cbuf.capacity());
        cbuf.flip();
        vec[pos] = cbuf;
    }

    private int encodeToBBVector(JCSMPXMLMessage msgToSend, SMFPubMsgHeaderEncoder smfEncoder, ByteBuffer[] vec, int vec_offset) throws IOException {
        ContentBuffer cb;
        int i = 1;
        if (msgToSend.getMetadataContentLength() > 0) {
            cb = msgToSend.getMetadataContentBuffer();
            this.putRef(cb, vec, vec_offset + i++);
        }
        if (msgToSend.getContentLength() > 0) {
            cb = msgToSend.getContentBuffer();
            this.putRef(cb, vec, vec_offset + i++);
        }
        if (msgToSend.getAttachmentContentLength() > 0) {
            cb = msgToSend.getAttachmentContentBuffer();
            this.putRef(cb, vec, vec_offset + i++);
        }
        if (msgToSend.getBinaryMetadataType() != -1) {
            ByteBuffer binMetadataBuf = this._binmetaEncoder.encodeBinaryMetadata(msgToSend.getBinaryMetadataType(), msgToSend.getBinaryMetadataCB());
            vec[vec_offset + i++] = ByteBuffer.wrap(binMetadataBuf.array(), binMetadataBuf.arrayOffset(), binMetadataBuf.limit());
        }
        SMFPubMsgHeaderBean encPubMsgHeader = msgToSend.getEncPubMsgHeader();
        int bytes_wr_header = smfEncoder.encodeHeader(encPubMsgHeader.getHeaderBuf(), encPubMsgHeader, 3);
        encPubMsgHeader.setHeaderBufLen(bytes_wr_header);
        encPubMsgHeader.dumpHeaderToDirectBB();
        vec[vec_offset] = encPubMsgHeader.getHeaderByteBuffer();
        vec[vec_offset].flip();
        return i;
    }

    @Override
    public void setADSettings(PubADManager winAdSettings) {
    }

    @Override
    public void setExplicitAckEnabled(boolean value) {
        this._pubExplicitAckEnabled = value;
    }

    @Override
    public void setObserver(CSMPPublisherChannelObserver observer) {
        this._pubobserver = observer;
    }

    @Override
    public void setProducerId(long value) {
        this._producerId = value;
    }

    @Override
    public void suspend() {
    }

    @Override
    public void synchSeqAllocator(long value) {
    }

    public final SeqNumAllocator getGeneralSeqAllocator() {
        return this._smfClient.getCtrl_seqAlloc();
    }

    public void setSessionModeSup(SessionModeSupport modeSup) {
        this._sessionModeSup = modeSup;
        this._channelData.sessionModeSup = modeSup;
    }

    @Override
    public void start() throws JCSMPException {
        if (this._state_started) {
            return;
        }
        this.registerChannelToReactor();
        if (this.properties.getKeepAliveIntervalInMillis() > 0) {
            Trace.debug((Object)String.format("Client channel (smfclient %s) starting KA timer", this._smfClient.getSmfClientId()));
            this.startKATimer();
        }
        this._state_started = true;
    }

    @Override
    public void stop() {
        if (!this._state_started) {
            return;
        }
        if (this.properties.getKeepAliveIntervalInMillis() > 0) {
            Trace.debug((Object)String.format("Client channel (smfclient %s) stopping KA timer", this._smfClient.getSmfClientId()));
            this.stopKATimer();
        }
        this.deregisterChannelToReactor();
        this._state_started = false;
    }

    public void startFreqDisconnect(Exception ex) {
        ReconnectFreqDisconnect reconnectFreqTask = new ReconnectFreqDisconnect(ex);
        this._freqDisconnectFuture = this._context.getExecutorService().submit(reconnectFreqTask);
        Trace.debug((Object)String.format("Enqueued frequency disconnect to executor (smfclient %s)", this._smfClient.getSmfClientId()));
    }

    @SolReserved
    public JndiMessage executeJndiQuery(JndiMessage request) throws JCSMPException {
        if (!this.connected()) {
            this.open(false);
        }
        SMFHeaderBean smfHeader = new SMFHeaderBean();
        smfHeader.setProtocol(14).setTtl(1).setSmfVersion(3);
        WireMessage wmsg = WireMessageFactory.createWith(smfHeader);
        wmsg.setFriendlyName("JNDI-Request");
        wmsg.setPayload(request.getPayload());
        WireMessage jndiResponse = this.doSmfSharedRequest(wmsg, null);
        SMFHeaderBean smfh = jndiResponse.getSmfHeader();
        int resp_code = smfh.getPm_respcode();
        if (resp_code != 200) {
            String resp_string = smfh.getPm_respstr();
            if (Trace.isInfoEnabled()) {
                Trace.debug((Object)("Error Response (" + resp_code + ") - " + resp_string));
            }
            JCSMPErrorResponseException ex = new JCSMPErrorResponseException(resp_code, resp_string, "", null);
            throw ex;
        }
        JndiMessageImpl jmsg = new JndiMessageImpl(smfh.getPm_respcode(), smfh.getPm_respstr(), jndiResponse.getPayload());
        return jmsg;
    }

    public void doSmpRequest(SmpHeaderBean request, boolean waitForConfirm) throws JCSMPException {
        if (!this.connected()) {
            this.open(false);
        }
        SMFHeaderBean smfHeader = new SMFHeaderBean();
        smfHeader.setProtocol(15).setTtl(1).setSmfVersion(3);
        WireMessage wmsg = WireMessageFactory.createWith(smfHeader, request);
        wmsg.setFriendlyName("SMP-SmpRequest");
        if (waitForConfirm) {
            request.setSmpFlags(request.getSmpFlags() | 8);
            WireMessage response = this.doSmfSharedRequest(wmsg, null);
            this.checkSmpResponseOK(response);
        } else {
            request.setSmpFlags(request.getSmpFlags() & 0xFFFFFFF7);
            this.doSmfSharedRequestNoResponse(wmsg, true);
        }
    }

    protected void checkSmpResponseOK(WireMessage wmsg) throws JCSMPErrorResponseException {
        SMFHeaderBean smfh = wmsg.getSmfHeader();
        int resp_code = smfh.getPm_respcode();
        if (resp_code != 200) {
            JCSMPErrorResponseException ex = this.createErrorResponseFromSmpFailure(wmsg);
            if (!this.shouldAbsorbSmpError(ex)) {
                throw ex;
            }
            Trace.debug((Object)("Exception ignored due to session configuration: " + (Object)((Object)ex)));
        }
    }

    private JCSMPErrorResponseException createErrorResponseFromSmpFailure(WireMessage wmsg) {
        SMFHeaderBean smfh = wmsg.getSmfHeader();
        int resp_code = smfh.getPm_respcode();
        SmpHeaderBean smp = (SmpHeaderBean)wmsg.getHeaderBean();
        String resp_string = smfh.getPm_respstr();
        if (smp.getEncodedQueueName() != null && smp.getEncodedQueueName().length > 0) {
            resp_string = resp_string + " - Queue '" + TlvCoderUtil.nullTermUtf8ToString(smp.getEncodedQueueName()) + "'";
        }
        if (smp.getEncodedClientName() != null && smp.getEncodedClientName().length > 0) {
            resp_string = resp_string + " - ClientName '" + TlvCoderUtil.nullTermUtf8ToString(smp.getEncodedClientName()) + "'";
        }
        if (smp.getEncodedUtf8Subscription() != null && smp.getEncodedUtf8Subscription().length > 0) {
            resp_string = resp_string + " - Topic '" + TlvCoderUtil.nullTermUtf8ToString(smp.getEncodedUtf8Subscription()) + "'";
        }
        if (Trace.isInfoEnabled()) {
            Trace.debug((Object)("Error Response (" + resp_code + ") - " + resp_string));
        }
        JCSMPErrorResponseException ex = new JCSMPErrorResponseException(resp_code, resp_string, "", this.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CSMP);
        return ex;
    }

    private JCSMPErrorResponseException createErrorResponseFromFailure(WireMessage wmsg, JCSMPErrorResponseSubcodeMapper.ErrorContext ectx) {
        SMFHeaderBean smfh = wmsg.getSmfHeader();
        int resp_code = smfh.getPm_respcode();
        String resp_string = smfh.getPm_respstr();
        JCSMPErrorResponseException ex = new JCSMPErrorResponseException(resp_code, resp_string, "", this.getNetworkInfoString(), ectx);
        return ex;
    }

    public void doSmfSharedRequestNoResponse(WireMessage request, boolean setCorrId) throws JCSMPException {
        long max_post_tries = Math.max(this.reconnectCount + 1, 1);
        JCSMPException opex = null;
        int tries = 0;
        while ((long)tries < max_post_tries) {
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)String.format("doSmfSharedReqNoResponse try=%s / max=%s %n", tries, max_post_tries));
            }
            if (setCorrId) {
                this.setReqCorrelationTag(request);
            }
            try {
                opex = null;
                this._smfClient.doSmfSharedWrite(request, null, false, false, false, false, true, false);
                return;
            }
            catch (IOException e) {
                opex = new JCSMPTransportException("transport exception", e);
            }
            catch (InterruptedException e) {
                opex = new JCSMPInterruptedException("Write interrupted", e);
            }
            catch (JCSMPException e) {
                opex = e;
            }
            this.handleException((Exception)((Object)opex), true);
            ++tries;
        }
        if (opex != null) {
            throw opex;
        }
    }

    public WireMessage doSmfSharedRequestRetryForever(WireMessage request, Integer idTag, Long corrId) throws JCSMPException {
        return this.doSmfSharedRequest(request, idTag, corrId, true);
    }

    public WireMessage doSmfSharedRequestRetryForever(WireMessage request, Integer idTag, Long corrId, boolean allowOnStateSub) throws JCSMPException {
        long max_tries = Math.max(this.reconnectCount + 1, 1);
        return this.doSmfSharedRequest(request, max_tries, idTag, corrId, true, allowOnStateSub);
    }

    public WireMessage doSmfSharedRequest(WireMessage request, Integer idTag) throws JCSMPException {
        return this.doSmfSharedRequest(request, idTag, null, false);
    }

    public WireMessage doSmfSharedRequest(WireMessage request, Integer idTag, Long corrId, boolean noReconnOnTimeout) throws JCSMPException {
        long max_post_tries = Math.max(this.reconnectCount + 1, 1);
        return this.doSmfSharedRequest(request, max_post_tries, idTag, corrId, noReconnOnTimeout);
    }

    public WireMessage doSmfSharedRequest(WireMessage request, long max_tries, Integer idTag) throws JCSMPException {
        return this.doSmfSharedRequest(request, max_tries, idTag, null, false);
    }

    public WireMessage doSmfSharedRequest(WireMessage request, long max_tries, Integer idTag, Long corrId, boolean noReconnOnTimeout) throws JCSMPException {
        return this.doSmfSharedRequest(request, max_tries, idTag, corrId, noReconnOnTimeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WireMessage doSmfSharedRequest(WireMessage request, long max_tries, Integer idTag, Long corrId, boolean noReconnOnTimeout, boolean allowOnStateSub) throws JCSMPException {
        JCSMPException opex = null;
        WireMessage response = null;
        int corr = 0;
        int tries = 0;
        while ((long)tries < max_tries) {
            boolean timeoutHappened = false;
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)String.format("doSmfSharedReq (smfclient %s) try=%s / max=%s %n", this._smfClient.getSmfClientId(), tries, max_tries));
            }
            corr = corrId != null ? corrId.intValue() : this.setReqCorrelationTag(request);
            ClientRequestResponse req = new ClientRequestResponse(request, this._context);
            req.setLastCorrelationTag(corr);
            Queue<ClientRequestResponse> queue = this._outstandingReqs;
            synchronized (queue) {
                this._outstandingReqs.add(req);
                try {
                    opex = null;
                    this._smfClient.doSmfSharedWrite(request, null, false, false, false, allowOnStateSub, true, idTag, this, req, corrId, false);
                    req.startTimer(this._readTimeoutInMillis);
                    response = req.getResponse();
                    return response;
                }
                catch (IOException e) {
                    try {
                        opex = new JCSMPTransportException("transport exception", e);
                        idTag = null;
                        catch (InterruptedException e2) {
                            opex = new JCSMPInterruptedException("Write interrupted", e2);
                            idTag = null;
                        }
                        catch (JCSMPException e3) {
                            if (e3.getMessage() != null && e3.getMessage().startsWith("ClientRequestResponse Timeout")) {
                                timeoutHappened = true;
                            }
                            opex = e3;
                            idTag = null;
                        }
                    }
                    catch (Throwable throwable) {
                        idTag = null;
                        throw throwable;
                    }
                }
                req.cancel(opex);
                this._outstandingReqs.remove(req);
                if (noReconnOnTimeout && timeoutHappened) continue;
            }
            ++tries;
            this.handleException((Exception)((Object)opex), true);
        }
        if (this._outstandingReqs.size() > 0) assert (false);
        if (opex == null) return null;
        throw opex;
    }

    public WireMessage doSmfSubSingleShotRequest(WireMessage request, boolean allowOnStateSub, boolean waitConfirm, TcpChannel.WriteBlockPolicy wpolicy, Integer idTag, Long corrId) throws JCSMPException {
        JCSMPException opex = null;
        WireMessage response = null;
        Trace.debug((Object)"doSmfSingleReq");
        int corr = corrId != null ? corrId.intValue() : this.setReqCorrelationTag(request);
        ClientRequestResponse req = new ClientRequestResponse(request, this._context);
        req.setLastCorrelationTag(corr);
        if (waitConfirm) {
            if (this._subOutstandingReqs.size() > 0) assert (false);
            this._subOutstandingReqs.add(req);
        }
        try {
            opex = null;
            boolean dropOnWouldBlock = wpolicy == TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE || wpolicy == TcpChannel.WriteBlockPolicy.DROP_AND_THROW || wpolicy == TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE;
            boolean allowCompleteOnReactor = wpolicy == TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE;
            int write_result = this._smfClient.doSmfSharedWrite(request, null, false, false, dropOnWouldBlock, allowOnStateSub, allowCompleteOnReactor, idTag, null, null, null, false);
            if (write_result == 1 && wpolicy != TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE) {
                throw new WriteDroppedException(this.getNetworkInfoString() + "Not ready to write client message, WriteBlockPolicy=" + (Object)((Object)wpolicy) + " SS=" + (Object)((Object)this._smfClient.getSharedSocketState()) + ", stack=" + ThreadUtil.getMyStackTrace());
            }
            if (waitConfirm) {
                req.startTimer(this._readTimeoutInMillis);
                response = req.getResponse();
            }
            return response;
        }
        catch (IOException e) {
            opex = new JCSMPTransportException("transport exception", e);
        }
        catch (InterruptedException e) {
            opex = new JCSMPInterruptedException("Request write interrupted", e);
        }
        catch (JCSMPException e) {
            opex = e;
        }
        catch (Exception e) {
            opex = new JCSMPException("exception", e);
        }
        req.cancel(opex);
        this._subOutstandingReqs.remove(req);
        throw opex;
    }

    public WireMessage doSmfBlockingRequestNoRetry(WireMessage request) throws JCSMPException {
        try {
            WireMessage response = this.doSmfSharedRequest(request, null);
            return response;
        }
        catch (JCSMPException ex) {
            this.handleException((Exception)((Object)ex), true);
            throw ex;
        }
    }

    private void reestablishSub() throws JCSMPException {
        this._opStrategy.establishP2pSub();
    }

    public int setReqCorrelationTag(WireMessage request) {
        long corr = this.getGeneralSeqAllocator().getNext24b();
        SMFHeaderBean smfh = request.getSmfHeader();
        smfh.deleteParameters(32);
        smfh.addParam(TlvParameterFactorySmf.instance().getCorrelationId(corr));
        return (int)corr;
    }

    @Override
    public void handleException(Exception ex) {
        this.handleException(ex, false);
    }

    @Override
    public void enqueuePriorityData(WireMessage msg) {
        this._smfClient.enqueuePriorityData(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReconnect(JCSMPException e, boolean allowBlockingRec) {
        Trace.info((Object)(this.getNetworkInfoString() + String.format("startReconnect(): Channel Closed Event (smfclient %s)", this._smfClient.getSmfClientId()) + "; exception: " + e.getMessage() + " cur_stack=" + ThreadUtil.getMyStackTraceOneLine()));
        if (this._subFlowMgr != null) {
            this._subFlowMgr.notifyActiveFlows(e);
        }
        Object object = this._channelReconStgyLock;
        synchronized (object) {
            this._channelReconStgy.set_lastException(e);
            try {
                this._channelReconStgy.startReconnect(e, allowBlockingRec);
            }
            catch (Exception excep) {
                Trace.info((Object)("Start reconnect failed: " + excep + "; cur_stack=" + ThreadUtil.getMyStackTraceOneLine()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleException(Exception ex, boolean allowBlockingRec) {
        JCSMPException e;
        if (!this._ever_connected) {
            return 0;
        }
        Trace.info((Object)(this.getNetworkInfoString() + String.format("handleException(): Channel Closed Event (smfclient %s)", this._smfClient.getSmfClientId())));
        Trace.debug((Object)(String.format("Client channel (smfclient %s) handling exception: ", this._smfClient.getSmfClientId()) + ex.getMessage() + " cur_stack=" + ThreadUtil.getMyStackTraceOneLine()));
        boolean needExDispatch = true;
        int ret = 0;
        if (ex instanceof IOException || ex instanceof JCSMPTransportException || ex instanceof InvalidMessageReceivedException || ex instanceof ArrayIndexOutOfBoundsException || ex instanceof CancelledKeyException || ex instanceof JCSMPInterruptedException) {
            Object strAbort;
            e = ex instanceof JCSMPTransportException ? (JCSMPException)((Object)ex) : new JCSMPTransportException(JCSMPRB.BUNDLE.getStringSafely("TcpSubscriberChannel.errorReadingDataFromUnderlyingConnection"), new SmfClientIOException(ex.getMessage(), this._smfClient.getConnCounter()));
            boolean abortReconnect = false;
            JCSMPTransportException transportEx = (JCSMPTransportException)e;
            if (this.isStaleTransportException(transportEx)) {
                abortReconnect = true;
                strAbort = String.format("Aborting reconnect, ignoring stale exception ((smfclient %s) counter=%s)", this._smfClient.getSmfClientId(), this._smfClient.getConnCounter());
                Trace.info((Object)(this.getNetworkInfoString() + (String)strAbort));
            }
            try {
                if (!abortReconnect) {
                    if (this._subFlowMgr != null) {
                        this._subFlowMgr.notifyActiveFlows(e);
                    }
                    strAbort = this._channelReconStgyLock;
                    synchronized (strAbort) {
                        this._channelReconStgy.set_lastException(e);
                        ret = this._channelReconStgy.startReconnect(e, allowBlockingRec);
                    }
                }
                needExDispatch = false;
            }
            catch (Exception excep) {
                needExDispatch = true;
            }
        } else {
            e = new JCSMPTransportException(JCSMPRB.BUNDLE.getStringSafely("TcpSubscriberChannel.unexpectedError") + ":" + ex.getMessage(), ex);
        }
        if (needExDispatch && !(ex instanceof JCSMPInterruptedException)) {
            this.dispatchEx(e);
        }
        return ret;
    }

    private boolean isStaleTransportException(JCSMPTransportException transportEx) {
        if (transportEx.getCause() instanceof SmfClientIOException) {
            int exConnectTag = ((SmfClientIOException)transportEx.getCause()).getTag();
            if (this._smfClient.getConnCounter() != exConnectTag) {
                return true;
            }
        }
        return false;
    }

    private void dispatchEx(JCSMPException e) {
        SubFlowManagerImpl subFlowMgr = this._subFlowMgr;
        CSMPPublisherChannelObserver pubObserver = this._pubobserver;
        TransactedSessionManager txSessionMgr = this._txsessionMgr;
        XASessionManager xaSessionMgr = this._xasessionMgr;
        ArrayList<FlowTask> waitingFlowList = new ArrayList<FlowTask>();
        ArrayList<FlowHandleImpl> activeFlowList = new ArrayList<FlowHandleImpl>();
        if (subFlowMgr != null) {
            subFlowMgr.buildDispatchChannelLists(waitingFlowList, activeFlowList);
        }
        ArrayList<JCSMPXMLMessageProducer> toNotify = new ArrayList<JCSMPXMLMessageProducer>();
        if (pubObserver != null) {
            pubObserver.buildDispatchProducerList(toNotify);
        }
        LinkedList<TransactedSessionImpl> to_close = new LinkedList<TransactedSessionImpl>();
        if (txSessionMgr != null) {
            txSessionMgr.buildDispatchTransactionsList(to_close);
        }
        LinkedList<XASessionImpl> to_close_xa = new LinkedList<XASessionImpl>();
        if (xaSessionMgr != null) {
            xaSessionMgr.buildDispatchTransactionsList(to_close_xa);
        }
        this.close(false);
        if (subFlowMgr != null) {
            subFlowMgr.dispatchChannelException(e, waitingFlowList, activeFlowList);
        }
        if (pubObserver != null) {
            pubObserver.handleException(new MsgIdInfo(null, null), e, this._producerId, false, toNotify);
        }
        if (txSessionMgr != null) {
            txSessionMgr.dispatchChannelException(e, to_close);
        }
        if (xaSessionMgr != null) {
            xaSessionMgr.dispatchChannelException(e, to_close_xa);
        }
    }

    public boolean processCtrlResponse(WireMessage response) {
        SMFHeaderBean smfHeader = response.getSmfHeader();
        int resp_corrtag = smfHeader.getPm_corrtag();
        ClientRequestResponse[] req = new ClientRequestResponse[]{this._subOutstandingReqs.peek(), this._outstandingReqs.peek()};
        boolean drop = true;
        for (ClientRequestResponse creq : req) {
            if (creq == null || creq.getLastCorrelationTag() != resp_corrtag) continue;
            if (creq == this._outstandingReqs.peek()) {
                this._outstandingReqs.poll();
            }
            if (creq == this._subOutstandingReqs.peek()) {
                this._subOutstandingReqs.poll();
            }
            creq.execute(response);
            drop = false;
            break;
        }
        if (drop && smfHeader.getProtocol() == 15 && smfHeader.getPm_respcode() != 200) {
            Trace.debug((Object)"Got uncorrelated SMP error response (non-blocking SMP).");
            drop = false;
            SmpHeaderBean smpHdr = (SmpHeaderBean)response.getHeaderBean();
            SessionEventArgsImpl ev = null;
            JCSMPErrorResponseException ex = null;
            if (smpHdr != null) {
                switch (smpHdr.getSmpMsgType()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        ex = this.createErrorResponseFromSmpFailure(response);
                        ev = new SessionEventArgsImpl(SessionEvent.SUBSCRIPTION_ERROR, ex.getResponsePhrase(), (Exception)((Object)ex), ex.getResponseCode());
                    }
                }
                if (!this.shouldAbsorbSmpError(ex)) {
                    this._smpRespInterceptState.handle(ev);
                } else {
                    Trace.debug((Object)("Exception ignored due to session configuration: " + (Object)((Object)ex)));
                }
            }
        }
        return !drop;
    }

    public void setSmpInterceptState(SmpInterceptState state) {
        this._smpRespInterceptState = state;
    }

    public SmpInterceptState getSmpRespInterceptState() {
        return this._smpRespInterceptState;
    }

    private boolean shouldAbsorbSmpError(JCSMPErrorResponseException ex) {
        boolean absorbError = false;
        absorbError |= this._session_ign_duplicatesub && ex.getSubcodeEx() == 13;
        return absorbError |= this._session_ign_notfoundsub && ex.getSubcodeEx() == 14;
    }

    @Override
    public void handleMessage(WireMessage msg) {
        WireMessage validatedMsg;
        this.resetKeepAlivesSent();
        SMFHeaderBean wmsg_header = msg.getSmfHeader();
        if (wmsg_header.getSmfVersion() != 2 && wmsg_header.getSmfVersion() != 3) {
            StringBuffer exMsg = new StringBuffer(JCSMPRB.BUNDLE.getStringSafely("version mismatch"));
            exMsg.append(", expected ").append(3);
            exMsg.append(", received ").append(wmsg_header.getSmfVersion());
            this.handleException((Exception)((Object)new InvalidMessageReceivedException(exMsg.toString())), false);
        }
        if ((validatedMsg = this.validateUH(msg)) == null) {
            return;
        }
        int smfProtocol = wmsg_header.getProtocol();
        if (smfProtocol == 13 || smfProtocol == 3 || smfProtocol == 16) {
            if (wmsg_header.getPm_respcode() != -1) {
                if (this._pubobserver != null) {
                    this._pubobserver.handlePubMsgResponse(msg);
                }
            } else {
                this.handlePubMsg(validatedMsg);
            }
        } else {
            if (smfProtocol == 11 || smfProtocol == 10) {
                return;
            }
            if (smfProtocol == 15 || smfProtocol == 12 || smfProtocol == 9 || smfProtocol == 19 || smfProtocol == 14) {
                AssuredCtrlHeaderBean aBean;
                int encap_param_uhcheck;
                HeaderDescriptionBean encap_hdr_bean = validatedMsg.getHeaderBean();
                if (encap_hdr_bean != null && (encap_param_uhcheck = SmfUhUtil.testValidateUHParams(encap_hdr_bean, this.sessionStats)) == 2) {
                    return;
                }
                if (smfProtocol == 9 && (aBean = (AssuredCtrlHeaderBean)validatedMsg.getHeaderBean()) != null && aBean.getMsgType() == 3) {
                    this._pubobserver.handlePubMsgResponse(validatedMsg);
                    return;
                }
                SMFHeaderBean smfHeader = validatedMsg.getSmfHeader();
                validatedMsg.setSmfHeader(new SMFHeaderBean(smfHeader));
                boolean consumedCtrlMsg = this.processCtrlResponse(validatedMsg);
                if (!(consumedCtrlMsg || smfProtocol != 9 && smfProtocol != 19)) {
                    this.handleAssuredCtrlMsg(validatedMsg);
                }
            } else {
                Trace.info((Object)String.format("Received message with unknown protocol %s (ignoring).", smfProtocol));
                this.sessionStats.incStat(StatType.SMF_DISCARDS_UNKNOWN_ELEMENT);
            }
        }
    }

    private void handleAssuredCtrlMsg(WireMessage validatedMsg) {
        AssuredCtrlHeaderBean assctrlHdr = (AssuredCtrlHeaderBean)validatedMsg.getHeaderBean();
        if (assctrlHdr == null) {
            Trace.info((Object)"Ignoring empty ADCTRL.");
            return;
        }
        int adctrlMsgType = assctrlHdr.getMsgType();
        switch (adctrlMsgType) {
            case 3: {
                this._pubobserver.handlePubMsgResponse(validatedMsg);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this._subFlowMgr.handleAssuredCtrlMessage(validatedMsg);
                break;
            }
            case 12: {
                this._subFlowMgr.handleAssuredFlowChangeUpdateMessage(validatedMsg);
                break;
            }
            case 0: {
                break;
            }
            case 7: {
                if (validatedMsg.getSmfHeader().getPm_corrtag() != -1) break;
                this._pubobserver.handleAsyncCloseFlow(validatedMsg);
                break;
            }
            case 11: {
                this._txsessionMgr.handleAsyncAssuredCtrlMessage(validatedMsg);
                break;
            }
            case 14: {
                this._xasessionMgr.handleAsyncAssuredCtrlMessage(validatedMsg);
                break;
            }
        }
    }

    private void handlePubMsg(WireMessage validatedMsg) {
        JCSMPXMLMessage m = null;
        SMFHeaderBean wmsg_header = validatedMsg.getSmfHeader();
        try {
            m = this.recvPubMsg(validatedMsg);
        }
        catch (Exception e) {
            this.handleException(e, false);
        }
        if (m != null && this._subFlowMgr != null) {
            this.updateRxStats(wmsg_header.getMsgTotalLenWithHeader(), m);
            this._subFlowMgr.handlePubMessage(m);
        }
    }

    private JCSMPXMLMessage recvPubMsg(WireMessage _wmsg) throws JCSMPException {
        Long expiration;
        JCSMPXMLMessage message = TcpClientChannel.parse(this.getGeneralSeqAllocator(), _wmsg, this._channelMode);
        SMFHeaderBean wmsg_header = _wmsg.getSmfHeader();
        if (wmsg_header.isPm_ad_redelflag() || wmsg_header.isPm_ad_flowredelflag()) {
            message.setRedelivered(true);
            if (this.seqCounter == Integer.MAX_VALUE) {
                this.seqCounter = 0;
            }
            message.setSeqNum(this.seqCounter++);
            if (wmsg_header.isPm_ad_flowredelflag()) {
                message.setForceRedeliveredFlag(true);
            }
        }
        if ((expiration = message.getExpirationBinaryMeta()) == null) {
            long ttl = message.getTimeToLive();
            if (ttl > 0L && this._session_calculateExpiration) {
                message.setExpiration(ttl + System.currentTimeMillis());
            }
        } else {
            message.setExpiration(expiration);
        }
        return message;
    }

    public static JCSMPXMLMessage parse(SeqNumAllocator seqAllocator, WireMessage _wmsg, ChannelMode parseMode) throws JCSMPException {
        HashMap<Integer, ContentBuffer> mapbinmeta;
        SMFHeaderBean wmsg_header = _wmsg.getSmfHeader();
        int msgContentLength = wmsg_header.getMsgLen();
        int[][] m_el = null;
        if (wmsg_header.getPm_content_summ() != null) {
            MessageElementDescription[] descriptions = TlvParameterParser.getMessageContentSummary(wmsg_header.getPm_content_summ());
            m_el = TlvParameterParser.parseMessageContentSummary(descriptions);
            msgContentLength = 0;
        }
        JCSMPGenericXMLMessage xmlMessage = JCSMPBasicSession.createGenericXMLMessage(msgContentLength, false, false);
        PubMsgHeaderDecodingSupport.populateMessageCommonParameters(seqAllocator, wmsg_header, xmlMessage);
        if (m_el != null && m_el[3][1] > 0) {
            xmlMessage.writeCidListData(_wmsg.getPayload(), m_el[3][0], m_el[3][1]);
        }
        if (m_el != null && m_el[0][1] > 0) {
            xmlMessage.writeMetadata(_wmsg.getPayload(), m_el[0][0], m_el[0][1]);
        }
        if (m_el != null && m_el[2][1] >= 0) {
            xmlMessage.writeAttachment(_wmsg.getPayload(), m_el[2][0], m_el[2][1]);
        }
        if (m_el != null && m_el[4][1] > 0 && (mapbinmeta = BinaryMetadataEncoder.decodeBinaryMetadata(_wmsg.getPayload(), m_el[4][0], m_el[4][1])).size() > 0) {
            ArrayList<Map.Entry<Integer, ContentBuffer>> bm_elems = new ArrayList<Map.Entry<Integer, ContentBuffer>>();
            bm_elems.addAll(mapbinmeta.entrySet());
            int type = (Integer)((Map.Entry)bm_elems.get(0)).getKey();
            ContentBuffer cbuf = (ContentBuffer)((Map.Entry)bm_elems.get(0)).getValue();
            xmlMessage.setBinaryMetadataCB(cbuf, type);
        }
        if (m_el != null && m_el[1][1] > 0) {
            xmlMessage.writeBytes(_wmsg.getPayload(), m_el[1][0], m_el[1][1]);
        } else if (m_el == null) {
            switch (parseMode) {
                case CLIENT: {
                    xmlMessage.writeAttachment(_wmsg.getPayload());
                    break;
                }
                case SUBDATA: {
                    xmlMessage.writeBytes(_wmsg.getPayload());
                    break;
                }
            }
            if (_wmsg.getPayload().length == 0) {
                xmlMessage.clearAttachment();
            }
        }
        TcpClientChannel.populateDestinationReceived(xmlMessage, wmsg_header);
        xmlMessage.setReceiveTimestamp(_wmsg.getRxTimestamp());
        return xmlMessage;
    }

    private static void populateDestinationReceived(JCSMPGenericXMLMessage xmlMessage, SMFHeaderBean wmsg_header) {
        xmlMessage.setDestinationReceivedBytes(wmsg_header.getPm_tr_topicname_bytes());
    }

    public int sendAdCtrlRequest(WireMessage msgReq, boolean allowOnStateSub, TcpChannel.WriteBlockPolicy wpolicy, boolean stopOnNoconnection) throws JCSMPException {
        JCSMPException opex = null;
        try {
            opex = null;
            boolean dropOnWouldBlock = false;
            boolean allowCompleteOnReactor = false;
            switch (wpolicy) {
                case DEFAULT: {
                    dropOnWouldBlock = false;
                    allowCompleteOnReactor = true;
                    break;
                }
                case DROP_AND_IGNORE: 
                case DROP_AND_THROW: {
                    dropOnWouldBlock = true;
                    allowCompleteOnReactor = false;
                    break;
                }
                case RESCHED_OK_BUT_NO_BLOCK_ON_STATE: {
                    dropOnWouldBlock = true;
                    allowCompleteOnReactor = true;
                }
            }
            int writecode = this._smfClient.doSmfSharedWrite(msgReq, null, false, false, dropOnWouldBlock, allowOnStateSub, allowCompleteOnReactor, stopOnNoconnection);
            if (writecode == 1) {
                Trace.debug((Object)String.format("Not ready to write outgoing AdCtrlRequest (smfclient %s), WriteBlockPolicy=%s", new Object[]{this._smfClient.getSmfClientId(), wpolicy}));
                if (wpolicy == TcpChannel.WriteBlockPolicy.DROP_AND_THROW || wpolicy == TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE) {
                    throw new WriteDroppedException(String.format("Not ready to write on (smfclient %s), an AdCtrl message.", this._smfClient.getSmfClientId()));
                }
                return 1;
            }
            if (writecode == 2) {
                return 2;
            }
            return 0;
        }
        catch (IOException e) {
            opex = new JCSMPTransportException("transport exception", e);
        }
        catch (InterruptedException e) {
            opex = new JCSMPInterruptedException("sendAdCtrlRequest interrupted", e);
        }
        catch (JCSMPException e) {
            opex = e;
        }
        if (wpolicy != TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE) {
            this.handleException((Exception)((Object)opex), false);
        }
        return 0;
    }

    public void sendBindRequest(Endpoint bindTo, Topic topicName, int winSz, int corrTag, boolean allowOnStateSub, String flowName, AssuredCtrlEnums.FlowType flowType, long lastMsgIdAcked, long lastMsgIdRecved, String sqlSelector, EndpointProperties tmpEpCreateProperties, Long transactedSessionId, boolean noLocal, boolean activeFlowIndication, TcpChannel.WriteBlockPolicy wpolicy, ReplayStartLocation startLocation, Long endpointErrorId) throws JCSMPException {
        WireMessage msgReq = this._clientMsgFactory.getAdCtrlBind(bindTo, topicName, winSz, corrTag, flowName, flowType, lastMsgIdAcked, lastMsgIdRecved, sqlSelector, tmpEpCreateProperties, transactedSessionId, noLocal, activeFlowIndication, startLocation, endpointErrorId);
        this.sendAdCtrlRequest(msgReq, allowOnStateSub, wpolicy, false);
    }

    @Override
    public boolean sendUnbindRequest(long flowId, Integer corrTag, boolean allowOnStateSub, boolean linger, TcpChannel.WriteBlockPolicy wpolicy, Long lastMsgIdAcked) throws JCSMPException {
        return this.sendUnbindRequest(flowId, corrTag, allowOnStateSub, linger, wpolicy, lastMsgIdAcked, null);
    }

    public boolean sendUnbindRequest(long flowId, Integer corrTag, boolean allowOnStateSub, boolean linger, TcpChannel.WriteBlockPolicy wpolicy, Long lastMsgIdAcked, Long errorId) throws JCSMPException {
        WireMessage msgReq = null;
        msgReq = this._clientMsgFactory.getUnbindRequest(flowId, corrTag, linger, lastMsgIdAcked, errorId);
        int retcode = this.sendAdCtrlRequest(msgReq, allowOnStateSub, wpolicy, true);
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)String.format("sendUnbindRequest (smfclient %s) sendAdCtrlRequest Response %s for flowId %s", this._smfClient.getSmfClientId(), retcode, flowId));
        }
        if (retcode == 1) {
            this.enqueuePriorityData(msgReq);
        } else if (retcode == 2) {
            return false;
        }
        return true;
    }

    @Override
    public void sendUnsubscribeRequest(String endpointName, int corrTag, boolean allowOnStateSub, TcpChannel.WriteBlockPolicy wpolicy) throws JCSMPException {
        WireMessage msgReq = this._clientMsgFactory.getUnsubscribeRequest(endpointName, corrTag);
        this.sendAdCtrlRequest(msgReq, allowOnStateSub, wpolicy, false);
    }

    public void sendFlowChangeUpdateResponse(long flowId, boolean activeFlowIndication, int respCode, String respString) {
        JCSMPException opex = null;
        try {
            opex = null;
            WireMessage msgReq = this._clientMsgFactory.getFlowChangeUpdateResponse(flowId, activeFlowIndication, respCode, respString);
            int writecode = this._smfClient.doSmfSharedWrite(msgReq, null, false, false, true, false, false, false);
            if (writecode == 1) {
                Trace.debug((Object)String.format("DROP: Not ready to write outgoing FlowChangeUpdateResponse, (smfclient %s), flowId=%s", this._smfClient.getSmfClientId(), flowId));
            }
            return;
        }
        catch (IOException e) {
            opex = new JCSMPTransportException("transport exception", e);
        }
        catch (InterruptedException e) {
            opex = new JCSMPInterruptedException("sendFlowChangeUpdateResponse interrupted", e);
        }
        catch (JCSMPException e) {
            opex = e;
        }
        this.handleException((Exception)((Object)opex), false);
    }

    @Override
    public SubFlowManagerImpl getSubFlowManager() {
        return this._subFlowMgr;
    }

    @Override
    public void setSubFlowManager(SubFlowManagerImpl subFlowMgr) {
        this._subFlowMgr = subFlowMgr;
    }

    public void setTransactedSessionMgr(TransactedSessionManager _txsessionMgr) {
        this._txsessionMgr = _txsessionMgr;
    }

    public TransactedSessionManager getTransactedSessionMgr() {
        return this._txsessionMgr;
    }

    public void setXASessionMgr(XASessionManager xasessionMgr) {
        this._xasessionMgr = xasessionMgr;
    }

    public XASessionManager getXASessionMgr() {
        return this._xasessionMgr;
    }

    @Override
    public int sendAckMessage(WireMessage ackMsg, boolean allowOnStateSub, boolean allowReactorFinishWrite) throws JCSMPException {
        try {
            int ret = this._smfClient.doSmfSharedWrite(ackMsg, null, false, false, true, allowOnStateSub, allowReactorFinishWrite, false);
            return ret;
        }
        catch (InterruptedException ie) {
            Trace.warn((Object)("sendAckMessage interrupted: " + ackMsg.toString()));
            this.startReconnect(new JCSMPTransportException("write interrupted.", ie), false);
            throw new JCSMPInterruptedException("write interrupted.", ie);
        }
        catch (Exception e) {
            this.handleException((Exception)((Object)new JCSMPTransportException("Error occurred sending ADCTRL message.", e)), false);
            return 0;
        }
    }

    @Override
    public JCSMPReconnectEventHandler getReconnectHandler() {
        return this._reconEvtHandler;
    }

    @Override
    public void setReconnectEventHandler(JCSMPReconnectEventHandler handler) {
        this._reconEvtHandler = handler;
    }

    @Override
    public boolean isAutoReconnector() {
        return true;
    }

    @Override
    public boolean isUserCloseable() {
        return this._opStrategy.isUserCloseable();
    }

    private List<HostInfo> getModeAwareHostList() {
        return this._opStrategy.getModeAwareHostList();
    }

    @Override
    public void sendBindRequest(Endpoint bindTo, Topic topicName, int winSz, int corrTag, boolean allowOnStateSub, String flowName, AssuredCtrlEnums.FlowType flowType, long lastMsgIdAcked, long lastMsgIdRecved, String sqlSelector, EndpointProperties tmpEpCreateProperties, Long transactedSessionId, boolean noLocal, boolean activeFlowIndication, TcpChannel.WriteBlockPolicy wpolicy) throws JCSMPException {
        this.sendBindRequest(bindTo, topicName, winSz, corrTag, allowOnStateSub, flowName, flowType, lastMsgIdAcked, lastMsgIdRecved, sqlSelector, tmpEpCreateProperties, transactedSessionId, noLocal, activeFlowIndication, wpolicy, null, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClientChannelConnect
    implements Callable<Object> {
        final long _reconnectAttempts;
        final int _reconnectRetryWait;
        final int _attemptsPerHost;
        Exception _cause;
        final List<HostInfo> hostList;

        public ClientChannelConnect(int reconnectAttempts, int reconnectRetryWait, int attemptsPerHost) {
            this.hostList = TcpClientChannel.this.getModeAwareHostList();
            this._reconnectAttempts = (long)reconnectAttempts * (long)this.hostList.size();
            this._reconnectRetryWait = reconnectRetryWait;
            this._attemptsPerHost = attemptsPerHost;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            long attemptsPerHost;
            boolean success = false;
            long l = attemptsPerHost = this._attemptsPerHost == -1 ? Integer.MAX_VALUE : (long)this._attemptsPerHost;
            block10: for (long attempts = 0L; attempts < this._reconnectAttempts; ++attempts) {
                int this_host_attempts = 0;
                while ((long)this_host_attempts <= attemptsPerHost) {
                    Object object = TcpClientChannel.this._channelReconStgyLock;
                    synchronized (object) {
                        TcpClientChannel.this._channelReconStgy.set_lastException(null);
                    }
                    try {
                        int hostListIdx = (int)(attempts % (long)this.hostList.size());
                        HostInfo cur_router = this.hostList.get(hostListIdx);
                        TcpClientChannel.this.close(true);
                        TcpClientChannel.this._smfClient = cur_router.isSecure() ? TcpClientChannel.this._smfSecureClient : TcpClientChannel.this._smfNonSecureClient;
                        TcpClientChannel.this._smfClient.setRemoteHost(cur_router);
                        ((TcpClientChannel)TcpClientChannel.this)._channelData.smfClient = TcpClientChannel.this._smfClient;
                        TcpClientChannel.this._smfClient.initState();
                        Trace.info((Object)String.format("Connecting to host '%s' (host %s of %s, smfclient %s, attempt %s of %s, this_host_attempt: %s of %s)", cur_router, hostListIdx + 1, this.hostList.size(), TcpClientChannel.this._smfClient.getSmfClientId(), attempts + 1L, this._reconnectAttempts, this_host_attempts + 1, attemptsPerHost + 1L));
                        TcpClientChannel.this.performOpenSingle(true);
                        Trace.info((Object)String.format("Connected to host '%s' (smfclient %s)", cur_router, TcpClientChannel.this._smfClient.getSmfClientId()));
                        TcpClientChannel.this.reestablishSub();
                        if (TcpClientChannel.this._subFlowMgr != null) {
                            TcpClientChannel.this._subFlowMgr.setLastHostSpec(cur_router.getHost());
                        }
                        Object object2 = TcpClientChannel.this._channelReconStgyLock;
                        synchronized (object2) {
                            JCSMPException lstEx = TcpClientChannel.this._channelReconStgy.get_lastException();
                            if (lstEx instanceof JCSMPTransportException) {
                                if (!TcpClientChannel.this.isStaleTransportException((JCSMPTransportException)lstEx)) {
                                    Trace.debug((Object)String.format("ChannelReconnectStrategy:getLastException on (smfclient %s): not stale, rethrowing %s", new Object[]{TcpClientChannel.this._smfClient.getSmfClientId(), lstEx}));
                                    throw TcpClientChannel.this._channelReconStgy.get_lastException();
                                }
                            } else if (lstEx != null) {
                                Trace.debug((Object)String.format("ChannelReconnectStrategy:getLastException on (smfclient %s): rethrowing %s", new Object[]{TcpClientChannel.this._smfClient.getSmfClientId(), lstEx}));
                                throw TcpClientChannel.this._channelReconStgy.get_lastException();
                            }
                            TcpClientChannel.this._channelReconStgy = new ReconnectStartOnceConnected();
                        }
                        success = true;
                        TcpClientChannel.this._reconMgr.notifyReconnectOccurred();
                        break block10;
                    }
                    catch (JCSMPException ex) {
                        boolean end_of_list;
                        this._cause = ex;
                        boolean isRetryable = JCSMPUtils.isRetryableConnectionErrorAA(ex, TcpClientChannel.this._session.getGdReconnectFailAction());
                        if (isRetryable) {
                            Trace.info((Object)(String.format("Connection attempt failed to host '%s'", TcpClientChannel.this._smfClient.getRemoteHost()) + " ConnectException " + (Object)((Object)ex) + (ex.getCause() != null ? " cause: " + ex.getCause() : "") + " (" + TcpClientChannel.this.getNetworkInfoString() + ")"));
                        }
                        if (!isRetryable || attempts >= this._reconnectAttempts) break block10;
                        boolean more_attempts_curhost = (long)this_host_attempts < attemptsPerHost;
                        boolean bl = end_of_list = !more_attempts_curhost && attempts % (long)this.hostList.size() == (long)(this.hostList.size() - 1);
                        if (more_attempts_curhost || end_of_list) {
                            try {
                                Thread.sleep(this._reconnectRetryWait);
                            }
                            catch (Exception exception) {}
                        }
                        ++this_host_attempts;
                    }
                }
            }
            if (!success) {
                throw this._cause;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReconnectFreqDisconnect
    implements Callable<Object> {
        final Exception _ex;

        public ReconnectFreqDisconnect(Exception ex) {
            this._ex = ex;
        }

        @Override
        public Object call() throws Exception {
            TcpClientChannel.this.handleException(this._ex);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClientChannelReconnect
    implements Callable<Object> {
        final long _reconnectAttempts;
        final int _reconnectRetryWait;
        final int _attemptsPerHost;
        final JCSMPException _cause;
        final List<HostInfo> hostList;
        final int _rcid;
        final long _enqueueTimestamp;
        final boolean _contRecon;

        public ClientChannelReconnect(int reconnectAttempts, int reconnectRetryWait, int attemptsPerHost, JCSMPException cause, int rcid_count, boolean contRecon) {
            this.hostList = TcpClientChannel.this.getModeAwareHostList();
            this._reconnectAttempts = (long)reconnectAttempts * (long)this.hostList.size();
            this._reconnectRetryWait = reconnectRetryWait;
            this._attemptsPerHost = attemptsPerHost;
            this._cause = cause;
            this._rcid = rcid_count;
            this._enqueueTimestamp = TcpClientChannel.this._last_success_reconn_id.get();
            this._contRecon = contRecon;
        }

        public String toString() {
            return String.format("CCReconnect rcid=%s enqueueTs=%s", this._rcid, this._enqueueTimestamp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            long attempts;
            boolean success = false;
            long attemptsPerHost = this._attemptsPerHost == -1 ? Integer.MAX_VALUE : (long)this._attemptsPerHost;
            boolean firstTime = true;
            int lastSuccessId = TcpClientChannel.this._last_success_reconn_id.get();
            if (this._enqueueTimestamp < (long)lastSuccessId) {
                Trace.info((Object)String.format("ClientChannel (smfclient %s) Draining stale reconnection task (%s), last_success_reconn_tstamp=%s.", TcpClientChannel.this._smfClient.getSmfClientId(), this, lastSuccessId));
                TcpClientChannel.this._txsessionMgr.checkUnboundFlows(true);
                return null;
            }
            TcpClientChannel.this._session.reconnectInProgress(true);
            Throwable last_error = null;
            block7: for (attempts = 0L; attempts < this._reconnectAttempts; ++attempts) {
                int this_host_attempts = 0;
                while ((long)this_host_attempts <= attemptsPerHost) {
                    last_error = null;
                    if (TcpClientChannel.this._reconEvtHandler != null) {
                        boolean continue_reconnect;
                        if (firstTime) {
                            firstTime = false;
                            continue_reconnect = this._contRecon;
                        } else {
                            continue_reconnect = TcpClientChannel.this._reconEvtHandler.preReconnect();
                        }
                        if (!continue_reconnect) break block7;
                    }
                    if (!TcpClientChannel.this._ever_connected) {
                        Trace.info((Object)String.format("Draining stale reconnection task, channel is closed (rcid=%s).", this._rcid));
                        return null;
                    }
                    if (TcpClientChannel.this._session.hasSessionEventHandler()) {
                        SessionEventArgsImpl reconnectingEvent = new SessionEventArgsImpl(SessionEvent.RECONNECTING, null, (Exception)((Object)this._cause), 0);
                        TcpClientChannel.this._session.handleSessionEvent(reconnectingEvent);
                    }
                    try {
                        int hostListIdx = (int)(attempts % (long)this.hostList.size());
                        HostInfo cur_router = this.hostList.get(hostListIdx);
                        TcpClientChannel.this.close(true);
                        if (cur_router.isSecure()) {
                            ((SSLSmfClient)TcpClientChannel.this._smfSecureClient).reset();
                            TcpClientChannel.this._smfClient = TcpClientChannel.this._smfSecureClient;
                        } else {
                            TcpClientChannel.this._smfClient = TcpClientChannel.this._smfNonSecureClient;
                        }
                        TcpClientChannel.this._smfClient.setRemoteHost(cur_router);
                        ((TcpClientChannel)TcpClientChannel.this)._channelData.smfClient = TcpClientChannel.this._smfClient;
                        Trace.info((Object)String.format("Connecting to host '%s' (host %s of %s, smfclient %s, attempt %s of %s, this_host_attempt: %s of %s)", cur_router, hostListIdx + 1, this.hostList.size(), TcpClientChannel.this._smfClient.getSmfClientId(), attempts + 1L, this._reconnectAttempts, this_host_attempts + 1, attemptsPerHost + 1L));
                        TcpClientChannel.this.performOpenSingle(true);
                        int rtrMaxSupportedADCtrlVersion = 2;
                        Map caps = (Map)TcpClientChannel.this._session.getTransientData(JCSMPBasicSession.TransientData.CAP);
                        ArrayList rtrSupportedADCtrlVersions = (ArrayList)caps.get((Object)CapabilityType.SUPPORTED_ADCTRL_VERSIONS);
                        if (rtrSupportedADCtrlVersions != null) {
                            rtrMaxSupportedADCtrlVersion = (Integer)rtrSupportedADCtrlVersions.get(1);
                        }
                        if (TcpClientChannel.this._session.getNegotiatedMaxADCtrlVersion() > rtrMaxSupportedADCtrlVersion) {
                            throw new VersionNotSupportException(String.format("Router AD Ctrl version of %d is less than the negotiated %d - failing connect", rtrMaxSupportedADCtrlVersion, TcpClientChannel.this._session.getNegotiatedMaxADCtrlVersion()));
                        }
                        Trace.info((Object)String.format("Connected to host '%s' (smfclient %s)", cur_router, TcpClientChannel.this._smfClient.getSmfClientId()));
                        TcpClientChannel.this._smfClient.endReconnection(true, SimpleSmfClient.SS.SUB_ESTABLISH, null, 10000);
                        if (TcpClientChannel.this._txsessionMgr != null) {
                            TcpClientChannel.this._txsessionMgr.notifyConnectEvent(InternalConnectEvent.ofType(InternalConnectEvent.ConnectEventType.POST_RECONNECT).with(this._cause).with(cur_router.getHost()));
                        }
                        if (TcpClientChannel.this._xasessionMgr != null) {
                            TcpClientChannel.this._xasessionMgr.notifyConnectEvent(InternalConnectEvent.ofType(InternalConnectEvent.ConnectEventType.POST_RECONNECT).with(this._cause).with(cur_router.getHost()));
                        }
                        if (TcpClientChannel.this._subFlowMgr != null) {
                            try {
                                TcpClientChannel.this._subFlowMgr.notifyPostReconnect(this._cause, cur_router);
                                SmpInterceptState.SmpInterceptReapply reapplyIntercept = new SmpInterceptState.SmpInterceptReapply(TcpClientChannel.this);
                                TcpClientChannel.this.setSmpInterceptState(reapplyIntercept);
                                TcpClientChannel.this._session.reestablishSubCache();
                                TcpClientChannel.this.reestablishSub();
                                reapplyIntercept.checkNoErrorResponse();
                            }
                            finally {
                                TcpClientChannel.this.setSmpInterceptState(new SmpInterceptState.SmpInterceptNormal(TcpClientChannel.this));
                            }
                        }
                        if (TcpClientChannel.this._pubobserver != null) {
                            TcpClientChannel.this._pubobserver.notifyReconnected();
                        }
                        if (TcpClientChannel.this._xasessionMgr != null) {
                            TcpClientChannel.this._xasessionMgr.notifyConnectEvent(InternalConnectEvent.ofType(InternalConnectEvent.ConnectEventType.FLOWS_REBOUND));
                        }
                        success = true;
                        TcpClientChannel.this._reconMgr.notifyReconnectOccurred();
                        if (success) {
                            TcpClientChannel.this._last_success_reconn_id.incrementAndGet();
                        }
                        TcpClientChannel.this._smfClient.incrementConnCounterTag();
                        try {
                            TcpClientChannel.this._smfClient.endReconnection(success, SimpleSmfClient.SS.READY_TO_WRITE, SimpleSmfClient.SS.SUB_ESTABLISH, 10000);
                        }
                        catch (Throwable t) {
                            if (success) {
                                TcpClientChannel.this._last_success_reconn_id.decrementAndGet();
                            }
                            throw t;
                        }
                        if (TcpClientChannel.this._txsessionMgr != null) {
                            TcpClientChannel.this._txsessionMgr.notifyConnectEvent(InternalConnectEvent.ofType(InternalConnectEvent.ConnectEventType.FLOW_REBIND_FINISHED));
                        }
                        if (TcpClientChannel.this._xasessionMgr == null) break block7;
                        TcpClientChannel.this._xasessionMgr.notifyConnectEvent(InternalConnectEvent.ofType(InternalConnectEvent.ConnectEventType.FLOW_REBIND_FINISHED));
                        break block7;
                    }
                    catch (Throwable t) {
                        last_error = t;
                        if (t instanceof JCSMPException) {
                            boolean end_of_list;
                            JCSMPException ex = (JCSMPException)((Object)t);
                            Trace.info((Object)(String.format("Connection attempt failed to host '%s'", TcpClientChannel.this._smfClient.getRemoteHost()) + " ReconnectException " + (Object)((Object)ex) + (ex.getCause() != null ? " cause: " + ex.getCause() : "")));
                            if (!JCSMPUtils.isRetryableConnectionErrorAA(ex, TcpClientChannel.this._session.getGdReconnectFailAction()) || attempts >= this._reconnectAttempts) break block7;
                            boolean more_attempts_curhost = (long)this_host_attempts < attemptsPerHost;
                            boolean bl = end_of_list = !more_attempts_curhost && attempts % (long)this.hostList.size() == (long)(this.hostList.size() - 1);
                            if (more_attempts_curhost || end_of_list) {
                                Thread.sleep(this._reconnectRetryWait);
                            }
                        } else {
                            if (t instanceof IllegalStateException) {
                                Trace.info((Object)"Stale reconnect task, aborting reconnect.");
                                break block7;
                            }
                            Trace.error((Object)"Unexpected throwable thrown from ClientChannelReconnect::call(), aborting reconnect. ", t);
                            break block7;
                        }
                        ++this_host_attempts;
                    }
                }
            }
            TcpClientChannel.this._session.reconnectInProgress(false);
            if (attempts >= this._reconnectAttempts) {
                Trace.info((Object)"Stale reconnect task, aborting reconnect.");
            }
            if (!success) {
                String dispatch_err_msg = String.format("(%s) %s", ((Object)((Object)this._cause)).getClass().getSimpleName(), this._cause.getMessage());
                JCSMPTransportException reconnectException = new JCSMPTransportException(dispatch_err_msg, last_error);
                if (TcpClientChannel.this._session.hasSessionEventHandler()) {
                    SessionEventArgsImpl transportFailure = new SessionEventArgsImpl(SessionEvent.DOWN_ERROR, null, (Exception)((Object)reconnectException), 0);
                    TcpClientChannel.this._session.handleSessionEvent(transportFailure);
                }
                TcpClientChannel.this.dispatchEx(reconnectException);
                throw reconnectException;
            }
            ClientChannelReconnectedNotify reconnect_notify = new ClientChannelReconnectedNotify(TcpClientChannel.this._reconEvtHandler);
            Future<Object> f = TcpClientChannel.this._context.getConnectNotifyService().submit(reconnect_notify);
            Trace.debug((Object)String.format("ClientChannel enqueued OK reconnect notification (smfclient %s)", TcpClientChannel.this._smfClient.getSmfClientId()));
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClientChannelReconnectedNotify
    implements Callable<Object> {
        final JCSMPReconnectEventHandler _handler;

        public ClientChannelReconnectedNotify(JCSMPReconnectEventHandler handler) {
            this._handler = handler;
        }

        @Override
        public Object call() throws Exception {
            if (this._handler != null) {
                try {
                    this._handler.postReconnect();
                }
                catch (Throwable t) {
                    Trace.warn((Object)"Error occurred in JCSMPReconnectEventHandler: ", t);
                }
            }
            if (TcpClientChannel.this._session.hasSessionEventHandler()) {
                SessionEventArgsImpl reconnectedEvent = new SessionEventArgsImpl(SessionEvent.RECONNECTED, null, null, 0);
                TcpClientChannel.this._session.handleSessionEvent(reconnectedEvent);
            }
            TcpClientChannel.this._smfClient.endPostReconnect();
            return null;
        }
    }

    public static abstract class SmpInterceptState {
        final TcpClientChannel channel;

        public abstract void handle(SessionEventArgs var1);

        public SmpInterceptState(TcpClientChannel clientchannel) {
            this.channel = clientchannel;
        }

        public void checkNoErrorResponse() throws JCSMPException {
        }

        protected static final class SmpInterceptReapply
        extends SmpInterceptState {
            public final Queue<SessionEventArgs> events = new ConcurrentLinkedQueue<SessionEventArgs>();

            public SmpInterceptReapply(TcpClientChannel channel) {
                super(channel);
            }

            public void handle(SessionEventArgs ev) {
                JCSMPErrorResponseException err_resp;
                if (ev.getException() instanceof JCSMPErrorResponseException && (err_resp = (JCSMPErrorResponseException)((Object)ev.getException())).getSubcodeEx() == 13) {
                    return;
                }
                this.events.add(ev);
            }

            public void checkNoErrorResponse() throws JCSMPException {
                SessionEventArgs ev = null;
                while ((ev = this.events.poll()) != null) {
                    if (!(ev.getException() instanceof JCSMPErrorResponseException)) continue;
                    throw (JCSMPErrorResponseException)((Object)ev.getException());
                }
            }
        }

        protected static final class SmpInterceptNormal
        extends SmpInterceptState {
            public SmpInterceptNormal(TcpClientChannel channel) {
                super(channel);
            }

            public void handle(SessionEventArgs ev) {
                this.channel._session.handleSessionEvent(ev);
            }
        }
    }

    public final class ReconnectStartNotYetInitConnected
    extends ReconnectStartStrategy {
        public int startReconnect(JCSMPException cause, boolean allowBlock) throws Exception {
            Trace.debug((Object)String.format("ReconnectStartNotYetInitConnected:startreconnect on (smfclient %s)", TcpClientChannel.this._smfClient.getSmfClientId()));
            return 2;
        }
    }

    public final class ReconnectStartOnceConnected
    extends ReconnectStartStrategy {
        public void set_lastException(JCSMPException lastException) {
        }

        public int startReconnect(JCSMPException cause, boolean allowBlock) throws Exception {
            int ret = TcpClientChannel.this._smfClient.beginReconnection();
            if (ret == 3) {
                Trace.debug((Object)(String.format("Reconnect starting (smfclient %s) allowBlocking:", TcpClientChannel.this._smfClient.getSmfClientId()) + allowBlock));
                for (ClientRequestResponse activereq : TcpClientChannel.this._outstandingReqs) {
                    activereq.cancel(cause);
                }
                for (ClientRequestResponse activereq : TcpClientChannel.this._subOutstandingReqs) {
                    activereq.cancel(cause);
                }
                if (TcpClientChannel.this._txsessionMgr != null) {
                    TcpClientChannel.this._txsessionMgr.notifyConnectEvent(InternalConnectEvent.ofType(InternalConnectEvent.ConnectEventType.PRE_RECONNECT));
                }
                if (TcpClientChannel.this._xasessionMgr != null) {
                    TcpClientChannel.this._xasessionMgr.notifyConnectEvent(InternalConnectEvent.ofType(InternalConnectEvent.ConnectEventType.PRE_RECONNECT));
                }
                int tries = TcpClientChannel.this.reconnectCount;
                int wait = TcpClientChannel.this.properties.getReconnectRetryWaitInMillis();
                boolean continue_reconnect = true;
                if (TcpClientChannel.this._reconEvtHandler != null) {
                    continue_reconnect = TcpClientChannel.this._reconEvtHandler.preReconnect();
                }
                ClientChannelReconnect reconnect_task = new ClientChannelReconnect(tries, wait, TcpClientChannel.this.attemptsPerHost, cause, ++_rcid_counter, continue_reconnect);
                TcpClientChannel.this._reconnectFuture = TcpClientChannel.this._context.getExecutorService().submit(reconnect_task);
                Trace.debug((Object)String.format("Enqueued reconnect to executor (smfclient %s) (%s)", TcpClientChannel.this._smfClient.getSmfClientId(), reconnect_task));
                if (TcpClientChannel.this._subFlowMgr != null) {
                    TcpClientChannel.this._subFlowMgr.handleControllerException(cause);
                }
                return 3;
            }
            Trace.debug((Object)(String.format("ClientChannel (smfclient %s) Reconnection already started by another thread:", TcpClientChannel.this._smfClient.getSmfClientId()) + " allowblock:" + allowBlock));
            return ret;
        }
    }

    abstract class ReconnectStartStrategy {
        JCSMPException _lastException = null;

        ReconnectStartStrategy() {
        }

        public abstract int startReconnect(JCSMPException var1, boolean var2) throws Exception;

        public JCSMPException get_lastException() {
            return this._lastException;
        }

        public void set_lastException(JCSMPException lastException) {
            this._lastException = lastException;
        }
    }

    private static interface BufPutReference {
        public void putRef(ContentBuffer var1, ByteBuffer[] var2, int var3);
    }

    protected static class ChannelData {
        public JCSMPBasicSession session;
        public JCSMPProperties sessionProperties;
        public JCSMPChannelProperties channelProperties;
        public SimpleSmfClient smfClient;
        public String sessionId;
        public JCSMPSessionStats sessionStats;
        public String p2pTopicBase;
        public SessionModeSupport sessionModeSup;
        public List<HostInfo> hostList;

        protected ChannelData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChannelMode {
        PUBDATA{

            public ChannelOpStrategy newOpStgy(TcpClientChannel channel) {
                return new ChannelOpStrategyPubdata(channel);
            }
        }
        ,
        SUBDATA{

            public ChannelOpStrategy newOpStgy(TcpClientChannel channel) {
                return new ChannelOpStrategySubdata(channel);
            }
        }
        ,
        SUBCTRL{

            public ChannelOpStrategy newOpStgy(TcpClientChannel channel) {
                return null;
            }
        }
        ,
        CLIENT{

            public ChannelOpStrategy newOpStgy(TcpClientChannel channel) {
                return new ChannelOpStrategyClient(channel);
            }
        };


        public abstract ChannelOpStrategy newOpStgy(TcpClientChannel var1);
    }
}

