/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.queues;

import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.PubADManager;
import com.solacesystems.jcsmp.impl.queues.ProcessElementsTask;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalBoundedMessageQueue
implements Iterable<JCSMPXMLMessage> {
    private static final Log Trace = LogFactory.getLog(ConditionalBoundedMessageQueue.class);
    private final JCSMPXMLMessage[] items;
    private transient int takeIndex;
    private transient int putIndex;
    private volatile int count;
    private final Callable<?> onEnqueueOnFull;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    private final Condition notSuspened;
    private final Condition empty;
    private boolean suspended = false;
    private boolean active = true;

    final int inc(int i) {
        return ++i == this.items.length ? 0 : i;
    }

    private void insert(JCSMPXMLMessage x) {
        this.items[this.putIndex] = x;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
        this.notEmpty.signal();
    }

    private JCSMPXMLMessage extract() {
        JCSMPXMLMessage[] items = this.items;
        JCSMPXMLMessage x = items[this.takeIndex];
        items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        this.notFull.signal();
        if (this.count == 0) {
            this.empty.signalAll();
        }
        return x;
    }

    void removeAt(int i) {
        JCSMPXMLMessage[] items = this.items;
        if (i == this.takeIndex) {
            items[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
        } else {
            int nexti;
            while ((nexti = this.inc(i)) != this.putIndex) {
                items[i] = items[nexti];
                i = nexti;
            }
            items[i] = null;
            this.putIndex = i;
        }
        --this.count;
        this.notFull.signal();
        if (this.count == 0) {
            this.empty.signalAll();
        }
    }

    public ConditionalBoundedMessageQueue(int capacity, Callable<?> onEnqueueOnFull) {
        this(capacity, false, onEnqueueOnFull);
    }

    public ConditionalBoundedMessageQueue(int capacity, boolean fair, Callable<?> onEnqueueOnFull) {
        if (capacity < 0) {
            throw new IllegalArgumentException("queue size cannot be negative");
        }
        this.items = new JCSMPXMLMessage[capacity];
        this.lock = new ReentrantLock(fair);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
        this.notSuspened = this.lock.newCondition();
        this.empty = this.lock.newCondition();
        this.onEnqueueOnFull = onEnqueueOnFull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCSMPXMLMessage poll() {
        if (this.items.length == 0) {
            return null;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            JCSMPXMLMessage x;
            if (this.count == 0) {
                JCSMPXMLMessage jCSMPXMLMessage = null;
                return jCSMPXMLMessage;
            }
            JCSMPXMLMessage jCSMPXMLMessage = x = this.extract();
            return jCSMPXMLMessage;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean remove(Object o) {
        if (o == null || this.items.length == 0) {
            return false;
        }
        JCSMPXMLMessage[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int k = 0;
            while (true) {
                if (k++ >= this.count) {
                    boolean bl = false;
                    return bl;
                }
                if (o.equals(items[i])) {
                    this.removeAt(i);
                    boolean bl = true;
                    return bl;
                }
                i = this.inc(i);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public JCSMPXMLMessage peek() {
        if (this.items.length == 0) {
            return null;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            JCSMPXMLMessage jCSMPXMLMessage = this.count == 0 ? null : this.items[this.takeIndex];
            return jCSMPXMLMessage;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCSMPXMLMessage take() throws InterruptedException {
        if (this.items.length == 0) {
            return null;
        }
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            JCSMPXMLMessage x;
            try {
                while (this.count == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            JCSMPXMLMessage jCSMPXMLMessage = x = this.extract();
            return jCSMPXMLMessage;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMsgWithIdUpdate(JCSMPXMLMessage o, PubADManager adMgr) throws InterruptedException, InvalidOperationException {
        if (o == null) {
            throw new NullPointerException();
        }
        JCSMPXMLMessage[] items = this.items;
        if (items.length == 0) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.cannotSendAssuredMessageNotEnabled"));
        }
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            try {
                while (this.suspended || this.count == items.length) {
                    if (this.suspended) {
                        if (Trace.isDebugEnabled()) {
                            Trace.debug((Object)"Queue is suspended, wait....");
                        }
                        this.notSuspened.await();
                        continue;
                    }
                    if (this.count != items.length) continue;
                    if (Trace.isDebugEnabled()) {
                        Trace.debug((Object)"Queue is full, wait....");
                    }
                    try {
                        if (this.onEnqueueOnFull != null) {
                            this.onEnqueueOnFull.call();
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            throw (InterruptedException)e;
                        }
                        if (e instanceof InvalidOperationException) {
                            throw (InvalidOperationException)((Object)e);
                        }
                        throw new InvalidOperationException(e.toString());
                    }
                    this.notFull.await();
                }
            }
            catch (InterruptedException ie) {
                this.notSuspened.signal();
                this.notFull.signal();
                throw ie;
            }
            if (!this.active) {
                if (Trace.isDebugEnabled()) {
                    Trace.debug((Object)"Queue is closed");
                }
                throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
            }
            adMgr.setMessageIdParamsOnPubMessage(o);
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)String.format("Update message ID before enqueue it: " + o.toString(), new Object[0]));
            }
            this.insert(o);
        }
        finally {
            lock.unlock();
        }
    }

    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.items.length == this.count;
    }

    public int remainingCapacity() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.items.length - this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        JCSMPXMLMessage[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int k = 0;
            while (k++ < this.count) {
                if (o.equals(items[i])) {
                    boolean bl = true;
                    return bl;
                }
                i = this.inc(i);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        JCSMPXMLMessage[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] a = new Object[this.count];
            int k = 0;
            int i = this.takeIndex;
            while (k < this.count) {
                a[k++] = items[i];
                i = this.inc(i);
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCSMPXMLMessage[] toArray(JCSMPXMLMessage[] a) {
        JCSMPXMLMessage[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (a.length < this.count) {
                a = new JCSMPXMLMessage[this.count];
            }
            int k = 0;
            int i = this.takeIndex;
            while (k < this.count) {
                a[k++] = items[i];
                i = this.inc(i);
            }
            if (a.length > this.count) {
                a[this.count] = null;
            }
            JCSMPXMLMessage[] jCSMPXMLMessageArray = a;
            return jCSMPXMLMessageArray;
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        JCSMPXMLMessage[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int k = this.count;
            while (k-- > 0) {
                items[i] = null;
                i = this.inc(i);
            }
            this.count = 0;
            this.putIndex = 0;
            this.takeIndex = 0;
            this.notFull.signalAll();
            this.empty.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<JCSMPXMLMessage> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        JCSMPXMLMessage[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n;
            int i = this.takeIndex;
            int max = this.count;
            for (n = 0; n < max; ++n) {
                c.add(items[i]);
                items[i] = null;
                i = this.inc(i);
            }
            if (n > 0) {
                this.count = 0;
                this.putIndex = 0;
                this.takeIndex = 0;
                this.notFull.signalAll();
                this.empty.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<JCSMPXMLMessage> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        JCSMPXMLMessage[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n;
            int max;
            int i = this.takeIndex;
            int n2 = max = maxElements < this.count ? maxElements : this.count;
            for (n = 0; n < max; ++n) {
                c.add(items[i]);
                items[i] = null;
                i = this.inc(i);
            }
            if (n > 0) {
                this.count -= n;
                this.takeIndex = i;
                this.notFull.signalAll();
                this.empty.signalAll();
            }
            int n3 = n;
            return n3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyTo(Collection<JCSMPXMLMessage> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        JCSMPXMLMessage[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n;
            int i = this.takeIndex;
            int max = this.count;
            for (n = 0; n < max; ++n) {
                c.add(items[i]);
                i = this.inc(i);
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int msgIdRenumbering(long lastMsgIdSent) {
        JCSMPXMLMessage[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n;
            int i = this.takeIndex;
            int max = this.count;
            for (n = 0; n < max; ++n) {
                items[i].setPrevMessageId(lastMsgIdSent + (long)n);
                items[i].setNewMsgIdRequired(false);
                items[i].setMessageIdLong(lastMsgIdSent + (long)n + 1L);
                if (Trace.isDebugEnabled()) {
                    Trace.debug((Object)String.format("renumbering message: " + items[i].toString(), new Object[0]));
                }
                i = this.inc(i);
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    public void suspend() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)"Suspend message queue");
            }
            this.suspended = true;
        }
        finally {
            lock.unlock();
        }
    }

    public void resume() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)"Resume message queue");
            }
            this.suspended = false;
            this.notSuspened.signal();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processElements(ProcessElementsTask task) throws JCSMPException {
        if (task == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (task.getQueueToProcess() == this) {
                int n = task.process();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public void deactivate() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.active = false;
        }
        finally {
            lock.unlock();
        }
    }

    public void activate() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.active = true;
        }
        finally {
            lock.unlock();
        }
    }

    public void waitUntilEmpty() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count > 0) {
                this.empty.await();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<JCSMPXMLMessage> iterator() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Itr itr = new Itr();
            return itr;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<JCSMPXMLMessage> {
        private int nextIndex;
        private JCSMPXMLMessage nextItem;
        private int lastRet = -1;

        Itr() {
            if (ConditionalBoundedMessageQueue.this.count == 0) {
                this.nextIndex = -1;
            } else {
                this.nextIndex = ConditionalBoundedMessageQueue.this.takeIndex;
                this.nextItem = ConditionalBoundedMessageQueue.this.items[ConditionalBoundedMessageQueue.this.takeIndex];
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        private void checkNext() {
            if (this.nextIndex == ConditionalBoundedMessageQueue.this.putIndex) {
                this.nextIndex = -1;
                this.nextItem = null;
            } else {
                this.nextItem = ConditionalBoundedMessageQueue.this.items[this.nextIndex];
                if (this.nextItem == null) {
                    this.nextIndex = -1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JCSMPXMLMessage next() {
            ReentrantLock lock = ConditionalBoundedMessageQueue.this.lock;
            lock.lock();
            try {
                if (this.nextIndex < 0) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.nextIndex;
                JCSMPXMLMessage x = this.nextItem;
                this.nextIndex = ConditionalBoundedMessageQueue.this.inc(this.nextIndex);
                this.checkNext();
                JCSMPXMLMessage jCSMPXMLMessage = x;
                return jCSMPXMLMessage;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock lock = ConditionalBoundedMessageQueue.this.lock;
            lock.lock();
            try {
                int i = this.lastRet;
                if (i == -1) {
                    throw new IllegalStateException();
                }
                this.lastRet = -1;
                int ti = ConditionalBoundedMessageQueue.this.takeIndex;
                ConditionalBoundedMessageQueue.this.removeAt(i);
                this.nextIndex = i == ti ? ConditionalBoundedMessageQueue.this.takeIndex : i;
                this.checkNext();
            }
            finally {
                lock.unlock();
            }
        }
    }
}

