/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import com.solacesystems.common.util.Base64;
import com.solacesystems.common.util.Base64CipherTool;
import com.solacesystems.common.util.CipherTool;
import com.solacesystems.common.util.CipherUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PassphraseCipherTool
implements Base64CipherTool,
CipherTool {
    private CipherUtil cipherUtil;
    private byte[] salt = new byte[16];
    private static final String SECRET_KEY_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final int ITERATION_COUNT = 2048;
    private static final int KEY_LENGTH = 128;
    private static final byte[] passPhrase = new byte[]{-106, 92, -44, 101, 126, 121, 59, -48, 94, -40, 77, -77, -48, 121, 60, 31, 38, 95, -83, -9, 106, 108, -12, -80, -68, -56, 0, 106, 114, 56, 50, -66};

    public static PassphraseCipherTool createCipherToolWithDefaultPassphrase() {
        return new PassphraseCipherTool(Base64.encodeBytes(passPhrase));
    }

    public static PassphraseCipherTool createCipherToolWithDefaultPassphrase(String salt) {
        return new PassphraseCipherTool(Base64.encodeBytes(passPhrase), salt);
    }

    public static PassphraseCipherTool createCipherToolWithSpecifiedPassphrase(String passphrase, String salt) {
        return new PassphraseCipherTool(passphrase, salt);
    }

    public static PassphraseCipherTool createCipherToolWithSpecifiedPassphrase(String passphrase) {
        return new PassphraseCipherTool(passphrase);
    }

    private PassphraseCipherTool(String passphrase) {
        new SecureRandom().nextBytes(this.salt);
        this.init(passphrase);
    }

    private PassphraseCipherTool(String passphrase, String salt) {
        this.salt = Base64.decode(salt);
        this.init(passphrase);
    }

    private void init(String passphrase) {
        SecretKey key;
        SecretKeyFactory factory;
        try {
            factory = SecretKeyFactory.getInstance(SECRET_KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            key = factory.generateSecret(new PBEKeySpec(passphrase.toCharArray(), this.salt, 2048, 128));
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        try {
            this.cipherUtil = new CipherUtil(key.getEncoded());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encrypt(byte[] data) throws GeneralSecurityException {
        return this.cipherUtil.getEncryptingCipher().doFinal(data);
    }

    public byte[] decrypt(byte[] data) throws GeneralSecurityException {
        return this.cipherUtil.getDecryptingCipher().doFinal(data);
    }

    public String decryptBase64(String someString) throws GeneralSecurityException {
        if (someString == null) {
            throw new IllegalArgumentException("Please provide a non null input");
        }
        return new String(this.decrypt(Base64.decode(someString)), Charset.forName("UTF-8"));
    }

    public String encryptBase64(String someString) throws GeneralSecurityException {
        if (someString == null) {
            throw new IllegalArgumentException("Please provide a non null input");
        }
        try {
            String encoding = Base64.getPreferredEncoding();
            return Base64.encodeBytes(this.encrypt(someString.getBytes(encoding)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public final byte[] getSalt() {
        return this.salt;
    }

    public final String getSaltBase64() {
        return Base64.encodeBytes(this.salt);
    }
}

