/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPLoginFailureException;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.JndiMessage;
import com.solacesystems.jcsmp.VersionNotSupportException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.JCSMPUtils;
import com.solacesystems.jcsmp.impl.JndiMessageImpl;
import com.solacesystems.jcsmp.protocol.CSMPControllerChannel;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.csmp.CSMPMessageFactory;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;
import com.solacesystems.jcsmp.secure.SecureProperties;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ControllerChannel
extends TcpChannel
implements CSMPControllerChannel {
    private static final Log Trace = LogFactory.getLog(ControllerChannel.class);

    public ControllerChannel(JCSMPProperties properties, SecureProperties secureProps, JCSMPSessionStats sessionStats, ContextImpl context) {
        super(properties, secureProps, "control_channel", sessionStats, context);
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)("Create ControllerChannel with properties:" + properties));
        }
    }

    private void heuristicFailCsmpErrorResponse(JCSMPException e) throws JCSMPException {
        JCSMPErrorResponseException err_resp;
        if (e instanceof JCSMPErrorResponseException && (err_resp = (JCSMPErrorResponseException)e).getResponseBody() != null && err_resp.getResponseBody().length() > 0) {
            JCSMPErrorResponseException err = (JCSMPErrorResponseException)e;
            throw new JCSMPErrorResponseException(err.getResponseCode(), err.getResponsePhrase(), err.getResponseBody(), this.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CSMP);
        }
    }

    private WireMessage executePost(WireMessage postReq, boolean addAuth, boolean allowRetry) throws JCSMPException {
        try {
            return this.executePostOnce(postReq, addAuth);
        }
        catch (JCSMPException e) {
            JCSMPException error = e;
            this.heuristicFailCsmpErrorResponse(e);
            if (allowRetry && JCSMPUtils.isRetryableConnectionErrorAA(error, this.sessionProperties.getStringProperty("gd_reconnect_fail_action"))) {
                if (this.reconnectCount == 0) {
                    this.closeConnection();
                } else {
                    for (int i = 0; i < this.reconnectCount; ++i) {
                        if (Trace.isDebugEnabled()) {
                            Trace.debug((Object)("re-try executePost, count=" + (i + 1) + " due to " + (Object)((Object)e)));
                        }
                        try {
                            this.closeConnection();
                            this.openNoRetry();
                            return this.executePostOnce(postReq, addAuth);
                        }
                        catch (JCSMPException te) {
                            error = te;
                            this.heuristicFailCsmpErrorResponse(te);
                            if (!JCSMPUtils.isRetryableConnectionErrorAA(te, this.sessionProperties.getStringProperty("gd_reconnect_fail_action"))) break;
                            try {
                                int sign = Math.random() >= 0.5 ? 1 : -1;
                                int retryWait = this.properties.getReconnectRetryWaitInMillis();
                                int waitDifference = (int)((double)retryWait * Math.random() / 2.0);
                                retryWait += waitDifference * sign;
                                if (Trace.isDebugEnabled()) {
                                    Trace.debug((Object)("Channel reconnect retry wait " + retryWait));
                                }
                                Thread.sleep(retryWait);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                }
            }
            throw error;
        }
    }

    private synchronized void openConditionalForCsmp(boolean allowRetry) throws JCSMPException {
        if (!this.connected()) {
            this.doAddSubscriberLogin(allowRetry);
        }
    }

    private void doAddSubscriberLogin(boolean allowRetry) throws JCSMPException {
        Trace.debug((Object)("About to send addSubscriber message " + this.properties));
        try {
            this.doCsmpPost(CSMPMessageFactory.onlyInstance().buildAddSubscriberMessage(), allowRetry);
        }
        catch (JCSMPErrorResponseException err) {
            throw new JCSMPLoginFailureException(0, this.clientUsername, err.getResponseCode(), err.getResponsePhrase());
        }
        Trace.debug((Object)("Done sending addSubscriber " + this.properties));
    }

    public void open() throws JCSMPException {
        super.open();
        this.openConditionalForCsmp(true);
    }

    private void openNoRetry() throws JCSMPException {
        super.open();
        this.openConditionalForCsmp(false);
    }

    public synchronized void addSubscriber() throws JCSMPException {
        this.openConditionalForCsmp(true);
    }

    public synchronized void close() {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"About to close");
        }
        super.close();
    }

    private synchronized void doCsmpPost(byte[] payload, boolean allowRetry) throws JCSMPException {
        SMFHeaderBean smfHeader = new SMFHeaderBean();
        smfHeader.setProtocol(2).setTtl(1);
        WireMessage msg = WireMessageFactory.createWith(smfHeader);
        msg.setPayload(payload);
        WireMessage response = this.executePost(msg, true, allowRetry);
        String csmpResponse = new String(response.getPayload());
        if (csmpResponse != null && csmpResponse.indexOf("<isOk val=\"1\"/>") < 0) {
            throw new JCSMPErrorResponseException(200, "OK", csmpResponse, this.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CSMP);
        }
        this.checkCsmpRouterVersion(response);
    }

    private synchronized WireMessage doJndiPost(byte[] payload) throws JCSMPException {
        SMFHeaderBean smfHeader = new SMFHeaderBean();
        smfHeader.setProtocol(14).setTtl(1);
        WireMessage msg = WireMessageFactory.createWith(smfHeader);
        msg.setPayload(payload);
        WireMessage response = this.executePost(msg, false, true);
        return response;
    }

    public JndiMessage executeJndiQuery(JndiMessage request) throws JCSMPException {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)("Running JNDI query, size=" + (request.getPayload() == null ? 0 : request.getPayload().length)));
        }
        this.openConditionalForCsmp(true);
        WireMessage jndiResp = this.doJndiPost(request.getPayload());
        SMFHeaderBean smfh = jndiResp.getSmfHeader();
        JndiMessageImpl jmsg = new JndiMessageImpl(smfh.getPm_respcode(), smfh.getPm_respstr(), jndiResp.getPayload());
        return jmsg;
    }

    public synchronized void clearSubscriber() throws JCSMPException {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)("About to clearSubscriber " + this.properties));
        }
        this.openConditionalForCsmp(true);
        this.doCsmpPost(CSMPMessageFactory.onlyInstance().buildRemoveSubscriberMessage(), true);
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)("Done clearSubscriber " + this.properties));
        }
    }

    protected void checkCsmpRouterVersion(WireMessage csmpResponse) throws VersionNotSupportException, InvalidMessageReceivedException {
        SMFHeaderBean smfHeader;
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Check router compatibility");
        }
        if ((smfHeader = csmpResponse.getSmfHeader()).getProtocol() == 2) {
            if (smfHeader.getSmfVersion() != 2 && smfHeader.getSmfVersion() != 3) {
                throw new VersionNotSupportException(JCSMPRB.BUNDLE.getStringSafely("ControllerChannel.badVersion"));
            }
        } else {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("ControllerChannel.badMessageExpectedPubCtrlResponse"));
        }
    }

    protected TcpChannel.KeepaliveWriteResult writeKAMessage(WireMessage wm) throws JCSMPException, IOException {
        return new TcpChannel.KeepaliveWriteResult(0L, true);
    }

    void handleKeepaliveException(Exception ex) {
    }

    public boolean isAutoReconnector() {
        return false;
    }

    public boolean isUserCloseable() {
        return true;
    }
}

