/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.serialization;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.RawSMFMessage;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class SDTMapAdapter
implements Map<String, Object> {
    private final SDTMap sdtmap;

    public SDTMapAdapter() {
        this.sdtmap = new MapImpl();
    }

    public SDTMapAdapter(SDTMap map) {
        this.sdtmap = map;
    }

    @Override
    public int size() {
        return this.sdtmap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sdtmap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.sdtmap.containsKey((String)key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.sdtmap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            try {
                Object value = this.sdtmap.get((String)key);
                if (value instanceof ByteArray) {
                    return ((ByteArray)value).asBytes();
                }
                return value;
            }
            catch (SDTException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        Object oldValue = this.get(key);
        if (value instanceof SDTMap || value instanceof SDTStream || value instanceof RawSMFMessage) {
            throw new IllegalArgumentException("Unsupported Map value type: " + value.getClass().getName());
        }
        try {
            this.sdtmap.putObject(key, value);
        }
        catch (SDTException e) {
            throw new IllegalArgumentException(e);
        }
        return oldValue;
    }

    @Override
    public Object remove(Object key) {
        Object oldValue = null;
        if (key instanceof String) {
            oldValue = this.get(key);
            this.sdtmap.remove((String)key);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.sdtmap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.sdtmap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.sdtmap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>(this.size());
        for (String key : this.keySet()) {
            entrySet.add(new SDTAdapterEntry(key, this.get(key)));
        }
        return entrySet;
    }

    private static class SDTAdapterEntry
    implements Map.Entry<String, Object> {
        private final String key;
        private Object value;

        public SDTAdapterEntry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }
}

