/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.util.DestinationUtil;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.impl.AbstractDestination;
import com.solacesystems.jcsmp.impl.PubSubMode;
import com.solacesystems.jcsmp.impl.TargetRouterMode;
import java.io.Serializable;

public abstract class Queue
extends AbstractDestination
implements Endpoint,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isDurable;
    private boolean isAnonymous;
    String reportedPublicName;

    protected Queue(String name, boolean durable) {
        super(name);
        this.isDurable = durable;
    }

    protected Queue(String name, boolean durable, String hostId) {
        super(name, hostId);
        this.isDurable = durable;
    }

    @Override
    public String getName() {
        if (this.reportedPublicName == null) {
            this.reportedPublicName = this.hostId != null && this.isDurable ? DestinationUtil.createDurQueueTrbTopic(this.name, this.hostId) : this.name;
        }
        return this.reportedPublicName;
    }

    @Override
    public boolean isDurable() {
        return this.isDurable;
    }

    @Override
    public boolean isTemporary() {
        return !this.isDurable;
    }

    @Override
    protected void init() {
        this.isInitialized = true;
    }

    @Override
    protected void validateCommon() {
        DestinationUtil.isValidQueuePhysicalName(this.name, this.isDurable);
        if (!this.isValidatedCrbPub) {
            this.isValidCrbPub = true;
            this.isValidatedCrbPub = true;
        }
        if (!this.isValidatedTrbPub) {
            this.isValidTrbPub = true;
            this.isValidatedTrbPub = true;
        }
    }

    @Override
    protected void validate(TargetRouterMode vm, PubSubMode pm) {
        this.validateCommon();
        switch (vm) {
            case CRB: {
                if (this.isValidCrbPub) break;
                throw new IllegalArgumentException(this.fmtInvalidDestinationErr(vm.name()));
            }
            case TRB: {
                if (this.isValidTrbPub) break;
                throw new IllegalArgumentException(this.fmtInvalidDestinationErr(vm.name()));
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Queue) {
            return ((Queue)o).name.equals(this.name);
        }
        return false;
    }

    @Override
    protected void validateModeForPublish(DeliveryMode mt, TargetRouterMode vm, boolean acceptDirectQueue) {
        if (mt != DeliveryMode.PERSISTENT && mt != DeliveryMode.NON_PERSISTENT && !acceptDirectQueue) {
            throw new IllegalArgumentException(this.fmtInvalidDestinationForMsgtype(mt, vm));
        }
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.isAnonymous = anonymous;
    }
}

