/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.client;

import com.solacesystems.jcsmp.JCSMPVersion;
import com.solacesystems.jcsmp.impl.client.ClientInfoUtil;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;

public class ClientInfoProvider
implements Serializable {
    private static final long serialVersionUID = 1129009522041915932L;
    private JCSMPVersion _versioninfo = new JCSMPVersion();

    public String getSoftwareVersion() {
        return this._versioninfo.getSwVersion();
    }

    public String getSoftwareDate() {
        return this._versioninfo.getBuildDate();
    }

    public String getPlatform() {
        return this.getPlatform("JCSMP SDK");
    }

    protected String getPlatform(String clientType) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("os.name", "")).append("-");
        sb.append(System.getProperty("os.arch", ""));
        sb.append(" (Java ");
        sb.append(System.getProperty("java.runtime.version", "")).append(") - " + clientType);
        return sb.toString();
    }

    public String getUserId() {
        return System.getProperty("user.name", "NO_USERNAME");
    }

    public String getUserIdExtended() {
        String proxyhost = System.getProperty("solace.proxy.host");
        String proxyconnect = "";
        if (proxyhost != null) {
            String proxytype = System.getProperty("solace.proxy.type");
            String proxyport = System.getProperty("solace.proxy.port");
            if (proxytype == null) {
                proxytype = "http";
            }
            proxyconnect = proxyport == null ? " via proxy: " + proxytype + "://" + proxyhost : " via proxy: " + proxytype + "://" + proxyhost + ":" + proxyport;
        }
        return String.format("'%s' Computer: '%s'%s Process ID: %s", ClientInfoUtil.trunc(this.getUserId(), 32), ClientInfoUtil.truncWithElipses(this.getHostname(), 128), proxyconnect, this.getPid());
    }

    public String getHostname() {
        String localhost = "localhost";
        try {
            InetAddress address = InetAddress.getLocalHost();
            localhost = address.getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localhost;
    }

    public int getPid() {
        int pid = 0;
        try {
            RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
            String strRt = rtBean.getName();
            pid = Integer.parseInt(strRt.split("@")[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pid;
    }

    public String toString() {
        return String.format("Version: %s, BuildDate: %s, Platform: %s, UserId: %s, Hostname: %s, Pid: %s", this.getSoftwareVersion(), this.getSoftwareDate(), this.getPlatform(), this.getUserId(), this.getHostname(), this.getPid());
    }
}

