/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction;

import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimer;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimerQueue;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class TimerSetter {
    volatile boolean enable = false;
    volatile JCSMPTimer timer_obj = null;
    final JCSMPTimerQueue time_service;
    final int timeout;
    final JCSMPTimeoutHandler timeout_handler;

    public TimerSetter(JCSMPTimerQueue react, int timeout, JCSMPTimeoutHandler handler) {
        this.time_service = react;
        this.timeout = timeout;
        this.timeout_handler = handler;
    }

    public void enableStartTimer() {
        this.enable = true;
    }

    public void disableStartTimer() {
        this.enable = false;
    }

    public void startTimer() {
        JCSMPTimer local_tim = this.timer_obj;
        if (this.enable && (local_tim == null || !local_tim.isActive())) {
            this.timer_obj = this.time_service.schedule_relative(this.timeout, this.timeout_handler);
        }
    }

    public long getTimeoutInMillis() {
        if (this.enable && this.timer_obj != null) {
            return this.timer_obj.getTimeout() - System.currentTimeMillis();
        }
        return 0L;
    }

    public void startTimer(JCSMPTimeoutHandler handler) {
        JCSMPTimer local_tim = this.timer_obj;
        if (this.enable && (local_tim == null || !local_tim.isActive())) {
            this.timer_obj = this.time_service.schedule_relative(this.timeout, handler);
        }
    }

    public void stopTimer() {
        this.disableStartTimer();
        JCSMPTimer local_tim = this.timer_obj;
        if (local_tim != null) {
            this.time_service.cancelTimer(local_tim);
        }
    }
}

