/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.jcsmp.PropertyMap;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JCSMPChannelProperties
implements PropertyMap,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final String SUPPORTED_PROTOCOL_STACK_SMF_TCP = "csmp.smf.tcp";
    public static final String SUPPORTED_PROTOCOL_STACK_SMFS_TCP = "csmp.smfs.tcp";
    public static final String CONNECT_TIMEOUT_IN_MILLIS = "ConnectTimeoutInMillis";
    public static final String SMF_PORT = "SmfPort";
    public static final String KEEP_ALIVE_INTERVAL_IN_MILLIS = "KeepAliveIntervalInMillis";
    public static final String KEEP_ALIVE_LIMIT = "KeepAliveLimit";
    public static final String READ_TIMEOUT_IN_MILLIS = "ReadTimeoutInMillis";
    public static final String CONNECT_RETRIES = "ConnectRetries";
    public static final String RECONNECT_RETRIES = "ReconnectRetries";
    public static final String RECONNECT_RETRY_WAIT_IN_MILLIS = "ReconnectRetryWaitInMillis";
    public static final String STACK = "Stack";
    public static final String TCP_NO_DELAY = "TcpNoDelay";
    public static final String SEND_BUFFER = "SendBuffer";
    public static final String RECEIVE_BUFFER = "ReceiveBuffer";
    public static final String COMPRESSION_LEVEL = "CompressionLevel";
    public static final String CONNECT_RETRIES_PER_HOST = "ConnectRetriesPerHost";
    protected static final List<String> supportedProtocolStacks = new ArrayList<String>();
    protected final Map<String, Object> _properties = new HashMap<String, Object>();

    public JCSMPChannelProperties() {
        this(SUPPORTED_PROTOCOL_STACK_SMF_TCP, 0, 30000, 10000, 3, 3000, 3000);
    }

    public JCSMPChannelProperties(String stack, int smfPort, int connectTimeoutInMillis, int readTimeoutInMillis, int reconnectRetries, int reconnectRetryWaitInMillis, int keepAliveIntervalInMillis) {
        this.setStack(stack);
        this.setSmfPort(smfPort);
        this.setConnectTimeoutInMillis(connectTimeoutInMillis);
        this.setReadTimeoutInMillis(readTimeoutInMillis);
        this.setConnectRetries(0);
        this.setConnectRetriesPerHost(0);
        this.setReconnectRetries(reconnectRetries);
        this.setReconnectRetryWaitInMillis(reconnectRetryWaitInMillis);
        this.setKeepAliveIntervalInMillis(keepAliveIntervalInMillis);
        this.setTcpNoDelay(true);
        this.setReceiveBuffer(65536);
        this.setSendBuffer(65536);
        this.setKeepAliveLimit(10);
        this.setCompressionLevel(0);
    }

    public Object clone() {
        JCSMPChannelProperties props = new JCSMPChannelProperties(this.getStack(), this.getIntegerProperty(SMF_PORT), this.getConnectTimeoutInMillis(), this.getReadTimeoutInMillis(), this.getReconnectRetries(), this.getReconnectRetryWaitInMillis(), this.getKeepAliveIntervalInMillis());
        props.setTcpNoDelay(this.isTcpNoDelay());
        props.setReceiveBuffer(this.getReceiveBuffer());
        props.setSendBuffer(this.getSendBuffer());
        props.setKeepAliveLimit(this.getKeepAliveLimit());
        props.setCompressionLevel(this.getCompressionLevel());
        props.setConnectRetries(this.getConnectRetries());
        props.setConnectRetriesPerHost(this.getConnectRetriesPerHost());
        return props;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\n");
        sb.append("\t").append("stack: ").append(this.getStack()).append("\n");
        sb.append("\t").append("smfPort: ").append(this.getSmfPort()).append("\n");
        sb.append("\t").append("connectRetriesPerHost: ").append(this.getConnectRetriesPerHost()).append("\n");
        sb.append("\t").append("connectRetries: ").append(this.getConnectRetries()).append("\n");
        sb.append("\t").append("connectTimeoutInMillis: ").append(this.getConnectTimeoutInMillis()).append("\n");
        sb.append("\t").append("readTimeoutInMillis: ").append(this.getReadTimeoutInMillis()).append("\n");
        sb.append("\t").append("reconnectRetries: ").append(this.getReconnectRetries()).append("\n");
        sb.append("\t").append("reconnectRetryWaitInMillis: ").append(this.getReconnectRetryWaitInMillis()).append("\n");
        sb.append("\t").append("keepAliveIntervalInMillis: ").append(this.getKeepAliveIntervalInMillis()).append("\n");
        sb.append("\t").append("keepAliveLimit: ").append(this.getKeepAliveLimit()).append("\n");
        sb.append("\t").append("tcpNoDelay: ").append(this.isTcpNoDelay()).append("\n");
        sb.append("\t").append("ReceiveBuffer: ").append(this.getReceiveBuffer()).append("\n");
        sb.append("\t").append("sendBuffer: ").append(this.getSendBuffer()).append("\n");
        return sb.toString();
    }

    @Deprecated
    public boolean isSecureChannel() {
        throw new UnsupportedOperationException();
    }

    public int getConnectTimeoutInMillis() {
        return this.getIntegerProperty(CONNECT_TIMEOUT_IN_MILLIS);
    }

    public void setConnectTimeoutInMillis(int connectTimeoutInMillis) {
        if (connectTimeoutInMillis < 0) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidConnectTimeoutMillis"));
        }
        this.setIntegerProperty(CONNECT_TIMEOUT_IN_MILLIS, connectTimeoutInMillis);
    }

    public int getSmfPort() {
        Integer smfPort = this.getIntegerProperty(SMF_PORT);
        if (smfPort != null && smfPort != 0) {
            return smfPort;
        }
        return this.getCompressionLevel() == 0 ? 55555 : 55003;
    }

    public void setSmfPort(int smfPort) {
        if (smfPort < 0 || smfPort > 65535) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidHttpPort"));
        }
        this.setIntegerProperty(SMF_PORT, smfPort);
    }

    public int getKeepAliveIntervalInMillis() {
        return this.getIntegerProperty(KEEP_ALIVE_INTERVAL_IN_MILLIS);
    }

    public void setKeepAliveIntervalInMillis(int keepAliveIntervalInMillis) {
        if (keepAliveIntervalInMillis != 0 && keepAliveIntervalInMillis < 50) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidKeepAliveIntervalMillis"));
        }
        this.setIntegerProperty(KEEP_ALIVE_INTERVAL_IN_MILLIS, keepAliveIntervalInMillis);
    }

    public int getKeepAliveLimit() {
        return this.getIntegerProperty(KEEP_ALIVE_LIMIT);
    }

    public void setKeepAliveLimit(int keepAliveLimit) {
        if (keepAliveLimit < 3) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidKeepAliveLimit"));
        }
        this.setIntegerProperty(KEEP_ALIVE_LIMIT, keepAliveLimit);
    }

    public int getReadTimeoutInMillis() {
        return this.getIntegerProperty(READ_TIMEOUT_IN_MILLIS);
    }

    public void setReadTimeoutInMillis(int readTimeoutInMillis) {
        if (readTimeoutInMillis <= 0) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidReadTimeoutMillis"));
        }
        this.setIntegerProperty(READ_TIMEOUT_IN_MILLIS, readTimeoutInMillis);
    }

    public int getConnectRetries() {
        return this.getIntegerProperty(CONNECT_RETRIES);
    }

    public void setConnectRetries(int connectRetries) {
        if (connectRetries < -1) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidConnectRetries"));
        }
        this.setIntegerProperty(CONNECT_RETRIES, connectRetries);
    }

    public int getReconnectRetries() {
        return this.getIntegerProperty(RECONNECT_RETRIES);
    }

    public void setReconnectRetries(int reconnectRetries) {
        if (reconnectRetries < -1) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidReconnectRetries"));
        }
        this.setIntegerProperty(RECONNECT_RETRIES, reconnectRetries);
    }

    public int getReconnectRetryWaitInMillis() {
        return this.getIntegerProperty(RECONNECT_RETRY_WAIT_IN_MILLIS);
    }

    public void setReconnectRetryWaitInMillis(int reconnectRetryWaitInMillis) {
        if (reconnectRetryWaitInMillis < 0 || reconnectRetryWaitInMillis > 60000) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidReconnectRetryWaitMillis"));
        }
        this.setIntegerProperty(RECONNECT_RETRY_WAIT_IN_MILLIS, reconnectRetryWaitInMillis);
    }

    public String getStack() {
        return this.getStringProperty(STACK);
    }

    public void setStack(String stack) {
        if (stack == null || !supportedProtocolStacks.contains(stack)) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidStack"));
        }
        this.setProperty(STACK, stack);
    }

    public boolean isTcpNoDelay() {
        return this.getBooleanProperty(TCP_NO_DELAY);
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.setBooleanProperty(TCP_NO_DELAY, tcpNoDelay);
    }

    public int getSendBuffer() {
        return this.getIntegerProperty(SEND_BUFFER);
    }

    public void setSendBuffer(int so_sendbuf) {
        this.setIntegerProperty(SEND_BUFFER, so_sendbuf);
    }

    public int getReceiveBuffer() {
        return this.getIntegerProperty(RECEIVE_BUFFER);
    }

    public void setReceiveBuffer(int so_rcvbuf) {
        this.setIntegerProperty(RECEIVE_BUFFER, so_rcvbuf);
    }

    public int getCompressionLevel() {
        return this.getIntegerProperty(COMPRESSION_LEVEL);
    }

    public void setCompressionLevel(int compressionLevel) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidCompressionLevel"));
        }
        this.setIntegerProperty(COMPRESSION_LEVEL, compressionLevel);
    }

    public void setConnectRetriesPerHost(int connectRetriesPerHost) {
        if (connectRetriesPerHost < -1) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidConnectRetriesPerHost"));
        }
        this.setIntegerProperty(CONNECT_RETRIES_PER_HOST, connectRetriesPerHost);
    }

    public int getConnectRetriesPerHost() {
        return this.getIntegerProperty(CONNECT_RETRIES_PER_HOST);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JCSMPChannelProperties)) {
            return false;
        }
        JCSMPChannelProperties cp = (JCSMPChannelProperties)o;
        return cp.getConnectTimeoutInMillis() == this.getConnectTimeoutInMillis() && cp.getKeepAliveIntervalInMillis() == this.getKeepAliveIntervalInMillis() && cp.getKeepAliveLimit() == this.getKeepAliveLimit() && cp.getReadTimeoutInMillis() == this.getReadTimeoutInMillis() && cp.getReconnectRetries() == this.getReconnectRetries() && cp.getReconnectRetryWaitInMillis() == this.getReconnectRetryWaitInMillis() && cp.getSmfPort() == this.getSmfPort() && cp.getReceiveBuffer() == this.getReceiveBuffer() && cp.getSendBuffer() == this.getSendBuffer() && cp.getStack().equals(this.getStack()) && cp.getCompressionLevel() == this.getCompressionLevel() && cp.getConnectRetriesPerHost() == this.getConnectRetriesPerHost() && cp.getConnectRetries() == this.getConnectRetries();
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Object getProperty(String name) {
        return this._properties.get(name);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this._properties;
    }

    @Override
    public Object setProperty(String name, Object value) {
        return this._properties.put(name, value);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this._properties.putAll(properties);
    }

    @Override
    public Integer getIntegerProperty(String name) {
        Integer result = null;
        try {
            result = (Integer)this.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        Boolean result = null;
        try {
            result = (Boolean)this.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    @Override
    public String getStringProperty(String name) {
        String result = null;
        try {
            result = (String)this.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    @Override
    public Object setIntegerProperty(String name, int value) {
        return this.setProperty(name, value);
    }

    @Override
    public Object setBooleanProperty(String name, boolean value) {
        return this.setProperty(name, value);
    }

    @Override
    public Set<String> propertyNames() {
        return this._properties.keySet();
    }

    static {
        supportedProtocolStacks.add(SUPPORTED_PROTOCOL_STACK_SMF_TCP);
    }
}

