/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.transaction.xa;

import com.solacesystems.common.SolReserved;
import com.solacesystems.jcsmp.impl.transaction.xa.XAResponseCodes;
import com.solacesystems.jcsmp.impl.transaction.xa.XAResponseParam;
import javax.transaction.xa.XAException;

public class SolXAException
extends XAException {
    private static final long serialVersionUID = 473223272437923391L;
    private XAResponseParam _response;

    @SolReserved
    public SolXAException(XAResponseParam response) {
        super(response.respCode);
        this._response = response;
    }

    @SolReserved
    public String errCodeStr() {
        return XAResponseCodes.getResponseCodeString(this._response.respCode);
    }

    @SolReserved
    public long errSubCode() {
        return this._response.respSubcode;
    }

    @SolReserved
    public String errSubCodeStr() {
        return XAResponseCodes.getSubcodeString((int)this._response.respSubcode);
    }

    @SolReserved
    public byte logLevel() {
        return this._response.logLevel;
    }

    @SolReserved
    public String logLevelStr() {
        return XAResponseCodes.getLogLevelString(this._response.logLevel);
    }

    @SolReserved
    public int effectiveLogLevel() {
        return XAResponseCodes.getMappedLogLevel(this._response.logLevel);
    }

    @SolReserved
    public String effectiveLogLevelStr() {
        return XAResponseCodes.getMappedLogLevelString(this._response.logLevel);
    }

    @Override
    public String getMessage() {
        return String.format("%s (%s)", this.errCodeStr(), this.errSubCodeStr());
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }
}

