/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmpx.impl;

import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.DestinationProducer;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.MapMessage;
import com.solacesystems.jcsmp.OperationNotSupportedException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.StreamMessage;
import com.solacesystems.jcsmp.StreamXMLMessage;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.TextXMLMessage;
import com.solacesystems.jcsmp.XMLContentMessage;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import java.io.IOException;
import java.io.InputStream;

public class TopicProducerImpl
implements DestinationProducer {
    private static final String ERROR_OPERATION_NOT_SUPPORTED = JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.operationNotSupportedBasedOnSessionConfig");
    private static final String ERROR_DEFAULT_TOPIC_ISNULL = JCSMPRB.BUNDLE.getStringSafely("TopicProducer.defaultTopicIsNull");
    private XMLMessageProducer m_messageProducer;
    private Destination m_defaultTopic = null;

    public TopicProducerImpl(XMLMessageProducer messageProducer, Destination defaultTopic) throws JCSMPException {
        if (messageProducer == null) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        this.m_messageProducer = messageProducer;
        this.m_defaultTopic = defaultTopic;
    }

    @Override
    public void send(XMLMessage message, Destination topic) throws JCSMPException {
        if (topic == null) {
            throw new IllegalArgumentException("null topic passed in to send(XMLMessage message, TopicDestination topic)");
        }
    }

    @Override
    public void send(XMLMessage message) throws JCSMPException {
        if (this.m_defaultTopic == null) {
            throw new OperationNotSupportedException(ERROR_DEFAULT_TOPIC_ISNULL);
        }
        this.send(message, this.m_defaultTopic);
    }

    @Override
    public void close() {
        this.m_messageProducer.close();
    }

    @Override
    public boolean isClosed() {
        return this.m_messageProducer.isClosed();
    }

    @Override
    public BytesXMLMessage createBytesXMLMessage() throws JCSMPException {
        return this.m_messageProducer.createBytesXMLMessage();
    }

    @Override
    public BytesXMLMessage createBytesXMLMessage(byte[] value) throws JCSMPException {
        return this.m_messageProducer.createBytesXMLMessage(value);
    }

    @Override
    public StreamXMLMessage createStreamXMLMessage() throws JCSMPException {
        return this.m_messageProducer.createStreamXMLMessage();
    }

    @Override
    public StreamXMLMessage createStreamXMLMessage(InputStream stream) throws IOException, JCSMPException {
        return this.m_messageProducer.createStreamXMLMessage(stream);
    }

    @Override
    public TextXMLMessage createTextXMLMessage() throws JCSMPException {
        return this.m_messageProducer.createTextXMLMessage();
    }

    @Override
    public TextXMLMessage createTextXMLMessage(String text) throws JCSMPException {
        return this.m_messageProducer.createTextXMLMessage(text);
    }

    @Override
    public SDTMap createMap() {
        return this.m_messageProducer.createMap();
    }

    @Override
    public SDTStream createStream() {
        return this.m_messageProducer.createStream();
    }

    @Override
    public BytesMessage createBytesMessage() throws JCSMPException {
        return this.m_messageProducer.createBytesMessage();
    }

    @Override
    public XMLContentMessage createXMLContentMessage() throws JCSMPException {
        return this.m_messageProducer.createXMLContentMessage();
    }

    @Override
    public MapMessage createMapMessage() throws JCSMPException {
        return this.m_messageProducer.createMapMessage();
    }

    @Override
    public StreamMessage createStreamMessage() throws JCSMPException {
        return this.m_messageProducer.createStreamMessage();
    }

    @Override
    public TextMessage createTextMessage() throws JCSMPException {
        return this.m_messageProducer.createTextMessage();
    }

    @Override
    public JCSMPStreamingPublishEventHandler getStreamingCallbackHandler() throws JCSMPException {
        return this.m_messageProducer.getStreamingCallbackHandler();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TopicProducerImpl)) {
            return false;
        }
        return ((TopicProducerImpl)obj).m_messageProducer.equals(this.m_messageProducer);
    }

    public int hashCode() {
        return this.m_messageProducer.hashCode();
    }
}

