/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.DestinationUtil;
import com.solacesystems.common.util.UTF8Util;
import com.solacesystems.jcsmp.impl.SubscriptionHashMap;
import com.solacesystems.jcsmp.impl.SubscriptionMatchEntry;
import com.solacesystems.jcsmp.impl.SubscriptionRemoveResult;
import com.solacesystems.jcsmp.impl.SubscriptionTree;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionMap<T> {
    private volatile SubscriptionHashMap<T> mNonWildSubscriptions = new SubscriptionHashMap();
    private volatile SubscriptionTree<T> mWildSubscriptions = new SubscriptionTree();
    private volatile int mNumEntries = 0;
    private ReentrantLock mLock = new ReentrantLock();
    private SubscriptionHashMap<T> mNonWildSubscriptionsCopy = null;
    private SubscriptionTree<T> mWildSubscriptionsCopy = null;
    private int mNumEntriesCopy = 0;

    public int getNumEntries() {
        return this.mNumEntries;
    }

    public SubscriptionHashMap<T> getNonWildSubscriptions() {
        return this.mNonWildSubscriptions;
    }

    public SubscriptionTree<T> getWildSubscriptions() {
        return this.mWildSubscriptions;
    }

    public void get(byte[] data, List<SubscriptionMatchEntry<T>> entries) {
        this.mNonWildSubscriptions.get(data, entries);
        this.mWildSubscriptions.get(data, entries);
    }

    public void startTransaction() {
        if (this.mLock.isHeldByCurrentThread()) {
            return;
        }
        this.mLock.lock();
        this.mNonWildSubscriptionsCopy = null;
        this.mWildSubscriptionsCopy = null;
        this.mNumEntriesCopy = this.mNumEntries;
    }

    public void put(String subscription, T entry) {
        if (!this.mLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("startTransaction() must acquire the lock first");
        }
        if (DestinationUtil.isWildCardedCrb(subscription) || DestinationUtil.isWildCardedTrb(subscription)) {
            if (this.mWildSubscriptionsCopy == null) {
                this.mWildSubscriptionsCopy = new SubscriptionTree<T>(this.mWildSubscriptions);
            }
            this.mWildSubscriptionsCopy.put(UTF8Util.toUTF8(subscription), entry);
        } else {
            this.mNonWildSubscriptionsCopy = this.mNonWildSubscriptionsCopy == null ? this.mNonWildSubscriptions.put(UTF8Util.toUTF8(subscription), entry) : this.mNonWildSubscriptionsCopy.put(UTF8Util.toUTF8(subscription), entry);
        }
        ++this.mNumEntriesCopy;
    }

    public SubscriptionRemoveResult remove(String subscription, T entry) {
        if (!this.mLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("startTransaction() must acquire the lock first");
        }
        SubscriptionRemoveResult result = new SubscriptionRemoveResult();
        if (DestinationUtil.isWildCardedCrb(subscription) || DestinationUtil.isWildCardedTrb(subscription)) {
            if (this.mWildSubscriptionsCopy == null) {
                this.mWildSubscriptionsCopy = new SubscriptionTree<T>(this.mWildSubscriptions);
            }
            this.mWildSubscriptionsCopy.remove(UTF8Util.toUTF8(subscription), entry, result);
        } else {
            this.mNonWildSubscriptionsCopy = this.mNonWildSubscriptionsCopy == null ? this.mNonWildSubscriptions.remove(UTF8Util.toUTF8(subscription), entry, result) : this.mNonWildSubscriptionsCopy.remove(UTF8Util.toUTF8(subscription), entry, result);
        }
        if (result.isFound()) {
            --this.mNumEntriesCopy;
        }
        return result;
    }

    public void commit() {
        if (!this.mLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("startTransaction() must acquire the lock first");
        }
        if (this.mNonWildSubscriptionsCopy != null) {
            this.mNonWildSubscriptions = this.mNonWildSubscriptionsCopy;
            this.mNumEntries = this.mNumEntriesCopy;
        }
        if (this.mWildSubscriptionsCopy != null) {
            this.mWildSubscriptions = this.mWildSubscriptionsCopy;
            this.mNumEntries = this.mNumEntriesCopy;
        }
        this.mLock.unlock();
    }

    public void rollback() {
        if (!this.mLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("startTransaction() must acquire the lock first");
        }
        this.mLock.unlock();
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this.mNonWildSubscriptions);
        bldr.append("\r\n");
        bldr.append(this.mWildSubscriptions);
        return bldr.toString();
    }
}

