/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSMPXMLMessagePool {
    private static final Log Trace = LogFactory.getLog(JCSMPXMLMessagePool.class);
    private final LinkedList<JCSMPGenericXMLMessage> _genericQueue = new LinkedList();
    private int _size = 0;
    private int _allocatedCnt = 0;
    private boolean _throwOnFull = false;
    private BaseTransactedSessionImpl _txSession;

    public JCSMPXMLMessagePool() {
        this(false, null);
    }

    public JCSMPXMLMessagePool(boolean throwOnFull, BaseTransactedSessionImpl txSession) {
        this._throwOnFull = throwOnFull;
        this._txSession = txSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int size) {
        LinkedList<JCSMPGenericXMLMessage> linkedList = this._genericQueue;
        synchronized (linkedList) {
            this._size = size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCSMPGenericXMLMessage getGenericMessage() {
        JCSMPGenericXMLMessage rMsg = null;
        LinkedList<JCSMPGenericXMLMessage> linkedList = this._genericQueue;
        synchronized (linkedList) {
            while (this._genericQueue.size() == 0) {
                if (this._allocatedCnt < this._size) {
                    this.allocate();
                    continue;
                }
                if (this._throwOnFull && !this._txSession.getExpectsAcks()) {
                    throw new IllegalStateException("Too many messages in a transaction");
                }
                try {
                    this._genericQueue.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            rMsg = this._genericQueue.removeFirst();
        }
        rMsg.setFlagReturnedToPool(false);
        return rMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnMessageToPool(XMLMessage message) {
        JCSMPGenericXMLMessage xmlMsg = (JCSMPGenericXMLMessage)message;
        LinkedList<JCSMPGenericXMLMessage> linkedList = this._genericQueue;
        synchronized (linkedList) {
            if (xmlMsg.isFlagReturnedToPool()) {
                return;
            }
            xmlMsg.setFlagReturnedToPool(true);
            this._genericQueue.addFirst((JCSMPGenericXMLMessage)message);
            if (this._genericQueue.size() == 1) {
                this._genericQueue.notifyAll();
            }
        }
    }

    private void allocate() {
        JCSMPGenericXMLMessage message = new JCSMPGenericXMLMessage(4096);
        message.setMsgPool(this);
        this._genericQueue.add(message);
        ++this._allocatedCnt;
    }
}

