/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.transaction.AdCtrlV4TransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionManager;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderParameters;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactorySmf;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterParser;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;

public class TransactedSessionManagerSmf {
    private final LogWrapper Trace = new LogWrapper(TransactedSessionManagerSmf.class);
    private final TransactedSessionManager _parent;
    private final Topic assuredctrlPassThruTopic;

    public TransactedSessionManagerSmf(TransactedSessionManager mgr) {
        this._parent = mgr;
        this.assuredctrlPassThruTopic = JCSMPFactory.onlyInstance().createTopic("#P2P/ADCTRLPASSTHRU");
        this.Trace.setContextInfo(mgr.getLogContextInfo());
    }

    long doOpenTxSession(TransactedSessionImpl ts, boolean retryable) throws JCSMPException {
        SMFHeaderBean smfh;
        int resp_code;
        WireMessage response = null;
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
        Long corrId = null;
        if (ts instanceof AdCtrlV4TransactedSessionImpl) {
            corrId = ((AdCtrlV4TransactedSessionImpl)ts).getSessionTag();
            smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(corrId));
        }
        AssuredCtrlHeaderBean assBean = this._parent.getSession().getAssuredCtrlFactory().createOpenTransactedSession(ts.getTransactionId(), ts.getName());
        WireMessage msgReq = WireMessageFactory.createWith(smfHeader, assBean);
        msgReq.setFriendlyName("ADCTRL-OpenTransactedSession");
        msgReq.setSessionTag(true);
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("Created v3 ADCTRL TransactionCtrl OpenTransactedSession Handshake Request", new Object[0]));
        }
        if ((resp_code = (smfh = (response = retryable ? this._parent.getSubChannel().doSmfSharedRequest(msgReq, null, corrId, false) : this._parent.getSubChannel().doSmfSubSingleShotRequest(msgReq, true, true, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, this._parent.getSubChannel().getConnCounterTag(), corrId)).getSmfHeader()).getPm_respcode()) != 200) {
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info(this._parent.getNetworkInfoString() + "Error Response (" + resp_code + ") - " + smfh.getPm_respstr());
            }
            throw new JCSMPErrorResponseException(resp_code, smfh.getPm_respstr(), "", this._parent.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
        }
        smfHeader = response.getSmfHeader();
        if (smfHeader.getProtocol() != 9) {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedAssuredCtrlResponseGotWrongType"));
        }
        if (!(response.getHeaderBean() instanceof AssuredCtrlHeaderBean)) {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedAssredCtrlResponseBlockNotFound"));
        }
        AssuredCtrlHeaderBean adctrl_response = (AssuredCtrlHeaderBean)response.getHeaderBean();
        this.processOpenTransactedSessionResponse(adctrl_response, ts);
        return ts.getTransactedSessionId();
    }

    long doOpenAdCtrlV4TxSession(AdCtrlV4TransactedSessionImpl ts, boolean retryable) throws JCSMPException {
        WireMessage response = null;
        long corrId = ts.getSessionTag();
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
        smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(corrId));
        AssuredCtrlHeaderBean assBean = null;
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("Created v4 ADCTRL TransactionCtrl OpenTransactedSession Handshake Request", new Object[0]));
        }
        while (response == null) {
            if (this._parent.getSession().getAssuredCtrlFactory().getVersion() < 4) {
                return this.doOpenTxSession(ts, retryable);
            }
            assBean = this._parent.getSession().getAssuredCtrlFactory().createAdCtrlV4OpenTransactedSession();
            WireMessage msgReq = WireMessageFactory.createWith(smfHeader, assBean);
            msgReq.setFriendlyName("ADCTRL-OpenTransactedSession");
            msgReq.setSessionTag(true);
            if (this._parent.isReconnetAborted()) {
                throw this._parent.getReconnectAbortException();
            }
            try {
                response = retryable ? this._parent.getSubChannel().doSmfSharedRequest(msgReq, 1L, ts.getConnTag(), corrId, true) : this._parent.getSubChannel().doSmfSubSingleShotRequest(msgReq, true, true, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, this._parent.getSubChannel().getConnCounterTag(), corrId);
                if ((long)response.getSmfHeader().getPm_corrtag() != corrId) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug("got unexpected open response with corrId " + response.getSmfHeader().getPm_corrtag() + ", expecting " + corrId);
                    }
                    response = null;
                }
                if (response.getSmfHeader().getPm_respcode() != 507 || !response.getSmfHeader().getPm_respstr().equals("Assured Delivery Not Ready")) continue;
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("discard open response: " + response.getSmfHeader().getPm_respcode() + " " + response.getSmfHeader().getPm_respstr());
                }
                response = null;
            }
            catch (JCSMPException e) {
                if (ts.getParentSession().isReactorOrReconnectRelatedThread()) {
                    throw e;
                }
                if (ts.getParentSession() != null) {
                    ts.getParentSession().waitUntilSessionReconnectDone("Open");
                }
                ts.updateConnTag();
            }
        }
        SMFHeaderBean smfh = response.getSmfHeader();
        int resp_code = smfh.getPm_respcode();
        if (resp_code != 200) {
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info(this._parent.getNetworkInfoString() + "Error Response (" + resp_code + ") - " + smfh.getPm_respstr());
            }
            throw new JCSMPErrorResponseException(resp_code, smfh.getPm_respstr(), "", this._parent.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
        }
        smfHeader = response.getSmfHeader();
        if (smfHeader.getProtocol() != 9 && smfHeader.getProtocol() != 19) {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedAssuredCtrlResponseGotWrongType"));
        }
        if (!(response.getHeaderBean() instanceof AssuredCtrlHeaderBean)) {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedAssredCtrlResponseBlockNotFound"));
        }
        AssuredCtrlHeaderBean adctrl_response = (AssuredCtrlHeaderBean)response.getHeaderBean();
        this.processOpenTransactedSessionResponse(adctrl_response, ts);
        return ts.getTransactedSessionId();
    }

    private void processOpenTransactedSessionResponse(AssuredCtrlHeaderBean adctrl, TransactedSessionImpl ts) throws JCSMPException {
        SmfTLVParameter param = null;
        param = (SmfTLVParameter)adctrl.findFirstParameter(24);
        if (param == null) {
            throw new InvalidMessageReceivedException("TransactedSessionId not found");
        }
        long txSessionId = TlvParameterParser.getAssuredTransactedSessionId(param);
        param = (SmfTLVParameter)adctrl.findFirstParameter(25);
        if (param == null) {
            throw new InvalidMessageReceivedException("TransactedSessionName not found");
        }
        String txSessionName = TlvParameterParser.getAssuredTransactedSessionName(param);
        if (ts instanceof AdCtrlV4TransactedSessionImpl) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("processOpenTransactedSessionResponse: name= " + txSessionName + "; seesionId=" + txSessionId + "; tag=" + ((AdCtrlV4TransactedSessionImpl)ts).getSessionTag());
            }
            if (((AdCtrlV4TransactedSessionImpl)ts).isDowngradeEnabled()) {
                param = (SmfTLVParameter)adctrl.findFirstParameter(27);
                if (param == null) {
                    throw new InvalidMessageReceivedException("TransactedSessionState not found");
                }
                AssuredCtrlEnums.TransactedSessionState txSessionState = TlvParameterParser.getAssuredTransactedSessionState(param);
                param = (SmfTLVParameter)adctrl.findFirstParameter(26);
                if (param == null) {
                    throw new InvalidMessageReceivedException("TransactionId not found");
                }
                AssuredCtrlHeaderParameters.ParamTransactionId txid = TlvParameterParser.getAssuredTransactionId(param);
                ts.notifyBound(txSessionName, txSessionId, txSessionState, txid);
            } else {
                ((AdCtrlV4TransactedSessionImpl)ts).notifyCreatedOrResumed(txSessionName, txSessionId);
                this._parent.addManagedTransactedSession(ts);
            }
        } else {
            param = (SmfTLVParameter)adctrl.findFirstParameter(27);
            if (param == null) {
                throw new InvalidMessageReceivedException("TransactedSessionState not found");
            }
            AssuredCtrlEnums.TransactedSessionState txSessionState = TlvParameterParser.getAssuredTransactedSessionState(param);
            param = (SmfTLVParameter)adctrl.findFirstParameter(26);
            if (param == null) {
                throw new InvalidMessageReceivedException("TransactionId not found");
            }
            AssuredCtrlHeaderParameters.ParamTransactionId txid = TlvParameterParser.getAssuredTransactionId(param);
            ts.notifyBound(txSessionName, txSessionId, txSessionState, txid);
        }
    }

    long doResumeAdCtrlV4TxSession(AdCtrlV4TransactedSessionImpl ts, boolean upgrade) throws JCSMPException {
        WireMessage response = null;
        long corrId = ts.getSessionTag();
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
        smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(corrId));
        AssuredCtrlHeaderBean assBean = this._parent.getSession().getAssuredCtrlFactory().createAdCtrlV4ResumeTransactedSession(ts.getName(), upgrade);
        WireMessage msgReq = WireMessageFactory.createWith(smfHeader, assBean);
        msgReq.setFriendlyName("ADCTRL-OpenTransactedSession");
        msgReq.setSessionTag(true);
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("Created ADCTRL TransactionCtrl ResumeTransactedSession Handshake Request", new Object[0]));
        }
        while (response == null) {
            response = this._parent.getSubChannel().doSmfSubSingleShotRequest(msgReq, true, true, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, this._parent.getSubChannel().getConnCounterTag(), corrId);
            if ((long)response.getSmfHeader().getPm_corrtag() == corrId) continue;
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("goet unexpected resume response with corrId " + response.getSmfHeader().getPm_corrtag() + ", expecting " + corrId);
            }
            response = null;
        }
        SMFHeaderBean smfh = response.getSmfHeader();
        int resp_code = smfh.getPm_respcode();
        if (resp_code != 200 && resp_code != 201) {
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info(this._parent.getNetworkInfoString() + "Error Response (" + resp_code + ") - " + smfh.getPm_respstr());
            }
            throw new JCSMPErrorResponseException(resp_code, smfh.getPm_respstr(), "", this._parent.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
        }
        boolean isNewSession = resp_code == 201;
        smfHeader = response.getSmfHeader();
        if (smfHeader.getProtocol() != 9 && smfHeader.getProtocol() != 19) {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedAssuredCtrlResponseGotWrongType"));
        }
        if (!(response.getHeaderBean() instanceof AssuredCtrlHeaderBean)) {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedAssredCtrlResponseBlockNotFound"));
        }
        AssuredCtrlHeaderBean adctrl_response = (AssuredCtrlHeaderBean)response.getHeaderBean();
        this.processResumeTransactedSessionResponse(adctrl_response, ts, isNewSession);
        return ts.getTransactedSessionId();
    }

    private void processResumeTransactedSessionResponse(AssuredCtrlHeaderBean adctrl, AdCtrlV4TransactedSessionImpl ts, boolean isNewSession) throws JCSMPException {
        SmfTLVParameter param = null;
        param = (SmfTLVParameter)adctrl.findFirstParameter(24);
        if (param == null) {
            throw new InvalidMessageReceivedException("TransactedSessionId not found");
        }
        long txSessionId = TlvParameterParser.getAssuredTransactedSessionId(param);
        param = (SmfTLVParameter)adctrl.findFirstParameter(27);
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("processResumeTransactedSessionResponse: name= " + ts.getName() + "; seesionId=" + txSessionId + "; tag=" + ts.getSessionTag());
        }
        if (param != null) {
            AssuredCtrlEnums.TransactedSessionState txSessionState = TlvParameterParser.getAssuredTransactedSessionState(param);
            param = (SmfTLVParameter)adctrl.findFirstParameter(26);
            if (param != null) {
                AssuredCtrlHeaderParameters.ParamTransactionId txid = TlvParameterParser.getAssuredTransactionId(param);
                ts.notifyV3SessionResumed(txSessionId, txSessionState, txid);
                return;
            }
        }
        ts.notifySessionResumed(txSessionId, isNewSession);
    }

    void doCloseTransactedSession(TransactedSessionImpl ts, boolean graceful) {
        if (graceful) {
            long tsessionId = ts.getTransactedSessionId();
            SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
            AssuredCtrlHeaderBean assBean = this._parent.getSession().getAssuredCtrlFactory().createCloseTransactedSession(ts.getName(), (int)tsessionId);
            WireMessage msgReq = WireMessageFactory.createWith(smfHeader, assBean);
            msgReq.setFriendlyName(String.format("TransactedSessionClose[tsid=%s]", tsessionId));
            if (ts instanceof AdCtrlV4TransactedSessionImpl) {
                long corrId = ((AdCtrlV4TransactedSessionImpl)ts).getSessionTag();
                smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(corrId));
            }
            try {
                TcpClientChannel channel = this._parent.getSubChannel();
                int writecode = channel.sendAdCtrlRequest(msgReq, false, TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE, false);
                if (writecode == 1) {
                    channel.enqueuePriorityData(msgReq);
                }
            }
            catch (JCSMPException ex) {
                this.Trace.info(String.format("Error occurred closing transacted session %s, ignoring: %s", new Object[]{ts.getTransactedSessionId(), ex}));
            }
        }
    }

    void doCloseAdCtrlV4TransactedSession(AdCtrlV4TransactedSessionImpl ts) {
        String name = ts.getName();
        long corrId = ts.getSessionTag();
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
        smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(corrId));
        WireMessage response = null;
        AssuredCtrlHeaderBean assBean = null;
        try {
            while (response == null) {
                if (this._parent.isReconnetAborted()) {
                    throw this._parent.getReconnectAbortException();
                }
                try {
                    if (this._parent.getSession().getAssuredCtrlFactory().getVersion() < 4) {
                        this.doCloseTransactedSession(ts, true);
                        return;
                    }
                    assBean = this._parent.getSession().getAssuredCtrlFactory().createCloseTransactedSession(name, (int)ts.getTransactedSessionId());
                    WireMessage msgReq = WireMessageFactory.createWith(smfHeader, assBean);
                    msgReq.setFriendlyName(String.format("TransactedSessionClose[tsid=%s]", ts.toString()));
                    msgReq.setSessionTag(true);
                    response = this._parent.getSubChannel().doSmfSharedRequest(msgReq, 1L, ts.getConnTag(), corrId, true);
                }
                catch (JCSMPException e) {
                    if (ts.getParentSession() != null) {
                        ts.getParentSession().waitUntilSessionReconnectDone("close");
                    }
                    ts.updateConnTag();
                }
            }
            SMFHeaderBean smfh = response.getSmfHeader();
            int resp_code = smfh.getPm_respcode();
            if (resp_code != 200) {
                if (this.Trace.isInfoEnabled()) {
                    this.Trace.info(this._parent.getNetworkInfoString() + "Error Response (" + resp_code + ") - " + smfh.getPm_respstr());
                }
                throw new JCSMPErrorResponseException(resp_code, smfh.getPm_respstr(), "", this._parent.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            }
        }
        catch (JCSMPException e) {
            this.Trace.debug("got exception: " + e.toString());
        }
    }

    public void handleAsyncAssuredCtrlMessage(WireMessage wmsg) throws JCSMPException {
        SmfTLVParameter param;
        this.Trace.debug("Handling assuredCtrl message.");
        assert (wmsg.getHeaderBean() instanceof AssuredCtrlHeaderBean);
        AssuredCtrlHeaderBean adctrl = (AssuredCtrlHeaderBean)wmsg.getHeaderBean();
        int resp_respcode = wmsg.getSmfHeader().getPm_respcode();
        int corrTag = wmsg.getSmfHeader().getPm_corrtag();
        String resp_respphrase = wmsg.getSmfHeader().getPm_respstr();
        JCSMPErrorResponseException err_resp = null;
        if (resp_respcode != 200) {
            err_resp = new JCSMPErrorResponseException(resp_respcode, resp_respphrase, null, this._parent.getSubChannel() != null ? this._parent.getSubChannel().getNetworkInfoString() : "", JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
        }
        if ((param = (SmfTLVParameter)adctrl.findFirstParameter(23)) == null) {
            throw new InvalidMessageReceivedException("Invalid transaction control message.");
        }
        AssuredCtrlEnums.TransactionCtrlMessageType mtype = TlvParameterParser.getAssuredTransactionCtrlMessageType(param);
        this.Trace.debug("Got transaction control type=" + (Object)((Object)mtype) + "; corrTag=" + corrTag + "; resp_respcode=" + resp_respcode + " " + resp_respphrase);
        if (mtype != AssuredCtrlEnums.TransactionCtrlMessageType.CLOSE_TRANSACTED_SESSION_RESPONSE) {
            param = (SmfTLVParameter)adctrl.findFirstParameter(24);
            if (param == null) {
                throw new InvalidMessageReceivedException("TransactedSessionId not found");
            }
            long txSessionId = TlvParameterParser.getAssuredTransactedSessionId(param);
            this._parent.dispatchAssuredCtrlMessage(mtype, txSessionId, adctrl, corrTag, resp_respcode, err_resp);
        }
    }

    public void doSendCommit(long transactedSessionId, AssuredCtrlHeaderParameters.ParamTransactionId tid, AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify pubnotify, AssuredCtrlHeaderParameters.ParamTransactionFDSubAck suback, boolean blockOnAppThread, Integer connIdx) throws JCSMPException {
        AssuredCtrlHeaderBean adctrl = this._parent.getSession().getAssuredCtrlFactory().createCommitTransaction(transactedSessionId, tid, pubnotify, suback);
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(19).setTtl(1);
        smfHeader.setAdf(1);
        smfHeader.addParam(TlvParameterFactorySmf.instance().getTrTopicName(this.assuredctrlPassThruTopic));
        WireMessage msgReq = WireMessageFactory.createWith(smfHeader, adctrl);
        msgReq.setFriendlyName(String.format("TransactedSessionCommit[tsid=%s]", transactedSessionId));
        this._parent.getSubChannel().doSmfSubSingleShotRequest(msgReq, true, false, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, connIdx, null);
    }

    public void doSendAdCtrlV4Commit(long transactedSessionId, long corrId, AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify pubnotify, AssuredCtrlHeaderParameters.ParamTransactionFDSubAck suback, boolean blockOnAppThread, Integer connIdx) throws JCSMPException {
        AssuredCtrlHeaderBean adctrl = this._parent.getSession().getAssuredCtrlFactory().createAdCtrlV4CommitTransaction(transactedSessionId, pubnotify, suback);
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(19).setTtl(1);
        smfHeader.setAdf(1);
        smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(corrId));
        smfHeader.addParam(TlvParameterFactorySmf.instance().getTrTopicName(this.assuredctrlPassThruTopic));
        WireMessage msgReq = WireMessageFactory.createWith(smfHeader, adctrl);
        msgReq.setFriendlyName(String.format("TransactedSessionCommit[tsid=%s]", transactedSessionId));
        if (blockOnAppThread) {
            this._parent.getSubChannel().doSmfSharedRequestOnceNoResponse(msgReq, false, connIdx);
        } else {
            this._parent.getSubChannel().doSmfSubSingleShotRequest(msgReq, true, false, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, connIdx, corrId);
        }
    }

    public void doSendRollback(long transactedSessionId, AssuredCtrlHeaderParameters.ParamTransactionId tid, AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify pubnotify, AssuredCtrlHeaderParameters.ParamTransactionFDSubAck suback, boolean blockOnAppThread, Integer connIdx) throws JCSMPException {
        AssuredCtrlHeaderBean adctrl = this._parent.getSession().getAssuredCtrlFactory().createRollbackTransaction(transactedSessionId, tid, pubnotify, suback);
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(19).setTtl(1);
        smfHeader.setAdf(1);
        smfHeader.addParam(TlvParameterFactorySmf.instance().getTrTopicName(this.assuredctrlPassThruTopic));
        WireMessage msgReq = WireMessageFactory.createWith(smfHeader, adctrl);
        msgReq.setFriendlyName(String.format("TransactedSessionRollback[tsid=%s]", transactedSessionId));
        this._parent.getSubChannel().doSmfSubSingleShotRequest(msgReq, true, false, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, connIdx, null);
    }

    public void doSendAdCtrlV4Rollback(long transactedSessionId, long correlationId, boolean blockOnAppThread, Integer connIdx) throws JCSMPException {
        AssuredCtrlHeaderBean adctrl = this._parent.getSession().getAssuredCtrlFactory().createAdCtrlV4RollbackTransaction(transactedSessionId);
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(19).setTtl(1);
        smfHeader.setAdf(1);
        smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(correlationId));
        smfHeader.addParam(TlvParameterFactorySmf.instance().getTrTopicName(this.assuredctrlPassThruTopic));
        WireMessage msgReq = WireMessageFactory.createWith(smfHeader, adctrl);
        msgReq.setFriendlyName(String.format("TransactedSessionRollback[tsid=%s]", transactedSessionId));
        if (blockOnAppThread) {
            this._parent.getSubChannel().doSmfSharedRequestOnceNoResponse(msgReq, false, connIdx);
        } else {
            this._parent.getSubChannel().doSmfSubSingleShotRequest(msgReq, true, false, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, connIdx, correlationId);
        }
    }
}

