/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmpx.impl;

import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.DestinationConsumer;
import com.solacesystems.jcsmp.DestinationListener;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.XMLMessageConsumer;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmpx.impl.MessageListenerAdapter;

public class TopicConsumerImpl
implements DestinationConsumer {
    private static final String ERROR_OPERATION_NOT_SUPPORTED = JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.operationNotSupportedBasedOnSessionConfig");
    private XMLMessageConsumer m_messageConsumer;

    public TopicConsumerImpl(XMLMessageConsumer messageConsumer) throws JCSMPException {
        if (messageConsumer == null) {
            throw new IllegalArgumentException("null messageConsumer passed in to XMLMessageTopicConsumerImpl(XMLMessageConsumer messageConsumer)");
        }
        this.m_messageConsumer = messageConsumer;
    }

    @Override
    public void close() {
        this.m_messageConsumer.close();
    }

    @Override
    public DestinationListener getMessageDestinationListener() {
        return ((MessageListenerAdapter)this.m_messageConsumer.getMessageListener()).getMessageTopicListener();
    }

    private BytesXMLMessage convert(BytesXMLMessage message) {
        if (message != null) {
            return message;
        }
        return null;
    }

    @Override
    public BytesXMLMessage receive() throws JCSMPException {
        BytesXMLMessage message = this.m_messageConsumer.receive();
        return this.convert(message);
    }

    @Override
    public BytesXMLMessage receive(int timeoutInMillis) throws JCSMPException {
        BytesXMLMessage message = this.m_messageConsumer.receive(timeoutInMillis);
        return this.convert(message);
    }

    @Override
    public BytesXMLMessage receiveNoWait() throws JCSMPException {
        BytesXMLMessage message = this.m_messageConsumer.receiveNoWait();
        return this.convert(message);
    }

    @Override
    public void start() throws JCSMPException {
        this.m_messageConsumer.start();
    }

    @Override
    public void stop() {
        this.m_messageConsumer.stop();
    }

    @Override
    public void startSync() throws JCSMPException {
        this.m_messageConsumer.startSync();
    }

    @Override
    public void stopSync() throws JCSMPInterruptedException {
        this.m_messageConsumer.stopSync();
    }

    @Override
    public void closeSync() throws JCSMPException {
        this.m_messageConsumer.closeSync();
    }

    @Override
    public void closeSync(boolean linger) throws JCSMPException {
        this.m_messageConsumer.closeSync(linger);
    }

    @Override
    public boolean stopSyncStart() {
        return this.m_messageConsumer.stopSyncStart();
    }

    @Override
    public void stopSyncWait() throws JCSMPInterruptedException {
        this.m_messageConsumer.stopSyncWait();
    }
}

