/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.jcsmp.protocol.smf.AbstractHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.FastSmfParamContainer;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;

public class AssuredCtrlHeaderBean
extends AbstractHeaderBean {
    public static final int ASSUREDCTRL_MSG_HANDSHAKE = 0;
    public static final int ASSUREDCTRL_MSG_CLIENTACK = 3;
    public static final int ASSUREDCTRL_MSG_BIND = 4;
    public static final int ASSUREDCTRL_MSG_UNBIND = 5;
    public static final int ASSUREDCTRL_MSG_UNSUBSCRIBE = 6;
    public static final int ASSUREDCTRL_MSG_CLOSEFLOW = 7;
    public static final int ASSUREDCTRL_MSG_CREATE = 8;
    public static final int ASSUREDCTRL_MSG_DELETE = 9;
    public static final int ASSUREDCTRL_MSG_FLOWRECOVER = 10;
    public static final int ASSUREDCTRL_MSG_TRANSACTIONCTRL = 11;
    public static final int ASSUREDCTRL_MSG_FLOWCHANGEUPDATE = 12;
    public static final int ASSUREDCTRL_MSG_XACTRL = 14;
    private int assuredCtrlVersion = 1;
    private int msgType = 0;
    private FastSmfParamContainer paramCnt = new FastSmfParamContainer();

    @Override
    public void reset() {
        super.reset();
        this.assuredCtrlVersion = 1;
        this.msgType = 0;
        this.paramCnt.reset();
    }

    public SmfTLVParameter[] getParams() {
        SmfTLVParameter[] theArray = new SmfTLVParameter[this.paramList.size()];
        return this.paramList.toArray(theArray);
    }

    public void addParamFastEnc(int uh, int type, byte[] value) {
        this.paramCnt.addParamAssuredCtrl(uh, type, value);
    }

    public void addEncodedParam(byte[] encodedParam) {
        this.paramCnt.addEncodedParam(encodedParam);
    }

    public int getEncodedParamsLen() {
        return this.paramCnt.getEncodedParamsLen();
    }

    public FastSmfParamContainer getParamContainer() {
        return this.paramCnt;
    }

    @Override
    public int getSmfEncodedLength() {
        int totalLen = 3;
        if (this.assuredCtrlVersion == 3) {
            totalLen = 6;
        }
        if (this.paramCnt.getEncodedParamsLen() != 0) {
            totalLen += this.paramCnt.getEncodedParamsLen();
        } else {
            for (int i = 0; i < this.paramList.size(); ++i) {
                totalLen += ((SmfTLVParameter)this.paramList.get(i)).getSmfEncodedLength();
            }
        }
        while (totalLen % 4 != 0) {
            ++totalLen;
        }
        return totalLen;
    }

    public void getEncodedParams(byte[] paramData) {
        this.paramCnt.getEncodedParams(paramData);
    }

    public int getAssuredCtrlVersion() {
        return this.assuredCtrlVersion;
    }

    public void setAssuredCtrlVersion(int assuredCtrlVersion) {
        this.assuredCtrlVersion = assuredCtrlVersion;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public String toString() {
        String s = "version=" + this.assuredCtrlVersion + ";" + "type=" + this.msgType;
        return s;
    }
}

