/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireEncoder;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.GrowableByteBuffer;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFHeaderFieldConstants;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFNumericConstants;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import java.io.IOException;
import java.io.OutputStream;

public class SMFHeaderEncoder
implements SMFHeaderFieldConstants,
SMFNumericConstants,
WireEncoder {
    GrowableByteBuffer buf = GrowableByteBuffer.allocate(4096);
    byte[] paramData = new byte[1024];
    byte[] hdr_buf12 = new byte[12];

    public void encodeHeader(OutputStream out, HeaderDescriptionBean headerBean) throws IOException {
        if (!(headerBean instanceof SMFHeaderBean)) {
            throw new IllegalArgumentException();
        }
        SMFHeaderBean h = (SMFHeaderBean)headerBean;
        this.buf.clear();
        SmfTLVParameter[] paramArray = h.getParams();
        this.buf.ensureObjectFit(h.getSmfEncodedLength());
        for (int i = 0; i < paramArray.length; ++i) {
            SmfTLVParameter param = paramArray[i];
            TlvCoderUtil.writeTlvParam(this.buf, param);
        }
        long word1 = 0L;
        long word2 = 0L;
        long word3 = 0L;
        switch (h.getSmfVersion()) {
            case 2: {
                int position = this.buf.position();
                int pad = 4 - position % 4;
                switch (pad) {
                    case 1: {
                        this.buf.put((byte)0);
                        break;
                    }
                    case 2: {
                        this.buf.put(new byte[]{0, 0});
                        break;
                    }
                    case 3: {
                        this.buf.put(new byte[]{0, 0, 0});
                        break;
                    }
                }
                int smfHeaderLenBytes = 8 + this.buf.position();
                word1 = BitTwiddleUtil.setBits(word1, h.getDi(), 1, 31);
                word1 = BitTwiddleUtil.setBits(word1, h.getSmfVersion(), 3, 24);
                word1 = BitTwiddleUtil.setBits(word1, h.getUh(), 2, 22);
                word1 = BitTwiddleUtil.setBits(word1, h.getProtocol(), 6, 16);
                word1 = BitTwiddleUtil.setBits(word1, h.getMsgPri(), 4, 12);
                word1 = BitTwiddleUtil.setBits(word1, smfHeaderLenBytes / 4, 12, 0);
                word2 = BitTwiddleUtil.setBits(word2, h.getTtl(), 8, 24);
                word2 = BitTwiddleUtil.setBits(word2, h.getMsgLen() + smfHeaderLenBytes, 24, 0);
                break;
            }
            case 3: {
                int smfHeaderLenBytes = 12 + this.buf.position();
                word1 = BitTwiddleUtil.setBits(word1, h.getDi(), 1, 31);
                word1 = BitTwiddleUtil.setBits(word1, h.getElidingEligible(), 1, 30);
                word1 = BitTwiddleUtil.setBits(word1, h.getAdf(), 1, 28);
                word1 = BitTwiddleUtil.setBits(word1, h.getSmfVersion(), 3, 24);
                word1 = BitTwiddleUtil.setBits(word1, h.getUh(), 2, 22);
                word1 = BitTwiddleUtil.setBits(word1, h.getProtocol(), 6, 16);
                word1 = BitTwiddleUtil.setBits(word1, h.getMsgPri(), 4, 12);
                word1 = BitTwiddleUtil.setBits(word1, h.getTtl(), 8, 0);
                word2 = BitTwiddleUtil.setBits(word2, smfHeaderLenBytes, 32, 0);
                word3 = BitTwiddleUtil.setBits(word3, smfHeaderLenBytes + h.getMsgLen(), 32, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.buf.flip();
        int paramDataLen = this.buf.limit();
        if (paramDataLen > this.paramData.length) {
            this.paramData = new byte[this.buf.limit()];
        }
        this.buf.get(this.paramData, 0, paramDataLen);
        int hdrLenToWrite = 8;
        NetworkByteOrderNumberUtil.intToFourByte(word1, this.hdr_buf12, 0);
        NetworkByteOrderNumberUtil.intToFourByte(word2, this.hdr_buf12, 4);
        if (word3 != 0L) {
            NetworkByteOrderNumberUtil.intToFourByte(word3, this.hdr_buf12, 8);
            hdrLenToWrite = 12;
        }
        out.write(this.hdr_buf12, 0, hdrLenToWrite);
        if (paramDataLen > 0) {
            out.write(this.paramData, 0, paramDataLen);
        }
    }
}

