/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.vertx.encoders;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import sttp.capabilities.package;
import sttp.model.HasHeaders;
import sttp.model.Part;
import sttp.model.Part$;
import sttp.tapir.CodecFormat;
import sttp.tapir.FileRange;
import sttp.tapir.RawBodyType;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.server.interpreter.ToResponseBody;
import sttp.tapir.server.vertx.VertxServerOptions;
import sttp.tapir.server.vertx.encoders.package$;
import sttp.tapir.server.vertx.streams.Pipe$;
import sttp.tapir.server.vertx.streams.ReadStreamCompatible;

@ScalaSignature(bytes="\u0006\u0001\t\u001db\u0001\u0002\b\u0010\u0001iA\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tW\u0002\u0011)\u0019!C\u0002Y\"A1\u000f\u0001B\u0001B\u0003%Q\u000eC\u0003u\u0001\u0011\u0005Q\u000fC\u0004q\u0001\t\u0007I\u0011I>\t\rq\u0004\u0001\u0015!\u0003M\u0011\u0015i\b\u0001\"\u0011\u007f\u0011\u001d\t\t\u0004\u0001C!\u0003gAq!!\u0018\u0001\t\u0003\ny\u0006C\u0004\u0002\f\u0002!I!!$\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0007b\u0002B\u0007\u0001\u0011%!q\u0002\u0002\u0014-\u0016\u0014H\u000f\u001f+p%\u0016\u001c\bo\u001c8tK\n{G-\u001f\u0006\u0003!E\t\u0001\"\u001a8d_\u0012,'o\u001d\u0006\u0003%M\tQA^3sibT!\u0001F\u000b\u0002\rM,'O^3s\u0015\t1r#A\u0003uCBL'OC\u0001\u0019\u0003\u0011\u0019H\u000f\u001e9\u0004\u0001U\u00191D\u0019$\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0005G\u0019BC)D\u0001%\u0015\t)3#A\u0006j]R,'\u000f\u001d:fi\u0016\u0014\u0018BA\u0014%\u00059!vNU3ta>t7/\u001a\"pIf\u0004B!H\u0015,m%\u0011!F\b\u0002\n\rVt7\r^5p]F\u0002\"\u0001\f\u001b\u000e\u00035R!AL\u0018\u0002\u0007],'M\u0003\u00021c\u0005\u0019Q\r\u001f;\u000b\u0005I\u0011$\"A\u001a\u0002\u0005%|\u0017BA\u001b.\u00059\u0011v.\u001e;j]\u001e\u001cuN\u001c;fqR\u00042a\u000e\u001e=\u001b\u0005A$BA\u001d2\u0003\u0011\u0019wN]3\n\u0005mB$A\u0002$viV\u0014X\r\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006!A.\u00198h\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\tY{\u0017\u000e\u001a\t\u0003\u000b\u001ac\u0001\u0001B\u0003H\u0001\t\u0007\u0001JA\u0001T#\tIE\n\u0005\u0002\u001e\u0015&\u00111J\b\u0002\b\u001d>$\b.\u001b8h!\ri\u0015\f\u0012\b\u0003\u001dZs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005IK\u0012A\u0002\u001fs_>$h(C\u0001\u0019\u0013\t)v#\u0001\u0007dCB\f'-\u001b7ji&,7/\u0003\u0002X1\u00069\u0001/Y2lC\u001e,'BA+\u0018\u0013\tQ6LA\u0004TiJ,\u0017-\\:\u000b\u0005]C\u0016!D:feZ,'o\u00149uS>t7\u000fE\u0002_?\u0006l\u0011!E\u0005\u0003AF\u0011!CV3sib\u001cVM\u001d<fe>\u0003H/[8ogB\u0011QI\u0019\u0003\u0006G\u0002\u0011\r\u0001\u001a\u0002\u0002\rV\u0011Q-[\t\u0003\u0013\u001a\u0004\"!H4\n\u0005!t\"aA!os\u0012)!N\u0019b\u0001K\n\tq,\u0001\u000bsK\u0006$7\u000b\u001e:fC6\u001cu.\u001c9bi&\u0014G.Z\u000b\u0002[B\u0019a.\u001d#\u000e\u0003=T!\u0001]\t\u0002\u000fM$(/Z1ng&\u0011!o\u001c\u0002\u0015%\u0016\fGm\u0015;sK\u0006l7i\\7qCRL'\r\\3\u0002+I,\u0017\rZ*ue\u0016\fWnQ8na\u0006$\u0018N\u00197fA\u00051A(\u001b8jiz\"\"A\u001e>\u0015\u0005]L\b\u0003\u0002=\u0001C\u0012k\u0011a\u0004\u0005\u0006W\u0012\u0001\u001d!\u001c\u0005\u00069\u0012\u0001\r!X\u000b\u0002\u0019\u0006A1\u000f\u001e:fC6\u001c\b%\u0001\u0007ge>l'+Y<WC2,X-F\u0002\u0000\u0003\u000f!\u0012\u0002KA\u0001\u0003\u0017\tY\"a\n\t\u000f\u0005\rq\u00011\u0001\u0002\u0006\u0005\ta\u000fE\u0002F\u0003\u000f!a!!\u0003\b\u0005\u0004)'!\u0001*\t\u000f\u00055q\u00011\u0001\u0002\u0010\u00059\u0001.Z1eKJ\u001c\b\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005Uq#A\u0003n_\u0012,G.\u0003\u0003\u0002\u001a\u0005M!A\u0003%bg\"+\u0017\rZ3sg\"9\u0011QD\u0004A\u0002\u0005}\u0011A\u00024pe6\fG\u000f\u0005\u0003\u0002\"\u0005\rR\"A\u000b\n\u0007\u0005\u0015RCA\u0006D_\u0012,7MR8s[\u0006$\bbBA\u0015\u000f\u0001\u0007\u00111F\u0001\tE>$\u0017\u0010V=qKB1\u0011\u0011EA\u0017\u0003\u000bI1!a\f\u0016\u0005-\u0011\u0016m\u001e\"pIf$\u0016\u0010]3\u0002\u001f\u0019\u0014x.\\*ue\u0016\fWNV1mk\u0016$\u0012\u0002KA\u001b\u0003\u0003\n\u0019%!\u0012\t\u000f\u0005\r\u0001\u00021\u0001\u00028A!\u0011\u0011HA\u001f\u001d\r\tY$B\u0007\u0002\u0001%\u0019\u0011qH-\u0003\u0019\tKg.\u0019:z'R\u0014X-Y7\t\u000f\u00055\u0001\u00021\u0001\u0002\u0010!9\u0011Q\u0004\u0005A\u0002\u0005}\u0001bBA$\u0011\u0001\u0007\u0011\u0011J\u0001\bG\"\f'o]3u!\u0015i\u00121JA(\u0013\r\tiE\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005E\u0013\u0011L\u0007\u0003\u0003'RA!a\u0012\u0002V)\u0019\u0011q\u000b!\u0002\u00079Lw.\u0003\u0003\u0002\\\u0005M#aB\"iCJ\u001cX\r^\u0001\u0012MJ|WnV3c'>\u001c7.\u001a;QSB,WCBA1\u0003_\n)\bF\u0003)\u0003G\nI\bC\u0004\u0002f%\u0001\r!a\u001a\u0002\tAL\u0007/\u001a\t\t\u0003s\tI'!\u001c\u0002t%\u0019\u00111N-\u0003\tAK\u0007/\u001a\t\u0004\u000b\u0006=DABA9\u0013\t\u0007QMA\u0002S\u000bF\u00032!RA;\t\u0019\t9(\u0003b\u0001K\n!!+R*Q\u0011\u001d\tY(\u0003a\u0001\u0003{\n\u0011a\u001c\u0019\u0005\u0003\u007f\n9\tE\u0007\u0002\"\u0005\u0005\u0015qMA7\u0003g\n)\tR\u0005\u0004\u0003\u0007+\"aE,fEN{7m[3u\u0005>$\u0017pT;uaV$\bcA#\u0002\b\u0012Y\u0011\u0011RA=\u0003\u0003\u0005\tQ!\u0001f\u0005\ryF%M\u0001\u0018Q\u0006tG\r\\3Nk2$\u0018\u000e\u001d7f\u0005>$\u0017\u0010U1siN,b!a$\u0002:\u0006\u0015FCBAI\u0003/\u000b)\fF\u0002)\u0003'Ca!!&\u000b\u0001\bi\u0016aD3oIB|\u0017N\u001c;PaRLwN\\:\t\u000f\u0005e%\u00021\u0001\u0002\u001c\u0006IQ.\u001e7uSB\f'\u000f\u001e\n\u0007\u0003;\u000b\t+a*\u0007\r\u0005}\u0005\u0001AAN\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0019\t\t#!\f\u0002$B\u0019Q)!*\u0005\r\u0005%!B1\u0001f!\u0011\tI+a,\u000f\t\u0005\u0005\u00121V\u0005\u0004\u0003[+\u0012a\u0003*bo\n{G-\u001f+za\u0016LA!!-\u00024\niQ*\u001e7uSB\f'\u000f\u001e\"pIfT1!!,\u0016\u0011\u001d\t9L\u0003a\u0001\u0003G\u000b\u0011A\u001d\u0003\b\u0003wS!\u0019AA_\u0005\t\u0019e)E\u0002J\u0003?\ta\u0002[1oI2,'i\u001c3z!\u0006\u0014H/\u0006\u0003\u0002D\u0006eGCBAc\u0003\u0013\fi\rF\u0002)\u0003\u000fDa!!&\f\u0001\bi\u0006bBAf\u0017\u0001\u0007\u0011qU\u0001\u0002[\"9\u0011qZ\u0006A\u0002\u0005E\u0017\u0001\u00029beR\u0004b!!\u0005\u0002T\u0006]\u0017\u0002BAk\u0003'\u0011A\u0001U1siB\u0019Q)!7\u0005\r\u0005m7B1\u0001f\u0005\u0005!\u0016\u0001E<sSR,\u0007+\u0019:u\u0011\u0016\fG-\u001a:t)\u0011\t\tO!\u0001\u0011\ruI\u00131]Ax!\u0011\t)/a;\u000e\u0005\u0005\u001d(bAAuq\u0005!\u0001\u000e\u001e;q\u0013\u0011\ti/a:\u0003%!#H\u000f]*feZ,'OU3ta>t7/\u001a\t\u0005oi\n\t\u0010\u0005\u0003\u0002t\u0006mh\u0002BA{\u0003o\u0004\"\u0001\u0015\u0010\n\u0007\u0005eh$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003{\fyP\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003st\u0002bBAh\u0019\u0001\u0007!1\u0001\u0019\u0005\u0005\u000b\u0011I\u0001\u0005\u0004\u0002\u0012\u0005M'q\u0001\t\u0004\u000b\n%Aa\u0003B\u0006\u0005\u0003\t\t\u0011!A\u0003\u0002\u0015\u00141a\u0018\u00134\u000359(/\u001b;f\u0005>$\u0017\u0010U1siV1!\u0011\u0003B\u0013\u0005;!\u0002Ba\u0005\u0003\u0018\t}!1\u0005\u000b\u0004Q\tU\u0001BBAK\u001b\u0001\u000fQ\fC\u0004\u0002*5\u0001\rA!\u0007\u0011\r\u0005\u0005\u0012Q\u0006B\u000e!\r)%Q\u0004\u0003\u0007\u0003\u0013i!\u0019A3\t\u000f\t\u0005R\u00021\u0001\u0002r\u0006Y1m\u001c8uK:$H+\u001f9f\u0011\u001d\t9,\u0004a\u0001\u00057!q!a/\u000e\u0005\u0004\ti\f")
public class VertxToResponseBody<F, S extends package.Streams<S>>
implements ToResponseBody<Function1<RoutingContext, Future<Void>>, S> {
    private final VertxServerOptions<F> serverOptions;
    private final ReadStreamCompatible<S> readStreamCompatible;
    private final package.Streams<S> streams;
    private volatile boolean bitmap$init$0;

    public ReadStreamCompatible<S> readStreamCompatible() {
        return this.readStreamCompatible;
    }

    public package.Streams<S> streams() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/tapir/tapir/server/vertx/src/main/scala/sttp/tapir/server/vertx/encoders/VertxToResponseBody.scala: 21");
        }
        return this.streams;
    }

    public <R> Function1<RoutingContext, Future<Void>> fromRawValue(R v, HasHeaders headers, CodecFormat format, RawBodyType<R> bodyType) {
        return (Function1 & Serializable & scala.Serializable)rc -> {
            Future future;
            HttpServerResponse resp = rc.response();
            RawBodyType rawBodyType = bodyType;
            if (rawBodyType instanceof RawBodyType.StringBody) {
                RawBodyType.StringBody stringBody = (RawBodyType.StringBody)rawBodyType;
                Charset charset = stringBody.charset();
                future = resp.end(((String)v).toString(), charset.toString());
            } else if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
                future = resp.end((Object)Buffer.buffer((byte[])((byte[])v)));
            } else if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
                future = resp.end((Object)Buffer.buffer().setBytes(0, (ByteBuffer)v));
            } else if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
                future = package$.MODULE$.inputStreamToBuffer((InputStream)v, rc.vertx()).flatMap(x$1 -> resp.end(x$1));
            } else if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
                FileRange tapirFile = (FileRange)v;
                future = (Future)tapirFile.range().flatMap((Function1 & Serializable & scala.Serializable)r -> r.startAndEnd().map((Function1 & Serializable & scala.Serializable)s -> resp.sendFile(((Object)tapirFile.file().toPath()).toString(), s._1$mcJ$sp(), r.contentLength()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> resp.sendFile(tapirFile.file().toString()));
            } else if (rawBodyType instanceof RawBodyType.MultipartBody) {
                RawBodyType.MultipartBody multipartBody = (RawBodyType.MultipartBody)rawBodyType;
                future = (Future)this.handleMultipleBodyParts(multipartBody, v, $this.serverOptions).apply(rc);
            } else {
                throw new MatchError((Object)rawBodyType);
            }
            return future;
        };
    }

    public Function1<RoutingContext, Future<Void>> fromStreamValue(Object v, HasHeaders headers, CodecFormat format, Option<Charset> charset) {
        return (Function1 & Serializable & scala.Serializable)rc -> {
            Pipe$.MODULE$.apply(this.readStreamCompatible().asReadStream(v), (WriteStream<Buffer>)rc.response());
            return Future.succeededFuture((Object)BoxedUnit.UNIT).mapEmpty();
        };
    }

    public <REQ, RESP> Function1<RoutingContext, Future<Void>> fromWebSocketPipe(Object pipe, WebSocketBodyOutput<Object, REQ, RESP, ?, S> o) {
        throw new UnsupportedOperationException();
    }

    private <CF extends CodecFormat, R> Function1<RoutingContext, Future<Void>> handleMultipleBodyParts(RawBodyType.MultipartBody multipart, R r, VertxServerOptions<F> endpointOptions) {
        return (Function1 & Serializable & scala.Serializable)rc -> {
            HttpServerResponse resp = rc.response();
            resp.setChunked(true);
            resp.putHeader(((Object)HttpHeaders.CONTENT_TYPE).toString(), "multipart/form-data");
            return ((Future)((Seq)r).foldLeft((Object)Future.succeededFuture(), (Function2 & Serializable & scala.Serializable)(acc, part) -> acc.flatMap(x$1 -> (Future)this.handleBodyPart(multipart, (Part)part, endpointOptions).apply(rc)))).flatMap(x$2 -> resp.end());
        };
    }

    private <T> Function1<RoutingContext, Future<Void>> handleBodyPart(RawBodyType.MultipartBody m, Part<T> part, VertxServerOptions<F> endpointOptions) {
        return (Function1 & Serializable & scala.Serializable)rc -> {
            HttpServerResponse resp = rc.response();
            return (Future)m.partType(part.name()).map((Function1 & Serializable & scala.Serializable)partType -> ((Future)this.writePartHeaders(part).apply((Object)resp)).flatMap(contentType -> (Future)this.writeBodyPart((RawBodyType)partType, (String)contentType, (Object)part.body(), endpointOptions).apply(rc))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Future.succeededFuture());
        };
    }

    private Function1<HttpServerResponse, Future<String>> writePartHeaders(Part<?> part) {
        return (Function1 & Serializable & scala.Serializable)resp -> {
            part.headers().foreach((Function1 & Serializable & scala.Serializable)h -> resp.headers().add(h.name(), h.value()));
            String partContentType = (String)part.contentType().getOrElse((Function0 & Serializable & scala.Serializable)() -> "application/octet-stream");
            Map dispositionParams = part.otherDispositionParams().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Part$.MODULE$.NameDispositionParam()), (Object)part.name()));
            Iterable dispositionsHeaderParts = (Iterable)dispositionParams.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                String string = new StringBuilder(3).append(k).append("=\"").append(v).append("\"").toString();
                return string;
            }, Iterable$.MODULE$.canBuildFrom());
            return resp.write(new StringBuilder(13).append(HttpHeaders.CONTENT_DISPOSITION).append(": form-data; ").append(dispositionsHeaderParts.mkString(", ")).toString()).flatMap(x$3 -> resp.write("\n")).flatMap(x$4 -> resp.write(new StringBuilder(2).append(HttpHeaders.CONTENT_TYPE).append(": ").append(partContentType).toString())).flatMap(x$5 -> resp.write("\n\n")).flatMap(x$6 -> Future.succeededFuture((Object)partContentType));
        };
    }

    private <CF extends CodecFormat, R> Function1<RoutingContext, Future<Void>> writeBodyPart(RawBodyType<R> bodyType, String contentType, R r, VertxServerOptions<F> endpointOptions) {
        return (Function1 & Serializable & scala.Serializable)rc -> {
            HttpServerResponse resp = rc.response();
            return resp.write(new StringBuilder(2).append(HttpHeaders.CONTENT_TYPE).append(": ").append(contentType).toString()).flatMap(x$7 -> resp.write("\n")).flatMap(x$8 -> {
                Future future;
                RawBodyType rawBodyType = bodyType;
                if (rawBodyType instanceof RawBodyType.StringBody) {
                    RawBodyType.StringBody stringBody = (RawBodyType.StringBody)rawBodyType;
                    Charset charset = stringBody.charset();
                    future = resp.write(((String)r).toString(), charset.toString());
                } else if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
                    future = resp.write((Object)Buffer.buffer((byte[])((byte[])r)));
                } else if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
                    future = resp.write((Object)Buffer.buffer().setBytes(0, (ByteBuffer)r));
                } else if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
                    future = package$.MODULE$.inputStreamToBuffer((InputStream)r, rc.vertx()).flatMap(x$1 -> resp.write(x$1));
                } else if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
                    File file = ((FileRange)r).file();
                    future = rc.vertx().fileSystem().readFile(file.getAbsolutePath()).flatMap(buf -> resp.write(new StringBuilder(15).append(((Object)HttpHeaders.CONTENT_DISPOSITION).toString()).append(": file; file=\"").append(file.getName()).append("\"").toString()).flatMap(x$9 -> resp.write("\n")).flatMap(x$10 -> resp.write(buf)).flatMap(x$11 -> resp.write("\n\n")));
                } else if (rawBodyType instanceof RawBodyType.MultipartBody) {
                    RawBodyType.MultipartBody multipartBody = (RawBodyType.MultipartBody)rawBodyType;
                    future = (Future)this.handleMultipleBodyParts(multipartBody, r, endpointOptions).apply(rc);
                } else {
                    throw new MatchError((Object)rawBodyType);
                }
                return future;
            });
        };
    }

    public VertxToResponseBody(VertxServerOptions<F> serverOptions, ReadStreamCompatible<S> readStreamCompatible) {
        this.serverOptions = serverOptions;
        this.readStreamCompatible = readStreamCompatible;
        this.streams = readStreamCompatible.streams();
        this.bitmap$init$0 = true;
    }
}

