/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.vertx.decoders;

import io.vertx.core.buffer.Buffer;
import io.vertx.scala.core.MultiMap;
import io.vertx.scala.core.file.FileSystem;
import io.vertx.scala.ext.web.FileUpload;
import io.vertx.scala.ext.web.RoutingContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import sttp.model.Part;
import sttp.model.Part$;
import sttp.tapir.Codec;
import sttp.tapir.DecodeResult;
import sttp.tapir.Endpoint;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.EndpointOutput;
import sttp.tapir.RawBodyType;
import sttp.tapir.internal.package;
import sttp.tapir.server.DecodeFailureContext;
import sttp.tapir.server.DecodeFailureHandling;
import sttp.tapir.server.internal.DecodeInputs$;
import sttp.tapir.server.internal.DecodeInputsContext;
import sttp.tapir.server.internal.DecodeInputsResult;
import sttp.tapir.server.internal.InputValues$;
import sttp.tapir.server.internal.InputValuesResult;
import sttp.tapir.server.vertx.VertxEndpointOptions;
import sttp.tapir.server.vertx.decoders.VertxDecodeInputsContext;
import sttp.tapir.server.vertx.decoders.VertxDecodeInputsContext$;
import sttp.tapir.server.vertx.encoders.VertxOutputEncoders$;
import sttp.tapir.server.vertx.handlers.package$;

public final class VertxInputDecoders$ {
    public static VertxInputDecoders$ MODULE$;

    static {
        new VertxInputDecoders$();
    }

    public <E> void decodeBodyAndInputsThen(Endpoint<?, E, ?, ?> endpoint, RoutingContext rc, Function1<package.Params, BoxedUnit> logicHandler2, VertxEndpointOptions endpointOptions, Option<ClassTag<E>> ect) {
        this.decodeBodyAndInputs(endpoint, rc, endpointOptions).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            VertxInputDecoders$.$anonfun$decodeBodyAndInputsThen$1(endpoint, logicHandler2, rc, endpointOptions, ect, x0$1);
            return BoxedUnit.UNIT;
        }, endpointOptions.executionContextOrCurrentCtx(rc));
    }

    private Future<DecodeInputsResult> decodeBodyAndInputs(Endpoint<?, ?, ?, ?> e, RoutingContext rc, VertxEndpointOptions serverOptions) {
        return this.decodeBody(DecodeInputs$.MODULE$.apply(e.input(), (DecodeInputsContext)new VertxDecodeInputsContext(rc, VertxDecodeInputsContext$.MODULE$.$lessinit$greater$default$2())), rc, serverOptions);
    }

    private Future<DecodeInputsResult> decodeBody(DecodeInputsResult result, RoutingContext rc, VertxEndpointOptions serverOptions) {
        Future future;
        ExecutionContext ec = serverOptions.executionContextOrCurrentCtx(rc);
        DecodeInputsResult decodeInputsResult = result;
        if (decodeInputsResult instanceof DecodeInputsResult.Values) {
            Some some;
            EndpointIO.Body bodyInput;
            Future future2;
            DecodeInputsResult.Values values = (DecodeInputsResult.Values)decodeInputsResult;
            Option option = values.bodyInput();
            if (None$.MODULE$.equals(option)) {
                future2 = Future$.MODULE$.successful((Object)values);
            } else if (option instanceof Some && (bodyInput = (EndpointIO.Body)(some = (Some)option).value()) instanceof EndpointIO.Body) {
                EndpointIO.Body body = bodyInput;
                RawBodyType bodyType = body.bodyType();
                Codec codec = body.codec();
                future2 = this.extractRawBody(bodyType, rc, serverOptions).map((Function1 & Serializable & scala.Serializable)l -> codec.decode(l), ec).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    DecodeInputsResult.Values values;
                    DecodeResult decodeResult = x0$1;
                    if (decodeResult instanceof DecodeResult.Value) {
                        DecodeResult.Value value = (DecodeResult.Value)decodeResult;
                        Object body = value.v();
                        values = values.setBodyInputValue(body);
                    } else if (decodeResult instanceof DecodeResult.Failure) {
                        DecodeResult.Failure failure = (DecodeResult.Failure)decodeResult;
                        values = new DecodeInputsResult.Failure((EndpointInput.Basic)body, failure);
                    } else {
                        throw new MatchError((Object)decodeResult);
                    }
                    return values;
                }, ec);
            } else {
                throw new MatchError((Object)option);
            }
            future = future2;
        } else if (decodeInputsResult instanceof DecodeInputsResult.Failure) {
            DecodeInputsResult.Failure failure = (DecodeInputsResult.Failure)decodeInputsResult;
            future = Future$.MODULE$.successful((Object)failure);
        } else {
            throw new MatchError((Object)decodeInputsResult);
        }
        return future;
    }

    private <B> Future<B> extractRawBody(RawBodyType<B> bodyType2, RoutingContext rc, VertxEndpointOptions serverOptions) {
        Future future;
        ExecutionContext ec = serverOptions.executionContextOrCurrentCtx(rc);
        RawBodyType<B> rawBodyType = bodyType2;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            RawBodyType.StringBody stringBody = (RawBodyType.StringBody)rawBodyType;
            Charset defaultCharset = stringBody.charset();
            future = Future$.MODULE$.successful(rc.getBodyAsString(defaultCharset.toString()).get());
        } else if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            future = Future$.MODULE$.successful((Object)((Buffer)rc.getBody().get()).getBytes());
        } else if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            future = Future$.MODULE$.successful((Object)((Buffer)rc.getBody().get()).getByteBuf().nioBuffer());
        } else if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            future = Future$.MODULE$.successful((Object)new ByteArrayInputStream(((Buffer)rc.getBody().get()).getBytes()));
        } else if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            Future future2;
            List list = rc.fileUploads().toList();
            Some some = List$.MODULE$.unapplySeq((Seq)list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0) {
                FileUpload upload = (FileUpload)((LinearSeqOptimized)some.get()).apply(0);
                future2 = Future$.MODULE$.successful((Object)new File(upload.uploadedFileName()));
            } else {
                Some some2 = List$.MODULE$.unapplySeq((Seq)list);
                if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(0) == 0 && rc.getBody().isDefined()) {
                    String filePath = new StringBuilder(8).append(serverOptions.uploadDirectory().getAbsolutePath()).append("/tapir-").append(new Date().getTime()).append("-").append(Random$.MODULE$.nextLong()).toString();
                    FileSystem fs = rc.vertx().fileSystem();
                    future2 = fs.createFileFuture(filePath).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> fs.writeFileFuture(filePath, (Buffer)rc.getBody().get()).map((Function1 & Serializable & scala.Serializable)x$2 -> new File(filePath), ec), ec);
                } else {
                    throw new MatchError((Object)list);
                }
            }
            future = future2;
        } else if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody multipartBody = (RawBodyType.MultipartBody)rawBodyType;
            Map partTypes = multipartBody.partTypes();
            Option defaultType = multipartBody.defaultType();
            Map defaultParts = (Map)defaultType.fold((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty(), (Function1 & Serializable & scala.Serializable)bodyType -> {
                Set files = (Set)rc.fileUploads().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Set$.MODULE$.canBuildFrom());
                Set form = rc.request().formAttributes().names();
                return ((TraversableOnce)files.$plus$plus((GenTraversableOnce)form).diff((GenSet)partTypes.keySet()).map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), bodyType), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            });
            Map allParts = defaultParts.$plus$plus((GenTraversableOnce)partTypes);
            future = Future$.MODULE$.successful((Object)((TraversableOnce)allParts.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String partName = (String)tuple2._1();
                RawBodyType rawBodyType = (RawBodyType)tuple2._2();
                Part part = Part$.MODULE$.apply(partName, MODULE$.extractPart(partName, rawBodyType, rc), Part$.MODULE$.apply$default$3(), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6());
                return part;
            }, Iterable$.MODULE$.canBuildFrom())).toSeq());
        } else {
            throw new MatchError(rawBodyType);
        }
        return future;
    }

    private <B> B extractPart(String name, RawBodyType<B> bodyType, RoutingContext rc) {
        Object object;
        RawBodyType<B> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            RawBodyType.StringBody stringBody = (RawBodyType.StringBody)rawBodyType;
            Charset charset = stringBody.charset();
            object = new String(this.readBytes(name, rc, charset));
        } else if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            object = this.readBytes(name, rc, Charset.defaultCharset());
        } else if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            object = ByteBuffer.wrap(this.readBytes(name, rc, Charset.defaultCharset()));
        } else {
            if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
                throw new IllegalArgumentException("Cannot create a multipart as an InputStream");
            }
            if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
                FileUpload f = (FileUpload)rc.fileUploads().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)VertxInputDecoders$.$anonfun$extractPart$1(name, x$5))).get();
                object = new File(f.uploadedFileName());
            } else if (rawBodyType instanceof RawBodyType.MultipartBody) {
                RawBodyType.MultipartBody multipartBody = (RawBodyType.MultipartBody)rawBodyType;
                Map partTypes = multipartBody.partTypes();
                object = ((TraversableOnce)partTypes.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String partName = (String)tuple2._1();
                    RawBodyType rawBodyType = (RawBodyType)tuple2._2();
                    Part part = Part$.MODULE$.apply(partName, MODULE$.extractPart(partName, rawBodyType, rc), Part$.MODULE$.apply$default$3(), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6());
                    return part;
                }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            } else {
                throw new MatchError(rawBodyType);
            }
        }
        return (B)object;
    }

    private byte[] readBytes(String name, RoutingContext rc, Charset charset) {
        MultiMap formAttributes = rc.request().formAttributes();
        Option formBytes = formAttributes.get(name).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getBytes(charset));
        Option fileBytes = rc.fileUploads().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)VertxInputDecoders$.$anonfun$readBytes$2(name, x$7))).map((Function1 & Serializable & scala.Serializable)upload -> Files.readAllBytes(Paths.get(upload.uploadedFileName(), new String[0])));
        return (byte[])formBytes.orElse((Function0 & Serializable & scala.Serializable)() -> fileBytes).get();
    }

    public static final /* synthetic */ void $anonfun$decodeBodyAndInputsThen$1(Endpoint endpoint$1, Function1 logicHandler$1, RoutingContext rc$1, VertxEndpointOptions endpointOptions$1, Option ect$1, DecodeInputsResult x0$1) {
        DecodeInputsResult decodeInputsResult = x0$1;
        if (decodeInputsResult instanceof DecodeInputsResult.Values) {
            DecodeInputsResult.Values values = (DecodeInputsResult.Values)decodeInputsResult;
            InputValuesResult inputValuesResult = InputValues$.MODULE$.apply(endpoint$1.input(), values);
            if (inputValuesResult instanceof InputValuesResult.Value) {
                InputValuesResult.Value value = (InputValuesResult.Value)inputValuesResult;
                package.Params params = value.params();
                BoxedUnit boxedUnit = (BoxedUnit)logicHandler$1.apply((Object)params);
            } else if (inputValuesResult instanceof InputValuesResult.Failure) {
                InputValuesResult.Failure failure = (InputValuesResult.Failure)inputValuesResult;
                DecodeResult.Failure failure2 = failure.failure();
                package$.MODULE$.tryEncodeError(endpoint$1, rc$1, failure2, endpointOptions$1, ect$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)inputValuesResult);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (decodeInputsResult instanceof DecodeInputsResult.Failure) {
            DecodeInputsResult.Failure failure = (DecodeInputsResult.Failure)decodeInputsResult;
            EndpointInput.Basic input = failure.input();
            DecodeResult.Failure failure3 = failure.failure();
            DecodeFailureContext decodeFailureCtx = new DecodeFailureContext((EndpointInput)input, failure3, endpoint$1);
            DecodeFailureHandling decodeFailureHandling = (DecodeFailureHandling)endpointOptions$1.decodeFailureHandler().apply((Object)decodeFailureCtx);
            if (DecodeFailureHandling.NoMatch$.MODULE$.equals(decodeFailureHandling)) {
                ((Function1)endpointOptions$1.logRequestHandling().decodeFailureNotHandled(endpoint$1, decodeFailureCtx)).apply((Object)endpointOptions$1.logger());
                rc$1.response().setStatusCode(404).end();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (decodeFailureHandling instanceof DecodeFailureHandling.RespondWithResponse) {
                DecodeFailureHandling.RespondWithResponse respondWithResponse = (DecodeFailureHandling.RespondWithResponse)decodeFailureHandling;
                EndpointOutput output = respondWithResponse.output();
                Object value = respondWithResponse.value();
                ((Function1)endpointOptions$1.logRequestHandling().decodeFailureHandled(endpoint$1, decodeFailureCtx, value)).apply((Object)endpointOptions$1.logger());
                BoxedUnit boxedUnit = (BoxedUnit)VertxOutputEncoders$.MODULE$.apply(output, value, VertxOutputEncoders$.MODULE$.apply$default$3(), VertxOutputEncoders$.MODULE$.apply$default$4(), endpointOptions$1).apply((Object)rc$1);
            } else {
                throw new MatchError((Object)decodeFailureHandling);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)decodeInputsResult);
        }
    }

    public static final /* synthetic */ boolean $anonfun$extractPart$1(String name$1, FileUpload x$5) {
        String string = x$5.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$readBytes$2(String name$2, FileUpload x$7) {
        String string = x$7.name();
        String string2 = name$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private VertxInputDecoders$() {
        MODULE$ = this;
    }
}

