/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.akkahttp;

import akka.http.scaladsl.model.BodyPartEntity;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpCharset;
import akka.http.scaladsl.model.HttpCharset$;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.MediaTypes$;
import akka.http.scaladsl.model.Multipart;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.ws.Message;
import akka.stream.Materializer;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.StreamConverters$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import sttp.capabilities.akka.AkkaStreams;
import sttp.capabilities.akka.AkkaStreams$;
import sttp.model.HasHeaders;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.Part;
import sttp.tapir.CodecFormat;
import sttp.tapir.FileRange;
import sttp.tapir.InputStreamRange;
import sttp.tapir.RawBodyType;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.internal.package$;
import sttp.tapir.server.akkahttp.AkkaModel$;
import sttp.tapir.server.akkahttp.AkkaWebSockets$;
import sttp.tapir.server.akkahttp.ContentTypeCache$;
import sttp.tapir.server.interpreter.ToResponseBody;

@ScalaSignature(bytes="\u0006\u0005\t5c!\u0002\u000b\u0016\u0001Ui\u0002\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b1\u0002\u001f\t\u0011\r\u0003!\u0011!Q\u0001\f\u0011CQA\u0013\u0001\u0005\u0002-Cq\u0001\u0015\u0001C\u0002\u0013\u0005\u0013\u000b\u0003\u0004S\u0001\u0001\u0006IA\r\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u0011\u0019A\u0006\u0001)A\u0005+\")\u0011\f\u0001C!5\")A\u0010\u0001C!{\"9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA,\u0001\u0011%\u0011\u0011\f\u0005\b\u0003/\u0003A\u0011BAM\u0011\u001d\t)\f\u0001C\u0005\u0003oCq!a0\u0001\t\u0013\t\t\rC\u0004\u0002L\u0002!I!!4\t\u000f\t%\u0001\u0001\"\u0003\u0003\f!9!\u0011\u0003\u0001\u0005\n\tM\u0001b\u0002B\u0017\u0001\u0011%!q\u0006\u0005\b\u0005s\u0001A\u0011\u0002B\u001e\u0005I\t5n[1U_J+7\u000f]8og\u0016\u0014u\u000eZ=\u000b\u0005Y9\u0012\u0001C1lW\u0006DG\u000f\u001e9\u000b\u0005aI\u0012AB:feZ,'O\u0003\u0002\u001b7\u0005)A/\u00199je*\tA$\u0001\u0003tiR\u00048c\u0001\u0001\u001fIA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\u0004B!\n\u0015+e5\taE\u0003\u0002(/\u0005Y\u0011N\u001c;feB\u0014X\r^3s\u0013\tIcE\u0001\bU_J+7\u000f]8og\u0016\u0014u\u000eZ=\u0011\u0005-zcB\u0001\u0017.\u001b\u0005)\u0012B\u0001\u0018\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001M\u0019\u0003!\u0005[7.\u0019*fgB|gn]3C_\u0012L(B\u0001\u0018\u0016!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0003bW.\f'BA\u001c\u001c\u00031\u0019\u0017\r]1cS2LG/[3t\u0013\tIDGA\u0006BW.\f7\u000b\u001e:fC6\u001c\u0018!A7\u0004\u0001A\u0011Q(Q\u0007\u0002})\u0011q\bQ\u0001\u0007gR\u0014X-Y7\u000b\u0003UJ!A\u0011 \u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u0002\u0005\u0015\u001c\u0007CA#I\u001b\u00051%BA$!\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0013\u001a\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005aEcA'O\u001fB\u0011A\u0006\u0001\u0005\u0006u\r\u0001\u001d\u0001\u0010\u0005\u0006\u0007\u000e\u0001\u001d\u0001R\u0001\bgR\u0014X-Y7t+\u0005\u0011\u0014\u0001C:ue\u0016\fWn\u001d\u0011\u0002\u0013\rCWO\\6TSj,W#A+\u0011\u0005}1\u0016BA,!\u0005\rIe\u000e^\u0001\u000b\u0007\",hn[*ju\u0016\u0004\u0013\u0001\u00044s_6\u0014\u0016m\u001e,bYV,WCA.a)\u0015QC,[9x\u0011\u0015i\u0006\u00021\u0001_\u0003\u00051\bCA0a\u0019\u0001!Q!\u0019\u0005C\u0002\t\u0014\u0011AU\t\u0003G\u001a\u0004\"a\b3\n\u0005\u0015\u0004#a\u0002(pi\"Lgn\u001a\t\u0003?\u001dL!\u0001\u001b\u0011\u0003\u0007\u0005s\u0017\u0010C\u0003k\u0011\u0001\u00071.A\u0004iK\u0006$WM]:\u0011\u00051|W\"A7\u000b\u00059\\\u0012!B7pI\u0016d\u0017B\u00019n\u0005)A\u0015m\u001d%fC\u0012,'o\u001d\u0005\u0006e\"\u0001\ra]\u0001\u0007M>\u0014X.\u0019;\u0011\u0005Q,X\"A\r\n\u0005YL\"aC\"pI\u0016\u001cgi\u001c:nCRDQ\u0001\u001f\u0005A\u0002e\f\u0001BY8esRK\b/\u001a\t\u0004ijt\u0016BA>\u001a\u0005-\u0011\u0016m\u001e\"pIf$\u0016\u0010]3\u0002\u001f\u0019\u0014x.\\*ue\u0016\fWNV1mk\u0016$\u0002B\u000b@\u0002\n\u0005-\u0011Q\u0002\u0005\u0006;&\u0001\ra \t\u0005\u0003\u0003\t)AD\u0002\u0002\u0004\u0011i\u0011\u0001A\u0005\u0004\u0003\u000fA$\u0001\u0004\"j]\u0006\u0014\u0018p\u0015;sK\u0006l\u0007\"\u00026\n\u0001\u0004Y\u0007\"\u0002:\n\u0001\u0004\u0019\bbBA\b\u0013\u0001\u0007\u0011\u0011C\u0001\bG\"\f'o]3u!\u0015y\u00121CA\f\u0013\r\t)\u0002\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005e\u0011QE\u0007\u0003\u00037QA!a\u0004\u0002\u001e)!\u0011qDA\u0011\u0003\rq\u0017n\u001c\u0006\u0003\u0003G\tAA[1wC&!\u0011qEA\u000e\u0005\u001d\u0019\u0005.\u0019:tKR\f\u0011C\u001a:p[^+'mU8dW\u0016$\b+\u001b9f+\u0019\ti#a\u000f\u0002BQ)!&a\f\u0002F!9\u0011\u0011\u0007\u0006A\u0002\u0005M\u0012\u0001\u00029ja\u0016\u0004\u0002\"!\u0001\u00026\u0005e\u0012qH\u0005\u0004\u0003oA$\u0001\u0002)ja\u0016\u00042aXA\u001e\t\u0019\tiD\u0003b\u0001E\n\u0019!+R)\u0011\u0007}\u000b\t\u0005\u0002\u0004\u0002D)\u0011\rA\u0019\u0002\u0005%\u0016\u001b\u0006\u000bC\u0004\u0002H)\u0001\r!!\u0013\u0002\u0003=\u0004D!a\u0013\u0002TAaA/!\u0014\u00024\u0005e\u0012qHA)e%\u0019\u0011qJ\r\u0003']+'mU8dW\u0016$(i\u001c3z\u001fV$\b/\u001e;\u0011\u0007}\u000b\u0019\u0006B\u0006\u0002V\u0005\u0015\u0013\u0011!A\u0001\u0006\u0003\u0011'aA0%c\u0005A\"/Y<WC2,X\rV8SKN\u0004xN\\:f\u000b:$\u0018\u000e^=\u0016\r\u0005m\u0013\u0011SA;))\ti&a\u001c\u0002x\u0005\u0005\u0015Q\u0012\t\u0005\u0003?\nY'\u0004\u0002\u0002b)\u0019a.a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\tg\u000e\fG.\u00193tY*\u0019\u0011\u0011\u000e!\u0002\t!$H\u000f]\u0005\u0005\u0003[\n\tG\u0001\bSKN\u0004xN\\:f\u000b:$\u0018\u000e^=\t\ra\\\u0001\u0019AA9!\u0011!(0a\u001d\u0011\u0007}\u000b)\bB\u0003b\u0017\t\u0007!\rC\u0004\u0002z-\u0001\r!a\u001f\u0002\u0005\r$\b\u0003BA0\u0003{JA!a \u0002b\tY1i\u001c8uK:$H+\u001f9f\u0011\u001d\t\u0019i\u0003a\u0001\u0003\u000b\u000bQbY8oi\u0016tG\u000fT3oORD\u0007#B\u0010\u0002\u0014\u0005\u001d\u0005cA\u0010\u0002\n&\u0019\u00111\u0012\u0011\u0003\t1{gn\u001a\u0005\b\u0003\u001f[\u0001\u0019AA:\u0003\u0005\u0011HaBAJ\u0017\t\u0007\u0011Q\u0013\u0002\u0003\u0007\u001a\u000b\"aY:\u0002!\r\u0014X-\u0019;f\r&dWmU8ve\u000e,G\u0003CAN\u0003G\u000bi+!-\u0011\t\u0005u\u0015Q\u0001\b\u0004g\u0005}\u0015bAAQi\u0005Y\u0011i[6b'R\u0014X-Y7t\u0011\u001d\t)\u000b\u0004a\u0001\u0003O\u000b\u0011\u0002^1qSJ4\u0015\u000e\\3\u0011\u0007Q\fI+C\u0002\u0002,f\u0011\u0011BR5mKJ\u000bgnZ3\t\u000f\u0005=F\u00021\u0001\u0002\b\u0006)1\u000f^1si\"9\u00111\u0017\u0007A\u0002\u0005\u001d\u0015A\u00032zi\u0016\u001cHk\u001c;bY\u0006qAo\u001c*b]\u001e,Gm\u0015;sK\u0006lGCBAN\u0003s\u000bi\fC\u0004\u0002<6\u0001\r!a'\u0002\u001b%t\u0017\u000e^5bYN#(/Z1n\u0011\u001d\t\u0019,\u0004a\u0001\u0003\u000f\u000bab\u001d;sK\u0006lGk\\#oi&$\u0018\u0010\u0006\u0005\u0002^\u0005\r\u0017qYAe\u0011\u001d\t)M\u0004a\u0001\u0003w\n1bY8oi\u0016tG\u000fV=qK\"9\u00111\u0011\bA\u0002\u0005\u0015\u0005BB \u000f\u0001\u0004\tY*A\tsC^\u0004\u0016M\u001d;U_\n{G-\u001f)beR,B!a4\u0003\u0006Q1\u0011\u0011[Au\u0003s\u0004RaHA\n\u0003'\u0004B!!6\u0002d:!\u0011q[Ao\u001d\u0011\ty&!7\n\t\u0005m\u0017\u0011M\u0001\n\u001bVdG/\u001b9beRLA!a8\u0002b\u0006Aai\u001c:n\t\u0006$\u0018M\u0003\u0003\u0002\\\u0006\u0005\u0014\u0002BAs\u0003O\u0014\u0001BQ8esB\u000b'\u000f\u001e\u0006\u0005\u0003?\f\t\u000f\u0003\u0004;\u001f\u0001\u0007\u00111\u001e\t\u0005\u0003[\f\u0019PD\u0002u\u0003_L1!!=\u001a\u0003-\u0011\u0016m\u001e\"pIf$\u0016\u0010]3\n\t\u0005U\u0018q\u001f\u0002\u000e\u001bVdG/\u001b9beR\u0014u\u000eZ=\u000b\u0007\u0005E\u0018\u0004C\u0004\u0002|>\u0001\r!!@\u0002\tA\f'\u000f\u001e\t\u0006Y\u0006}(1A\u0005\u0004\u0005\u0003i'\u0001\u0002)beR\u00042a\u0018B\u0003\t\u0019\u00119a\u0004b\u0001E\n\tA+A\ng_Jl\u0017\r\u001e+p\u0007>tG/\u001a8u)f\u0004X\r\u0006\u0004\u0002|\t5!q\u0002\u0005\u0006eB\u0001\ra\u001d\u0005\b\u0003\u001f\u0001\u0002\u0019AA\t\u0003A\u0001\u0018M]:f\u0007>tG/\u001a8u)f\u0004X\r\u0006\u0003\u0002|\tU\u0001bBA=#\u0001\u0007!q\u0003\t\u0005\u00053\u00119C\u0004\u0003\u0003\u001c\t\r\u0002c\u0001B\u000fA5\u0011!q\u0004\u0006\u0004\u0005CY\u0014A\u0002\u001fs_>$h(C\u0002\u0003&\u0001\na\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u0015\u0005W\u0011aa\u0015;sS:<'b\u0001B\u0013A\u0005!2\r[1sg\u0016$Hk\u001c%uiB\u001c\u0005.\u0019:tKR$BA!\r\u00038A!\u0011q\fB\u001a\u0013\u0011\u0011)$!\u0019\u0003\u0017!#H\u000f]\"iCJ\u001cX\r\u001e\u0005\b\u0003\u001f\u0011\u0002\u0019AA\f\u0003qyg/\u001a:sS\u0012,7i\u001c8uK:$H+\u001f9f\u0013\u001a$UMZ5oK\u0012,BA!\u0010\u0003BQ1!q\bB$\u0005\u0017\u00022a\u0018B!\t\u001d\u0011\u0019e\u0005b\u0001\u0005\u000b\u0012!AU#\u0012\u0007\r\fi\u0006C\u0004\u0003JM\u0001\rAa\u0010\u0002\u0005I,\u0007\"\u00026\u0014\u0001\u0004Y\u0007")
public class AkkaToResponseBody
implements ToResponseBody<Either<Flow<Message, Message, Object>, ResponseEntity>, AkkaStreams> {
    private final Materializer m;
    private final ExecutionContext ec;
    private final AkkaStreams streams;
    private final int ChunkSize;

    public AkkaStreams streams() {
        return this.streams;
    }

    private int ChunkSize() {
        return this.ChunkSize;
    }

    public <R> Either<Flow<Message, Message, Object>, ResponseEntity> fromRawValue(R v, HasHeaders headers, CodecFormat format, RawBodyType<R> bodyType) {
        return new Right((Object)this.overrideContentTypeIfDefined(this.rawValueToResponseEntity(bodyType, this.formatToContentType(format, (Option<Charset>)package$.MODULE$.charset(bodyType)), (Option<Object>)headers.contentLength(), v), headers));
    }

    public Either<Flow<Message, Message, Object>, ResponseEntity> fromStreamValue(Source<ByteString, Object> v, HasHeaders headers, CodecFormat format, Option<Charset> charset) {
        return new Right((Object)this.overrideContentTypeIfDefined(this.streamToEntity(this.formatToContentType(format, charset), (Option<Object>)headers.contentLength(), v), headers));
    }

    public <REQ, RESP> Either<Flow<Message, Message, Object>, ResponseEntity> fromWebSocketPipe(Flow<REQ, RESP, Object> pipe, WebSocketBodyOutput<Flow<REQ, RESP, Object>, REQ, RESP, ?, AkkaStreams> o) {
        return new Left(AkkaWebSockets$.MODULE$.pipeToBody(pipe, o, this.ec, this.m));
    }

    private <CF extends CodecFormat, R> ResponseEntity rawValueToResponseEntity(RawBodyType<R> bodyType, ContentType ct, Option<Object> contentLength, R r2) {
        RawBodyType<R> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            RawBodyType.StringBody stringBody = (RawBodyType.StringBody)rawBodyType;
            Charset charset = stringBody.charset();
            ContentType contentType = ct;
            if (contentType instanceof ContentType.NonBinary) {
                ContentType.NonBinary nonBinary = (ContentType.NonBinary)contentType;
                return HttpEntity$.MODULE$.apply(nonBinary, (String)r2);
            }
            return HttpEntity$.MODULE$.apply(ct, ((String)r2).getBytes(charset));
        }
        if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            return HttpEntity$.MODULE$.apply(ct, (byte[])r2);
        }
        if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            return HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply((ByteBuffer)r2));
        }
        if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            return this.streamToEntity(ct, contentLength, (Source<ByteString, Object>)StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> r2, this.ChunkSize()));
        }
        if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            Object resource = r2;
            Source initialStream = StreamConverters$.MODULE$.fromInputStream(((InputStreamRange)resource).inputStreamFromRangeStart(), this.ChunkSize());
            return (ResponseEntity)((InputStreamRange)resource).range().map((Function1 & Serializable)r -> this.streamToEntity(ct, contentLength, this.toRangedStream((Source<ByteString, Object>)initialStream, r.contentLength()))).getOrElse((Function0 & Serializable)() -> this.streamToEntity(ct, contentLength, (Source<ByteString, Object>)initialStream));
        }
        if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            Object tapirFile = r2;
            return (ResponseEntity)((FileRange)tapirFile).range().flatMap((Function1 & Serializable)r -> r.startAndEnd().map((Function1 & Serializable)s -> HttpEntity$.MODULE$.apply(ct, this.createFileSource((FileRange)tapirFile, s._1$mcJ$sp(), r.contentLength())))).getOrElse((Function0 & Serializable)() -> HttpEntity$.MODULE$.fromPath(ct, ((FileRange)tapirFile).file().toPath(), HttpEntity$.MODULE$.fromPath$default$3()));
        }
        if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody multipartBody = (RawBodyType.MultipartBody)rawBodyType;
            Seq parts = (Seq)((Seq)r2).flatMap((Function1 & Serializable)x$1 -> this.rawPartToBodyPart(multipartBody, (Part)x$1));
            Multipart.FormData body = Multipart.FormData$.MODULE$.apply(parts);
            return body.toEntity();
        }
        throw new MatchError(rawBodyType);
    }

    private Source<ByteString, Object> createFileSource(FileRange tapirFile, long start, long bytesTotal) {
        return this.toRangedStream((Source<ByteString, Object>)FileIO$.MODULE$.fromPath(tapirFile.file().toPath(), this.ChunkSize(), start), bytesTotal);
    }

    private Source<ByteString, Object> toRangedStream(Source<ByteString, Object> initialStream, long bytesTotal) {
        return (Source)initialStream.scan((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)ByteString$.MODULE$.empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                ByteString next = (ByteString)tuple2._2();
                if (tuple22 != null) {
                    long bytesConsumed = tuple22._1$mcJ$sp();
                    int bytesInNext = next.length();
                    long bytesFromNext = Math.max(0L, Math.min(bytesTotal - bytesConsumed, (long)bytesInNext));
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)(bytesConsumed + (long)bytesInNext)), (Object)next.take((int)bytesFromNext));
                }
            }
            throw new MatchError((Object)tuple2);
        }).takeWhile((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AkkaToResponseBody.$anonfun$toRangedStream$2(bytesTotal, x$2)), true).map((Function1 & Serializable)x$3 -> (ByteString)x$3._2());
    }

    private ResponseEntity streamToEntity(ContentType contentType, Option<Object> contentLength, Source<ByteString, Object> stream) {
        Option<Object> option = contentLength;
        if (None$.MODULE$.equals(option)) {
            return HttpEntity$.MODULE$.apply(contentType, stream);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long l = BoxesRunTime.unboxToLong((Object)some.value());
            return HttpEntity$.MODULE$.apply(contentType, l, stream);
        }
        throw new MatchError(option);
    }

    private <T> Option<Multipart.FormData.BodyPart> rawPartToBodyPart(RawBodyType.MultipartBody m, Part<T> part) {
        return m.partType(part.name()).map((Function1 & Serializable)partType -> {
            Option partContentLength;
            ContentType partContentType = (ContentType)part.contentType().map((Function1 & Serializable)ct -> this.parseContentType((String)ct)).getOrElse((Function0 & Serializable)() -> ContentTypes$.MODULE$.application$divoctet$minusstream());
            ResponseEntity responseEntity = this.rawValueToResponseEntity((RawBodyType)partType, partContentType, (Option<Object>)(partContentLength = part.header(HeaderNames$.MODULE$.ContentLength()).flatMap((Function1 & Serializable)v -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(v))).toOption())), (Object)part.body());
            if (!(responseEntity instanceof BodyPartEntity)) {
                throw new IllegalArgumentException(new StringBuilder(37).append(partType).append(" is not supported in multipart bodies").toString());
            }
            ResponseEntity responseEntity2 = responseEntity;
            ResponseEntity body = this.overrideContentTypeIfDefined(responseEntity2, (HasHeaders)part);
            return Multipart.FormData$.BodyPart$.MODULE$.apply(part.name(), (BodyPartEntity)body, part.otherDispositionParams(), (Seq)AkkaModel$.MODULE$.parseHeadersOrThrowWithoutContentHeaders((HasHeaders)part).toList());
        });
    }

    private ContentType formatToContentType(CodecFormat format, Option<Charset> charset) {
        CodecFormat codecFormat = format;
        if (codecFormat instanceof CodecFormat.Json) {
            return ContentTypes$.MODULE$.application$divjson();
        }
        if (codecFormat instanceof CodecFormat.TextPlain) {
            return MediaTypes$.MODULE$.text$divplain().withCharset(this.charsetToHttpCharset((Charset)charset.getOrElse((Function0 & Serializable)() -> StandardCharsets.UTF_8)));
        }
        if (codecFormat instanceof CodecFormat.TextHtml) {
            return MediaTypes$.MODULE$.text$divhtml().withCharset(this.charsetToHttpCharset((Charset)charset.getOrElse((Function0 & Serializable)() -> StandardCharsets.UTF_8)));
        }
        if (codecFormat instanceof CodecFormat.OctetStream) {
            return ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divoctet$minusstream());
        }
        if (codecFormat instanceof CodecFormat.Zip) {
            return ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divzip());
        }
        if (codecFormat instanceof CodecFormat.XWwwFormUrlencoded) {
            return ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divx$minuswww$minusform$minusurlencoded());
        }
        if (codecFormat instanceof CodecFormat.MultipartFormData) {
            return ContentType$.MODULE$.apply((MediaType.Binary)MediaTypes$.MODULE$.multipart$divform$minusdata());
        }
        MediaType mt = codecFormat.mediaType().isText() ? (MediaType)charset.fold((Function0 & Serializable)() -> codecFormat.mediaType(), (Function1 & Serializable)x$4 -> codecFormat.mediaType().charset(x$4)) : codecFormat.mediaType();
        return this.parseContentType(mt.toString());
    }

    private ContentType parseContentType(String ct) {
        return ContentTypeCache$.MODULE$.getOrParse(ct);
    }

    private HttpCharset charsetToHttpCharset(Charset charset) {
        return HttpCharset$.MODULE$.custom(charset.name(), (Seq)Nil$.MODULE$);
    }

    private <RE extends ResponseEntity> RE overrideContentTypeIfDefined(RE re, HasHeaders headers) {
        Option option = headers.contentType();
        if (option instanceof Some) {
            Some some = (Some)option;
            String ct = (String)some.value();
            return (RE)re.withContentType(this.parseContentType(ct));
        }
        if (None$.MODULE$.equals(option)) {
            return re;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$toRangedStream$2(long bytesTotal$1, Tuple2 x$2) {
        return x$2._1$mcJ$sp() < bytesTotal$1;
    }

    public AkkaToResponseBody(Materializer m, ExecutionContext ec) {
        this.m = m;
        this.ec = ec;
        this.streams = AkkaStreams$.MODULE$;
        this.ChunkSize = 8192;
    }
}

