/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.akkahttp;

import akka.http.scaladsl.model.EntityStreamSizeException;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.Multipart;
import akka.http.scaladsl.model.ParsingException;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.unmarshalling.Unmarshaller;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.StreamConverters$;
import akka.util.ByteString;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import sttp.capabilities.akka.AkkaStreams;
import sttp.capabilities.akka.AkkaStreams$;
import sttp.model.Header$;
import sttp.model.Part;
import sttp.tapir.FileRange;
import sttp.tapir.FileRange$;
import sttp.tapir.InputStreamRange;
import sttp.tapir.InputStreamRange$;
import sttp.tapir.RawBodyType;
import sttp.tapir.model.ServerRequest;
import sttp.tapir.server.akkahttp.AkkaHttpServerOptions;
import sttp.tapir.server.interpreter.RawValue;
import sttp.tapir.server.interpreter.RawValue$;
import sttp.tapir.server.interpreter.RequestBody;
import sttp.tapir.server.model.InvalidMultipartBodyException$;

@ScalaSignature(bytes="\u0006\u0005\u0005%d!\u0002\u0007\u000e\u00015)\u0002\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011Y\u0002!\u0011!Q\u0001\f]B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ya\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0011K\u0011\u0019Y\u0005\u0001)A\u0005Q!)A\n\u0001C!\u001b\")A\u000f\u0001C!k\")Q\u0010\u0001C\u0005}\"9\u0011Q\u0003\u0001\u0005\n\u0005]\u0001bBA\u001a\u0001\u0011%\u0011Q\u0007\u0002\u0010\u0003.\\\u0017MU3rk\u0016\u001cHOQ8es*\u0011abD\u0001\tC.\\\u0017\r\u001b;ua*\u0011\u0001#E\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005I\u0019\u0012!\u0002;ba&\u0014(\"\u0001\u000b\u0002\tM$H\u000f]\n\u0004\u0001Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0003\u001eA\tBS\"\u0001\u0010\u000b\u0005}y\u0011aC5oi\u0016\u0014\bO]3uKJL!!\t\u0010\u0003\u0017I+\u0017/^3ti\n{G-\u001f\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003Ka\t!bY8oGV\u0014(/\u001a8u\u0013\t9CE\u0001\u0004GkR,(/\u001a\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nA!Y6lC*\u0011QfE\u0001\rG\u0006\u0004\u0018MY5mSRLWm]\u0005\u0003_)\u00121\"Q6lCN#(/Z1ng\u0006i1/\u001a:wKJ|\u0005\u000f^5p]N\u001c\u0001\u0001\u0005\u00024i5\tQ\"\u0003\u00026\u001b\t)\u0012i[6b\u0011R$\boU3sm\u0016\u0014x\n\u001d;j_:\u001c\u0018aA7biB\u0011\u0001\bP\u0007\u0002s)\u0011!hO\u0001\u0007gR\u0014X-Y7\u000b\u0003-J!!P\u001d\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u0002\u0005\u0015\u001c\u0007CA\u0012A\u0013\t\tEE\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\"\u0001\u0012%\u0015\u0007\u00153u\t\u0005\u00024\u0001!)a\u0007\u0002a\u0002o!)a\b\u0002a\u0002\u007f!)\u0001\u0007\u0002a\u0001e\u000591\u000f\u001e:fC6\u001cX#\u0001\u0015\u0002\u0011M$(/Z1ng\u0002\nQ\u0001^8SC^,\"AT+\u0015\t=sf\r\u001c\t\u0004G\u0019\u0002\u0006cA\u000fR'&\u0011!K\b\u0002\t%\u0006<h+\u00197vKB\u0011A+\u0016\u0007\u0001\t\u00151vA1\u0001X\u0005\u0005\u0011\u0016C\u0001-\\!\t9\u0012,\u0003\u0002[1\t9aj\u001c;iS:<\u0007CA\f]\u0013\ti\u0006DA\u0002B]fDQaX\u0004A\u0002\u0001\fqA]3rk\u0016\u001cH\u000f\u0005\u0002bI6\t!M\u0003\u0002d#\u0005)Qn\u001c3fY&\u0011QM\u0019\u0002\u000e'\u0016\u0014h/\u001a:SKF,Xm\u001d;\t\u000b\u001d<\u0001\u0019\u00015\u0002\u0011\t|G-\u001f+za\u0016\u00042!\u001b6T\u001b\u0005\t\u0012BA6\u0012\u0005-\u0011\u0016m\u001e\"pIf$\u0016\u0010]3\t\u000b5<\u0001\u0019\u00018\u0002\u00115\f\u0007PQ=uKN\u00042aF8r\u0013\t\u0001\bD\u0001\u0004PaRLwN\u001c\t\u0003/IL!a\u001d\r\u0003\t1{gnZ\u0001\ti>\u001cFO]3b[R\u0019ao\u001f?\u0011\u0005]LhB\u0001=\u0006\u001b\u0005\u0001\u0011B\u0001>/\u00051\u0011\u0015N\\1ssN#(/Z1n\u0011\u0015y\u0006\u00021\u0001a\u0011\u0015i\u0007\u00021\u0001o\u00035\u0011X-];fgR,e\u000e^5usR)q0!\u0005\u0002\u0014A!\u0011\u0011AA\u0007\u001b\t\t\u0019AC\u0002d\u0003\u000bQA!a\u0002\u0002\n\u0005A1oY1mC\u0012\u001cHNC\u0002\u0002\fm\nA\u0001\u001b;ua&!\u0011qBA\u0002\u00055\u0011V-];fgR,e\u000e^5us\")q,\u0003a\u0001A\")Q.\u0003a\u0001]\u0006yAo\u001c*bo\u001a\u0013x.\\#oi&$\u00180\u0006\u0003\u0002\u001a\u0005\u0005B\u0003CA\u000e\u0003G\t)#a\f\u0011\t\r2\u0013Q\u0004\t\u0005;E\u000by\u0002E\u0002U\u0003C!QA\u0016\u0006C\u0002]CQa\u0018\u0006A\u0002\u0001Dq!a\n\u000b\u0001\u0004\tI#\u0001\u0003c_\u0012L\b\u0003BA\u0001\u0003WIA!!\f\u0002\u0004\tQ\u0001\n\u001e;q\u000b:$\u0018\u000e^=\t\r\u001dT\u0001\u0019AA\u0019!\u0011I'.a\b\u0002\u0013Q|'+Y<QCJ$X\u0003BA\u001c\u0003\u000f\"\u0002\"!\u000f\u0002J\u0005-\u0013Q\r\t\u0005G\u0019\nY\u0004\u0005\u0004\u0002>\u0005\u0005\u0013QI\u0007\u0003\u0003\u007fQ!aY\n\n\t\u0005\r\u0013q\b\u0002\u0005!\u0006\u0014H\u000fE\u0002U\u0003\u000f\"QAV\u0006C\u0002]CQaX\u0006A\u0002\u0001Dq!!\u0014\f\u0001\u0004\ty%\u0001\u0003qCJ$\b\u0003BA)\u0003?rA!a\u0015\u0002Z9!\u0011\u0011AA+\u0013\u0011\t9&a\u0001\u0002\u00135+H\u000e^5qCJ$\u0018\u0002BA.\u0003;\n\u0001BR8s[\u0012\u000bG/\u0019\u0006\u0005\u0003/\n\u0019!\u0003\u0003\u0002b\u0005\r$\u0001\u0003\"pIf\u0004\u0016M\u001d;\u000b\t\u0005m\u0013Q\f\u0005\u0007O.\u0001\r!a\u001a\u0011\t%T\u0017Q\t")
public class AkkaRequestBody
implements RequestBody<Future, AkkaStreams> {
    private final AkkaHttpServerOptions serverOptions;
    private final Materializer mat;
    private final ExecutionContext ec;
    private final AkkaStreams streams;

    public AkkaStreams streams() {
        return this.streams;
    }

    public <R> Future<RawValue<R>> toRaw(ServerRequest request, RawBodyType<R> bodyType, Option<Object> maxBytes) {
        return this.toRawFromEntity(request, (HttpEntity)this.requestEntity(request, maxBytes), bodyType);
    }

    public Source<ByteString, Object> toStream(ServerRequest request, Option<Object> maxBytes) {
        return this.requestEntity(request, maxBytes).dataBytes();
    }

    private RequestEntity requestEntity(ServerRequest request, Option<Object> maxBytes2) {
        RequestEntity entity = ((RequestContext)request.underlying()).request().entity();
        return (RequestEntity)maxBytes2.map((Function1 & Serializable)maxBytes -> entity.withSizeLimit(BoxesRunTime.unboxToLong((Object)maxBytes))).getOrElse((Function0 & Serializable)() -> entity);
    }

    private <R> Future<RawValue<R>> toRawFromEntity(ServerRequest request, HttpEntity body, RawBodyType<R> bodyType) {
        RawBodyType<R> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            return ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.stringUnmarshaller())).apply((Object)body, this.ec, this.mat).map((Function1 & Serializable)x$1 -> new RawValue(x$1, RawValue$.MODULE$.apply$default$2(), RawValue$.MODULE$.apply$default$3()), this.ec);
        }
        if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            return ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.byteArrayUnmarshaller())).apply((Object)body, this.ec, this.mat).map((Function1 & Serializable)x$2 -> new RawValue(x$2, RawValue$.MODULE$.apply$default$2(), RawValue$.MODULE$.apply$default$3()), this.ec);
        }
        if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            return ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.byteStringUnmarshaller())).apply((Object)body, this.ec, this.mat).map((Function1 & Serializable)b -> new RawValue((Object)b.asByteBuffer(), RawValue$.MODULE$.apply$default$2(), RawValue$.MODULE$.apply$default$3()), this.ec);
        }
        if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            return Future$.MODULE$.successful((Object)new RawValue(body.dataBytes().runWith((Graph)StreamConverters$.MODULE$.asInputStream(StreamConverters$.MODULE$.asInputStream$default$1()), this.mat), RawValue$.MODULE$.apply$default$2(), RawValue$.MODULE$.apply$default$3()));
        }
        if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            return ((Future)this.serverOptions.createFile().apply((Object)request)).flatMap((Function1 & Serializable)file -> ((Future)body.dataBytes().runWith((Graph)FileIO$.MODULE$.toPath(file.toPath(), FileIO$.MODULE$.toPath$default$2()), $this.mat)).recoverWith((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Exception exception;
                    A1 A1 = x1;
                    if (A1 instanceof Exception && (exception = (Exception)A1).getCause() instanceof EntityStreamSizeException) {
                        return (B1)Future$.MODULE$.failed(exception.getCause());
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Exception exception;
                    Throwable throwable = x1;
                    return throwable instanceof Exception && (exception = (Exception)throwable).getCause() instanceof EntityStreamSizeException;
                }
            }, $this.ec).map((Function1 & Serializable)x$3 -> new FileRange(file, FileRange$.MODULE$.apply$default$2()), $this.ec).map((Function1 & Serializable)f -> new RawValue(f, (Seq)new .colon.colon(f, (List)Nil$.MODULE$), RawValue$.MODULE$.apply$default$3()), $this.ec), this.ec);
        }
        if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            return Future$.MODULE$.successful((Object)new RawValue((Object)new InputStreamRange((Function0 & Serializable)() -> (InputStream)body.dataBytes().runWith((Graph)StreamConverters$.MODULE$.asInputStream(StreamConverters$.MODULE$.asInputStream$default$1()), $this.mat), InputStreamRange$.MODULE$.apply$default$2()), RawValue$.MODULE$.apply$default$2(), RawValue$.MODULE$.apply$default$3()));
        }
        if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody multipartBody = (RawBodyType.MultipartBody)rawBodyType;
            return ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.multipartFormDataUnmarshaller(Unmarshaller$.MODULE$.multipartFormDataUnmarshaller$default$1(), Unmarshaller$.MODULE$.multipartFormDataUnmarshaller$default$2()))).apply((Object)body, this.ec, this.mat).flatMap((Function1 & Serializable)fd -> ((Future)((Source)fd.parts().mapConcat((Function1 & Serializable)part -> multipartBody.partType(part.name()).map((Function1 & Serializable)x$4 -> new Tuple2(part, x$4)).toList()).mapAsync(1, (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Multipart.FormData.BodyPart part = (Multipart.FormData.BodyPart)tuple2._1();
                    RawBodyType codecMeta = (RawBodyType)tuple2._2();
                    return this.toRawPart(request, part, codecMeta);
                }
                throw new MatchError((Object)tuple2);
            })).runWith((Graph)Sink$.MODULE$.seq(), $this.mat)).map((Function1 & Serializable)parts -> RawValue$.MODULE$.fromParts(parts), $this.ec), this.ec).recoverWith((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof ParsingException) {
                        ParsingException parsingException = (ParsingException)A1;
                        return (B1)Future$.MODULE$.failed((Throwable)InvalidMultipartBodyException$.MODULE$.apply((Throwable)parsingException));
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    return throwable instanceof ParsingException;
                }
            }, this.ec);
        }
        throw new MatchError(rawBodyType);
    }

    private <R> Future<Part<R>> toRawPart(ServerRequest request, Multipart.FormData.BodyPart part, RawBodyType<R> bodyType) {
        return this.toRawFromEntity(request, (HttpEntity)part.entity(), bodyType).map((Function1 & Serializable)r -> new Part(part.name(), r.value(), part.additionalDispositionParams(), (Seq)part.additionalHeaders().map((Function1 & Serializable)h -> Header$.MODULE$.apply(h.name(), h.value()))).contentType(part.entity().contentType().toString()), this.ec);
    }

    public AkkaRequestBody(AkkaHttpServerOptions serverOptions, Materializer mat, ExecutionContext ec) {
        this.serverOptions = serverOptions;
        this.mat = mat;
        this.ec = ec;
        this.streams = AkkaStreams$.MODULE$;
    }
}

