/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.servlet.ssm;

import com.softwarementors.extjs.djn.api.RegisteredMethod;
import com.softwarementors.extjs.djn.router.dispatcher.DispatcherBase;
import com.softwarementors.extjs.djn.servlet.ssm.ActionScope;
import com.softwarementors.extjs.djn.servlet.ssm.Scope;
import com.softwarementors.extjs.djn.servlet.ssm.WebContext;
import com.softwarementors.extjs.djn.servlet.ssm.WebContextManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class SsmDispatcher
extends DispatcherBase {
    @NonNull
    private static final Map<Class<?>, Scope> methodScopeCache = new HashMap();
    @NonNull
    private static final Logger logger = Logger.getLogger(SsmDispatcher.class);

    protected Object getInvokeInstanceForNonStaticMethod(RegisteredMethod method) throws Exception {
        assert (method != null);
        Class<?> instanceClass = method.getActionClass();
        Scope scope = methodScopeCache.get(instanceClass);
        if (scope == null) {
            ActionScope methodScope = instanceClass.getAnnotation(ActionScope.class);
            scope = methodScope == null ? Scope.STATELESS : methodScope.scope();
            methodScopeCache.put(instanceClass, scope);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Action class '" + instanceClass + "' will be instantiated with " + scope.toString() + "' scope."));
            }
        }
        assert (scope != null);
        Object result = this.getAction(method, scope);
        return result;
    }

    @SuppressWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="Missing a 'default' branch is not a problem with enums, given the appropriate compiler settings")
    private Object getAction(RegisteredMethod method, Scope scope) throws Exception {
        Object result = null;
        switch (scope) {
            case SESSION: {
                result = this.getSessionMethodInstance(method);
                break;
            }
            case APPLICATION: {
                result = this.getApplicationMethodInstance(method);
                break;
            }
            case STATELESS: {
                result = this.getStatelessMethodInstance(method);
            }
        }
        assert (result != null);
        return result;
    }

    private Object getStatelessMethodInstance(RegisteredMethod method) throws Exception {
        assert (method != null);
        return this.createInvokeInstanceForMethodWithDefaultConstructor(method);
    }

    private synchronized Object getSessionMethodInstance(RegisteredMethod method) throws Exception {
        assert (method != null);
        HttpSession context = WebContextManager.get().getSession();
        Object result = WebContextManager.get().getSessionScopedObject(method.getActionName());
        if (result == null) {
            String key = WebContext.getSessionScopedActionName(method.getActionName());
            result = this.createInvokeInstanceForMethodWithDefaultConstructor(method);
            context.setAttribute(key, result);
        }
        return result;
    }

    private synchronized Object getApplicationMethodInstance(RegisteredMethod method) throws Exception {
        assert (method != null);
        ServletContext context = WebContextManager.get().getServletContext();
        Object result = WebContextManager.get().getApplicationScopedObject(method.getActionName());
        if (result == null) {
            result = this.createInvokeInstanceForMethodWithDefaultConstructor(method);
            String key = WebContext.getApplicationScopedActionName(method.getActionName());
            context.setAttribute(key, result);
        }
        return result;
    }
}

