/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.router.processor.poll;

import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.api.RegisteredMethod;
import com.softwarementors.extjs.djn.api.RegisteredPollMethod;
import com.softwarementors.extjs.djn.api.Registry;
import com.softwarementors.extjs.djn.config.GlobalConfiguration;
import com.softwarementors.extjs.djn.router.dispatcher.Dispatcher;
import com.softwarementors.extjs.djn.router.processor.RequestException;
import com.softwarementors.extjs.djn.router.processor.RequestProcessorBase;
import com.softwarementors.extjs.djn.router.processor.RequestProcessorUtils;
import com.softwarementors.extjs.djn.router.processor.ResponseData;
import com.softwarementors.extjs.djn.router.processor.poll.PollErrorResponseData;
import com.softwarementors.extjs.djn.router.processor.poll.PollSuccessResponseData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class PollRequestProcessor
extends RequestProcessorBase {
    @NonNull
    private static Logger logger = Logger.getLogger(PollRequestProcessor.class);
    public static final String PATHINFO_POLL_PREFIX = "/poll/";
    private String eventName;
    private String requestString;
    private String resultString;

    public PollRequestProcessor(Registry registry, Dispatcher dispatcher, GlobalConfiguration globalConfiguration) {
        super(registry, dispatcher, globalConfiguration);
    }

    private static String getEventName(String pathInfo) {
        assert (!StringUtils.isEmpty(pathInfo));
        return pathInfo.replace(PATHINFO_POLL_PREFIX, "");
    }

    protected Logger getLogger() {
        return logger;
    }

    protected void logRequestEnterInfo() {
        this.getLogger().debug((Object)("Request data (POLL)=>" + this.requestString + " Event name='" + this.eventName + "'"));
    }

    protected void logRequestExitInfo(Logger logger) {
        logger.debug((Object)("ResponseData data (POLL)=>" + this.resultString));
    }

    protected RegisteredMethod getMethod() {
        RegisteredPollMethod method = this.getRegistry().getPollMethod(this.eventName);
        if (method == null) {
            RequestException ex = RequestException.forPollEventNotFound(this.eventName);
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return method;
    }

    protected Object[] getParameters() {
        return new Object[]{RequestProcessorUtils.getDecodedRequestParameters(this.requestString)};
    }

    protected ResponseData createSuccessResponse(Object result) {
        PollSuccessResponseData r = new PollSuccessResponseData(this.eventName);
        r.setResult(result);
        return r;
    }

    protected ResponseData createErrorResponse(Throwable exception, boolean debugOn) {
        PollErrorResponseData result = new PollErrorResponseData(exception, debugOn);
        return result;
    }

    protected void logErrorResponse(Exception t) {
        assert (t != null);
        this.getLogger().error((Object)("(Controlled) server error: " + t.getMessage() + " for Poll Event '" + this.eventName + "'"), (Throwable)t);
    }

    private void logEnterInfo() {
        if (this.getLogger().isDebugEnabled()) {
            this.logRequestEnterInfo();
        }
    }

    private void logExitInfo() {
        if (this.getLogger().isDebugEnabled()) {
            this.logRequestExitInfo(logger);
        }
    }

    public void process(Reader reader, Writer writer, String pathInfo) throws IOException {
        ResponseData response;
        assert (!StringUtils.isEmpty(pathInfo));
        this.requestString = IOUtils.toString((Reader)reader);
        this.eventName = PollRequestProcessor.getEventName(pathInfo);
        this.logEnterInfo();
        try {
            RegisteredMethod method = this.getMethod();
            Object[] parameters = this.getParameters();
            Object result = this.getDispatcher().dispatch(method, parameters);
            response = this.createSuccessResponse(result);
        }
        catch (Exception t) {
            response = this.createErrorResponse(t, this.getDebug());
            this.logErrorResponse(t);
        }
        StringBuilder result = new StringBuilder();
        this.appendIndividualResponseJsonString(response, result);
        this.resultString = result.toString();
        writer.write(this.resultString);
        this.logExitInfo();
    }
}

