/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.router.processor;

import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.UnexpectedException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestProcessorUtils {
    public static Map<String, String> getDecodedRequestParameters(String requestString) {
        assert (requestString != null);
        HashMap<String, String> result = new HashMap<String, String>();
        if (!requestString.equals("")) {
            String[] entries;
            for (String entry : entries = requestString.split("&")) {
                String[] keyValue = entry.split("=");
                assert (keyValue.length >= 1 && keyValue.length <= 2);
                String key = keyValue[0];
                assert (!StringUtils.isEmpty(key));
                String value = "";
                if (keyValue.length == 2) {
                    value = keyValue[1];
                }
                try {
                    key = URLDecoder.decode(key, "UTF-8");
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    UnexpectedException.forExpectingUTF8UrlEncodingIsAlwaysSupportedByURLEncoder(e);
                }
                result.put(key, value);
            }
        }
        return result;
    }
}

