/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.router.processor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.softwarementors.extjs.djn.api.Registry;
import com.softwarementors.extjs.djn.config.GlobalConfiguration;
import com.softwarementors.extjs.djn.gson.GsonBuilderConfigurator;
import com.softwarementors.extjs.djn.gson.GsonBuilderConfiguratorException;
import com.softwarementors.extjs.djn.gson.JsonException;
import com.softwarementors.extjs.djn.router.dispatcher.Dispatcher;
import com.softwarementors.extjs.djn.router.processor.ResponseData;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.log4j.Logger;

public abstract class RequestProcessorBase {
    @NonNull
    private static Logger logger = Logger.getLogger(RequestProcessorBase.class);
    @NonNull
    private Dispatcher dispatcher;
    @NonNull
    private Registry registry;
    @NonNull
    private GlobalConfiguration globalConfiguration;
    @CheckForNull
    private static Gson gson;

    protected GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    protected RequestProcessorBase(Registry registry, Dispatcher dispatcher, GlobalConfiguration globalConfiguration) {
        assert (registry != null);
        assert (dispatcher != null);
        assert (globalConfiguration != null);
        this.dispatcher = dispatcher;
        this.globalConfiguration = globalConfiguration;
        this.registry = registry;
    }

    protected Registry getRegistry() {
        return this.registry;
    }

    protected Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    protected boolean getDebug() {
        return this.globalConfiguration.getDebug();
    }

    protected void appendIndividualResponseJsonString(ResponseData response, StringBuilder result) {
        assert (response != null);
        assert (result != null);
        try {
            this.getGson().toJson((Object)response, (Appendable)result);
        }
        catch (JsonParseException ex) {
            JsonException.forFailedConversionFromResponseToJson(response, ex);
        }
    }

    protected synchronized Gson getGson() {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder();
            this.createGsonBuilderConfigurator().configure(builder, this.getGlobalConfiguration());
            gson = builder.create();
        }
        return gson;
    }

    private GsonBuilderConfigurator createGsonBuilderConfigurator() {
        Class<? extends GsonBuilderConfigurator> configuratorClass = this.getGlobalConfiguration().getGsonBuilderConfiguratorClass();
        try {
            return configuratorClass.newInstance();
        }
        catch (InstantiationException e) {
            GsonBuilderConfiguratorException ex = GsonBuilderConfiguratorException.forUnableToInstantiateGsonBuilder(configuratorClass, e);
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (IllegalAccessException e) {
            GsonBuilderConfiguratorException ex = GsonBuilderConfiguratorException.forUnableToInstantiateGsonBuilder(configuratorClass, e);
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }
}

