/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.jscodegen;

import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.api.RegisteredApi;
import com.softwarementors.extjs.djn.api.RegisteredCode;
import com.softwarementors.extjs.djn.api.Registry;
import com.softwarementors.extjs.djn.config.GlobalConfiguration;
import com.softwarementors.extjs.djn.jscodegen.ApiCodeGenerator;
import com.softwarementors.extjs.djn.jscodegen.Minifier;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class CodeFileGenerator {
    @NonNull
    private Registry registry;
    @NonNull
    private static final Logger logger = Logger.getLogger(CodeFileGenerator.class);

    private GlobalConfiguration getGlobalConfiguration() {
        return this.registry.getGlobalConfiguration();
    }

    private CodeFileGenerator(Registry registry) {
        assert (registry != null);
        this.registry = registry;
    }

    public static void updateSource(Registry registry, boolean saveApiFiles) throws IOException {
        assert (registry != null);
        CodeFileGenerator generator = new CodeFileGenerator(registry);
        generator.generateCode(saveApiFiles);
    }

    private void generateCode(boolean saveApiFiles) throws IOException {
        boolean minify = this.getGlobalConfiguration().getMinify();
        boolean debug = this.getGlobalConfiguration().getDebug();
        HashMap<String, RegisteredCode> registeredCodes = new HashMap<String, RegisteredCode>();
        for (RegisteredApi registeredApi : this.registry.getApis()) {
            String apiFile = registeredApi.getApiFile();
            String fullApiFileName = registeredApi.getFullApiFileName();
            RegisteredCode code = (RegisteredCode)registeredCodes.get(apiFile);
            if (code == null) {
                code = new RegisteredCode(apiFile, fullApiFileName, minify, debug);
                registeredCodes.put(apiFile, code);
            }
            ApiCodeGenerator generator = new ApiCodeGenerator(this.getGlobalConfiguration(), registeredApi);
            generator.appendCode(code.getDebugCodeBuilder(), false);
            generator.appendCode(code.getNonCommentsCodeBuilder(), true);
        }
        for (Map.Entry entry : registeredCodes.entrySet()) {
            String sourceName = (String)entry.getKey();
            RegisteredCode code = (RegisteredCode)entry.getValue();
            String debugSourceName = CodeFileGenerator.getDebugFileName(sourceName);
            this.registry.addSource(sourceName, code.getCode());
            this.registry.addSource(debugSourceName, code.getDebugCode());
            if (minify) {
                String minifiedSourceName = Minifier.getMinifiedFileName(sourceName);
                this.registry.addSource(minifiedSourceName, code.getMinifiedCode());
            }
            if (saveApiFiles) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Creating source files for APIs...");
                }
                String defaultFileName = code.getFullApiFileName();
                String debugFileName = CodeFileGenerator.getDebugFileName(defaultFileName);
                String minifiedFileName = Minifier.getMinifiedFileName(defaultFileName);
                CodeFileGenerator.updateFile(debugFileName, code.getDebugCode());
                CodeFileGenerator.updateFile(defaultFileName, code.getCode());
                if (minify) {
                    CodeFileGenerator.updateFile(minifiedFileName, code.getMinifiedCode());
                    continue;
                }
                CodeFileGenerator.deleteFile(minifiedFileName);
                continue;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)"Source files for APIs have not been created: you will need to reference them dynamically");
        }
    }

    private static void deleteFile(String fullFileName) throws IOException {
        assert (!StringUtils.isEmpty(fullFileName));
        File file = new File(fullFileName);
        if (file.exists()) {
            if (!file.delete()) {
                throw new IOException("Unable to delete " + fullFileName);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Api file deleted: '" + file.getAbsolutePath() + "'"));
            }
        }
    }

    private static void updateFile(String fullFileName, String code) throws IOException {
        assert (!StringUtils.isEmpty(fullFileName));
        assert (code != null);
        File file = new File(fullFileName);
        if (!CodeFileGenerator.fileContentEquals(file, code)) {
            FileUtils.writeStringToFile((File)file, (String)code);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Api file updated: '" + file.getAbsolutePath() + "'"));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Api file '" + file.getAbsolutePath() + '\'' + " is up to date: it was not rewritten."));
        }
    }

    private static boolean fileContentEquals(File file, String code) throws IOException {
        assert (file != null);
        assert (code != null);
        if (file.exists()) {
            String contents = FileUtils.readFileToString((File)file);
            boolean result = contents.equals(code);
            return result;
        }
        return false;
    }

    private static String getDebugFileName(String file) {
        String result = file.replace(".js", "-debug.js");
        return result;
    }
}

