/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.api;

import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.jscodegen.Minifier;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.log4j.Logger;

public class RegisteredCode {
    @NonNull
    public static final Logger logger = Logger.getLogger(RegisteredCode.class);
    private boolean minify;
    private boolean debug;
    private boolean minificationFailed;
    @NonNull
    private String name;
    @NonNull
    private String fullApiFileName;
    @NonNull
    private StringBuilder debugCodeBuilder = new StringBuilder();
    @NonNull
    private StringBuilder nonCommentsCodeBuilder = new StringBuilder();
    private String minifiedCode;
    private String debugCode;
    private String nonCommentsCode;

    public boolean hasDebugCode() {
        return this.debug;
    }

    public boolean hasMinifiedCode() {
        return this.minify;
    }

    public RegisteredCode(String name, String fullApiFileName, boolean minify, boolean debug) {
        assert (!StringUtils.isEmpty(name));
        assert (!StringUtils.isEmpty(fullApiFileName));
        this.name = name;
        this.fullApiFileName = fullApiFileName;
        this.minify = minify;
        this.debug = debug;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getFullApiFileName() {
        return this.fullApiFileName;
    }

    @NonNull
    public StringBuilder getDebugCodeBuilder() {
        assert (this.hasDebugCode());
        return this.debugCodeBuilder;
    }

    @NonNull
    public String getDebugCode() {
        if (this.debugCode == null) {
            this.debugCode = this.debugCodeBuilder.toString();
        }
        return this.debugCode;
    }

    @NonNull
    public StringBuilder getNonCommentsCodeBuilder() {
        return this.nonCommentsCodeBuilder;
    }

    @NonNull
    public String getNonCommentsCode() {
        if (this.nonCommentsCode == null) {
            this.nonCommentsCode = this.nonCommentsCodeBuilder.toString();
        }
        return this.nonCommentsCode;
    }

    @CheckForNull
    public String getMinifiedCode() {
        assert (this.hasMinifiedCode());
        if (this.minifiedCode == null && !this.minificationFailed) {
            this.minifiedCode = Minifier.minify(this.getNonCommentsCode(), this.getName(), this.getDebugCode().length());
            boolean bl = this.minificationFailed = this.minifiedCode == null;
            if (this.minificationFailed) {
                logger.warn((Object)("Unable to minify code for '" + this.getName() + "'."));
            }
        }
        return this.minifiedCode;
    }

    @NonNull
    public String getCode() {
        String code = null;
        if (this.hasDebugCode()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Production mode: using debug code for '" + this.getName() + "'"));
            }
            code = this.getDebugCode();
        } else if (this.hasMinifiedCode()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Production mode: using minified code for '" + this.getName() + "'"));
            }
            code = this.getMinifiedCode();
        }
        if (code == null) {
            code = this.getNonCommentsCode();
        }
        return code;
    }
}

