/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String value) {
        return value == null || value.equals("");
    }

    public static String concatWithSeparator(List<String> missingParameters, String separator) {
        assert (missingParameters != null);
        assert (separator != null);
        if (missingParameters.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < missingParameters.size() - 1; ++i) {
            result.append(missingParameters.get(i));
            result.append(separator);
        }
        result.append(missingParameters.get(missingParameters.size() - 1));
        return result.toString();
    }

    public static List<String> getNonBlankValues(String delimitedValues, String delimiter) {
        String[] values;
        assert (!StringUtils.isEmpty(delimitedValues));
        assert (!StringUtils.isEmpty(delimiter));
        ArrayList<String> result = new ArrayList<String>();
        for (String value : values = delimitedValues.split(delimiter)) {
            if ((value = value.trim()).equals("")) continue;
            result.add(value);
        }
        return result;
    }

    public static boolean startsWithCaseInsensitive(String s1, String s2) {
        assert (s2 != null);
        if (s1 == null) {
            return false;
        }
        String s1lower = s1.toLowerCase(Locale.getDefault());
        String s2lower = s2.toLowerCase(Locale.getDefault());
        return s1lower.startsWith(s2lower);
    }
}

