/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelTask<V>
implements Future<Collection<V>> {
    @NonNull
    private final List<BoundedFuture> submittedQueue;
    @NonNull
    private final BlockingQueue<BoundedFuture> completedQueue;
    @NonNull
    private final Semaphore semaphore;
    @NonNull
    private final Executor executor;
    private final int size;
    private boolean cancelled = false;

    public ParallelTask(Executor exec, Collection<Callable<V>> callable, int permits) {
        if (exec == null || callable == null) {
            throw new NullPointerException();
        }
        this.executor = exec;
        this.semaphore = new Semaphore(permits);
        this.size = callable.size();
        this.submittedQueue = new ArrayList<BoundedFuture>(this.size);
        this.completedQueue = new LinkedBlockingQueue<BoundedFuture>(this.size);
        for (Callable<V> c : callable) {
            this.submittedQueue.add(new BoundedFuture(c));
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.cancelled = true;
        for (BoundedFuture f : this.submittedQueue) {
            f.cancel(mayInterruptIfRunning);
        }
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> get() throws InterruptedException, ExecutionException {
        ArrayList result = new ArrayList(this.submittedQueue.size());
        boolean done = false;
        try {
            for (BoundedFuture f : this.submittedQueue) {
                if (this.isCancelled()) break;
                this.semaphore.acquire();
                this.executor.execute(f);
            }
            for (int i = 0; i < this.size && !this.isCancelled(); ++i) {
                result.add(this.completedQueue.take().get());
            }
            done = true;
        }
        finally {
            if (!done) {
                this.cancel(true);
            }
        }
        return result;
    }

    @Override
    public Collection<V> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("We do not support timeouts in DirectJNgine, and therefore we haven't tested the following code!");
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.completedQueue.size() == this.size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BoundedFuture
    extends FutureTask<V> {
        BoundedFuture(Callable<V> c) {
            super(c);
        }

        @Override
        protected void done() {
            ParallelTask.this.semaphore.release();
            ParallelTask.this.completedQueue.add(this);
        }
    }
}

