/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn;

import com.softwarementors.extjs.djn.ClassUtils;
import com.softwarementors.extjs.djn.router.dispatcher.MethodExecutionException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static List<Throwable> getRelevantExceptions(Throwable e) {
        ArrayList<Throwable> result = new ArrayList<Throwable>();
        for (Throwable t = e; t != null; t = t.getCause()) {
            if (ExceptionUtils.skipException(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static boolean skipException(Throwable t) {
        assert (t != null);
        return t instanceof MethodExecutionException || t instanceof InvocationTargetException;
    }

    public static Throwable getFirstRelevantExceptionToReport(Throwable t) {
        assert (t != null);
        Throwable reportedException = t;
        while (ExceptionUtils.skipException(reportedException)) {
            reportedException = reportedException.getCause();
            assert (reportedException != null);
        }
        return reportedException;
    }

    public static String getExceptionMessage(Throwable t) {
        assert (t != null);
        String result = ClassUtils.getSimpleName(t.getClass());
        if (t.getMessage() != null) {
            result = result + ": " + t.getMessage();
        }
        return result;
    }

    public static String getExceptionWhere(Throwable t, boolean debugMode) {
        assert (t != null);
        if (debugMode) {
            StringWriter where = new StringWriter();
            PrintWriter printWriter = new PrintWriter(where);
            t.printStackTrace(printWriter);
            return ((Object)where).toString();
        }
        return "";
    }
}

