/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtils {
    private ClassUtils() {
    }

    @Nullable
    public static Class<?> getFieldType(Class<?> cls, String field) {
        assert (cls != null);
        assert (field != null);
        Class<?> vClass = cls;
        Class<?> fieldType = null;
        do {
            Field[] fields;
            for (Field f : fields = vClass.getDeclaredFields()) {
                if (!f.getName().equals(field)) continue;
                fieldType = f.getType();
                return fieldType;
            }
        } while (!(vClass = vClass.getSuperclass()).equals(Object.class));
        return null;
    }

    public static boolean isNumericType(Class<?> cls) {
        assert (cls != null);
        if (cls == Float.TYPE || cls == Double.TYPE || cls == Byte.TYPE || cls == Short.TYPE || cls == Integer.TYPE || cls == Long.TYPE) {
            return true;
        }
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            if (!currentClass.equals(Number.class)) continue;
            return true;
        }
        return false;
    }

    public static String getSimpleName(Class<?> cls) {
        assert (cls != null);
        String result = cls.getName();
        int simpleNameStart = result.lastIndexOf("$");
        if (simpleNameStart >= 0) {
            ++simpleNameStart;
            while (simpleNameStart < result.length()) {
                if (!Character.isDigit(result.charAt(simpleNameStart))) {
                    return result.substring(simpleNameStart);
                }
                ++simpleNameStart;
            }
        } else {
            simpleNameStart = result.lastIndexOf(".");
            if (simpleNameStart >= 0) {
                return result.substring(simpleNameStart + 1);
            }
        }
        return result;
    }

    public static String getNicePrintableName(Class<?> cls) {
        String typeName;
        assert (cls != null);
        Class<?> type = cls;
        if (cls.isArray()) {
            type = cls.getComponentType();
        }
        if ((typeName = type.getName()).startsWith("java.lang")) {
            typeName = ClassUtils.getSimpleName(type);
        }
        if (cls.isArray()) {
            typeName = typeName + "[]";
        }
        return typeName;
    }
}

