/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.util;

import com.socialize.Socialize;
import com.socialize.config.SocializeConfig;
import com.socialize.error.SocializeException;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.SocializeEntityLoader;
import com.socialize.util.EntityLoaderUtils;
import com.socialize.util.ObjectUtils;
import com.socialize.util.StringUtils;

public class SocializeEntityLoaderUtils
implements EntityLoaderUtils {
    private SocializeConfig config;
    private ObjectUtils objectUtils;
    private SocializeLogger logger;

    @Override
    public SocializeEntityLoader initEntityLoader() {
        SocializeEntityLoader entityLoader;
        block10: {
            entityLoader = Socialize.getSocialize().getEntityLoader();
            if (entityLoader == null) {
                String entityLoaderClassName = this.config.getProperty("socialize.entity.loader");
                if (!StringUtils.isEmpty(entityLoaderClassName)) {
                    try {
                        Object loader;
                        if (this.logger != null && this.logger.isDebugEnabled()) {
                            this.logger.debug("Instantiating entity loader [" + entityLoader + "]");
                        }
                        if ((loader = this.objectUtils.construct(entityLoaderClassName)) instanceof SocializeEntityLoader) {
                            entityLoader = (SocializeEntityLoader)loader;
                            Socialize.getSocialize().setEntityLoader(entityLoader);
                        } else if (this.logger != null) {
                            this.logger.error("Entity loader [" + entityLoader + "] is not an instance of [" + SocializeEntityLoader.class.getName() + "]");
                        }
                        break block10;
                    }
                    catch (SocializeException e) {
                        if (this.logger != null) {
                            this.logger.error("Failed to instantiate entity loader [" + entityLoader + "]", (Throwable)e);
                        }
                        break block10;
                    }
                }
                if (this.logger != null) {
                    this.logger.warn("No entity loader specified in socialize.properties");
                }
            }
        }
        return entityLoader;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public void setObjectUtils(ObjectUtils objectUtils) {
        this.objectUtils = objectUtils;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

