/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.util;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageUtils {
    private static int MAX_IMAGE_DIMENSION = 720;

    public byte[] scaleImage(Context context, Bitmap bitmap, Bitmap.CompressFormat format) {
        int width = bitmap.getWidth();
        if (width > MAX_IMAGE_DIMENSION) {
            float ratio = (float)MAX_IMAGE_DIMENSION / (float)width;
            width = MAX_IMAGE_DIMENSION;
            int height = (int)((float)bitmap.getHeight() * ratio);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(format, 100, (OutputStream)stream);
        return stream.toByteArray();
    }

    public byte[] scaleImage(Context context, Uri photoUri) throws IOException {
        Bitmap bitmap;
        int rotatedHeight;
        int rotatedWidth;
        InputStream is = context.getContentResolver().openInputStream(photoUri);
        BitmapFactory.Options dbo = new BitmapFactory.Options();
        dbo.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)dbo);
        is.close();
        int orientation = this.getOrientation(context, photoUri);
        if (orientation == 90 || orientation == 270) {
            rotatedWidth = dbo.outHeight;
            rotatedHeight = dbo.outWidth;
        } else {
            rotatedWidth = dbo.outWidth;
            rotatedHeight = dbo.outHeight;
        }
        is = context.getContentResolver().openInputStream(photoUri);
        if (rotatedWidth > MAX_IMAGE_DIMENSION || rotatedHeight > MAX_IMAGE_DIMENSION) {
            float widthRatio = (float)rotatedWidth / (float)MAX_IMAGE_DIMENSION;
            float heightRatio = (float)rotatedHeight / (float)MAX_IMAGE_DIMENSION;
            float maxRatio = Math.max(widthRatio, heightRatio);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = (int)maxRatio;
            bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        } else {
            bitmap = BitmapFactory.decodeStream((InputStream)is);
        }
        is.close();
        if (orientation > 0) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)orientation);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        String type = context.getContentResolver().getType(photoUri);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (type != null && type.equals("image/png")) {
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        } else {
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        }
        byte[] bMapArray = baos.toByteArray();
        baos.close();
        return bMapArray;
    }

    public int getOrientation(Context context, Uri photoUri) {
        Cursor cursor = context.getContentResolver().query(photoUri, new String[]{"orientation"}, null, null, null);
        if (cursor == null || cursor.getCount() != 1) {
            return -1;
        }
        cursor.moveToFirst();
        return cursor.getInt(0);
    }
}

