/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.util;

import android.app.Activity;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import com.socialize.R;
import com.socialize.log.SocializeLogger;
import com.socialize.util.BitmapUtils;
import com.socialize.util.CacheableDrawable;
import com.socialize.util.ClassLoaderProvider;
import com.socialize.util.DrawableCache;
import com.socialize.util.ReflectionUtils;
import java.io.InputStream;

public class Drawables {
    private DisplayMetrics metrics = null;
    private ClassLoaderProvider classLoaderProvider;
    private DrawableCache cache;
    private BitmapUtils bitmapUtils;
    private SocializeLogger logger;
    private Resources resources;

    public void init(Activity context) {
        this.metrics = new DisplayMetrics();
        this.resources = context.getResources();
        context.getWindowManager().getDefaultDisplay().getMetrics(this.metrics);
    }

    public Drawable getDrawable(String name) {
        return this.getDrawable(name, false, false, true);
    }

    public Drawable getDrawable(String name, boolean tileX, boolean tileY, boolean eternal) {
        int resourceId;
        String extra = "";
        int hashIndex = name.indexOf(35);
        if (hashIndex >= 0) {
            extra = name.substring(hashIndex, name.length());
            name = name.substring(0, hashIndex);
        }
        if ((resourceId = this.getDrawableResourceId(name)) > 0) {
            return this.getDrawable(resourceId, extra, tileX, tileY, eternal);
        }
        return null;
    }

    public Drawable getDrawable(int resourceId, String extra, boolean tileX, boolean tileY, boolean eternal) {
        return this.getDrawable(resourceId, extra, tileX, tileY, -1, -1, eternal);
    }

    public Drawable getDrawable(int resourceId, String extra) {
        return this.getDrawable(resourceId, extra, false, false, -1, -1, true);
    }

    public Drawable getDrawableFromUrl(String url, byte[] data, int scaleToWidth, int scaleToHeight) {
        CacheableDrawable drawable2 = (CacheableDrawable)this.cache.get(url);
        if (drawable2 == null) {
            Bitmap bitmap = this.bitmapUtils.getScaledBitmap(data, scaleToWidth, scaleToHeight);
            drawable2 = this.createDrawable(bitmap, url);
            this.addToCache(url, drawable2, false);
        }
        return drawable2;
    }

    private final int getDrawableResourceId(String name) {
        if (name.endsWith(".png")) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        try {
            Class<R.drawable> drawable2 = R.drawable.class;
            Integer id = (Integer)ReflectionUtils.getStaticField(name, drawable2);
            if (id != null) {
                return id;
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to find drawable with name " + name, (Throwable)e);
        }
        return -1;
    }

    public Drawable getDrawable(int resourceId, String extra, boolean tileX, boolean tileY, int scaleToWidth, int scaleToHeight, boolean eternal) {
        String key = String.valueOf(resourceId) + extra;
        CacheableDrawable drawable2 = (CacheableDrawable)this.cache.get(key);
        if (drawable2 != null && !drawable2.isRecycled()) {
            return drawable2;
        }
        Bitmap bmp = BitmapFactory.decodeResource((Resources)this.resources, (int)resourceId);
        drawable2 = this.createDrawable(bmp, key);
        if (tileX) {
            drawable2.setTileModeX(Shader.TileMode.REPEAT);
        }
        if (tileY) {
            drawable2.setTileModeY(Shader.TileMode.REPEAT);
        }
        this.addToCache(key, drawable2, eternal);
        return drawable2;
    }

    public ClassLoaderProvider getClassLoaderProvider() {
        return this.classLoaderProvider;
    }

    public void setClassLoaderProvider(ClassLoaderProvider classLoaderProvider) {
        this.classLoaderProvider = classLoaderProvider;
    }

    public DrawableCache getCache() {
        return this.cache;
    }

    public void setCache(DrawableCache cache) {
        this.cache = cache;
    }

    public void setBitmapUtils(BitmapUtils bitmapUtils) {
        this.bitmapUtils = bitmapUtils;
    }

    public void setMetrics(DisplayMetrics metrics) {
        this.metrics = metrics;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    protected CacheableDrawable createDrawable(InputStream in, String name, boolean tileX, boolean tileY, int pixelsX, int pixelsY) {
        Bitmap bitmap = this.bitmapUtils.getScaledBitmap(in, pixelsX, pixelsY, 160);
        CacheableDrawable drawable2 = this.createDrawable(bitmap, name);
        if (tileX) {
            drawable2.setTileModeX(Shader.TileMode.REPEAT);
        }
        if (tileY) {
            drawable2.setTileModeY(Shader.TileMode.REPEAT);
        }
        return drawable2;
    }

    protected CacheableDrawable createDrawable(Bitmap bitmap, String name) {
        return new CacheableDrawable(this.resources, bitmap, name);
    }

    protected void addToCache(String key, CacheableDrawable drawable2, boolean eternal) {
        if (drawable2 != null) {
            this.cache.put(key, drawable2, eternal);
        }
    }
}

