/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.util;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.socialize.log.SocializeLogger;
import com.socialize.util.AppUtils;
import com.socialize.util.StringUtils;

public class DeviceUtils {
    private SocializeLogger logger;
    private AppUtils appUtils;
    private boolean hasCamera;
    private boolean deviceIdObtained = false;
    private String deviceId;

    public void init(Context context) {
        if (this.appUtils != null) {
            this.hasCamera = this.appUtils.isIntentAvailable(context, "android.media.action.IMAGE_CAPTURE");
        }
    }

    public String getAndroidID(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public String getUDID(Context context) {
        if (!this.deviceIdObtained) {
            if (this.appUtils.hasPermission(context, "android.permission.READ_PHONE_STATE")) {
                TelephonyManager tManager = (TelephonyManager)context.getSystemService("phone");
                this.deviceId = tManager.getDeviceId();
            }
            if (StringUtils.isEmpty(this.deviceId)) {
                if (this.logger != null) {
                    this.logger.warn("Unable to determine device UDID, reverting to android_id");
                }
                this.deviceId = this.getAndroidID(context);
            }
            if (StringUtils.isEmpty(this.deviceId) && this.logger != null) {
                this.logger.error(4);
            }
            this.deviceIdObtained = true;
        }
        return this.deviceId;
    }

    public boolean hasCamera() {
        return this.hasCamera;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setAppUtils(AppUtils appUtils) {
        this.appUtils = appUtils;
    }
}

