/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.util;

import android.graphics.Bitmap;
import com.socialize.util.Base64Utils;
import com.socialize.util.BitmapBuilder;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtils {
    private BitmapBuilder bitmapBuilder;
    private Base64Utils base64Utils;
    private int defaultDensity = 160;

    public BitmapUtils(BitmapBuilder bitmapBuilder) {
        this.bitmapBuilder = bitmapBuilder;
    }

    public BitmapUtils() {
    }

    public Bitmap getScaledBitmap(byte[] data, int scaleToWidth, int scaleToHeight) {
        return this.getScaledBitmap(this.bitmapBuilder.decode(data), scaleToWidth, scaleToHeight, this.defaultDensity);
    }

    public Bitmap getScaledBitmap(InputStream in, int scaleToWidth, int scaleToHeight) {
        return this.getScaledBitmap(this.bitmapBuilder.decode(in), scaleToWidth, scaleToHeight, this.defaultDensity);
    }

    public Bitmap getScaledBitmap(Bitmap bitmap, int scaleToWidth, int scaleToHeight) {
        return this.getScaledBitmap(bitmap, scaleToWidth, scaleToHeight, true, this.defaultDensity);
    }

    public Bitmap getScaledBitmap(byte[] data, int scaleToWidth, int scaleToHeight, int density) {
        return this.getScaledBitmap(this.bitmapBuilder.decode(data), scaleToWidth, scaleToHeight, density);
    }

    public Bitmap getScaledBitmap(InputStream in, int scaleToWidth, int scaleToHeight, int density) {
        return this.getScaledBitmap(this.bitmapBuilder.decode(in), scaleToWidth, scaleToHeight, density);
    }

    public Bitmap getScaledBitmap(Bitmap bitmap, int scaleToWidth, int scaleToHeight, int density) {
        return this.getScaledBitmap(bitmap, scaleToWidth, scaleToHeight, true, density);
    }

    public String encode(Bitmap bitmap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        byte[] image = baos.toByteArray();
        return this.base64Utils.encode(image);
    }

    public Bitmap getScaledBitmap(Bitmap bitmap, int scaleToWidth, int scaleToHeight, boolean recycleOriginal, int density) {
        bitmap.setDensity(density);
        Bitmap original = bitmap;
        if (scaleToWidth > 0 || scaleToHeight > 0) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (height != scaleToHeight || width != scaleToWidth) {
                float ratio = 1.0f;
                if (height > width) {
                    ratio = (float)scaleToWidth / (float)width;
                    width = scaleToWidth;
                    height = Math.round((float)height * ratio);
                    bitmap = this.bitmapBuilder.scale(bitmap, width, height);
                    width = bitmap.getWidth();
                    height = bitmap.getHeight();
                    if (height > scaleToHeight) {
                        int diff = height - scaleToHeight;
                        int half = Math.round((float)diff / 2.0f);
                        bitmap = this.bitmapBuilder.crop(bitmap, 0, half, width, scaleToHeight);
                    }
                } else {
                    ratio = (float)scaleToHeight / (float)height;
                    height = scaleToHeight;
                    width = Math.round((float)width * ratio);
                    bitmap = this.bitmapBuilder.scale(bitmap, width, height);
                    width = bitmap.getWidth();
                    height = bitmap.getHeight();
                    if (width > scaleToWidth) {
                        int diff = width - scaleToWidth;
                        int half = Math.round((float)diff / 2.0f);
                        bitmap = this.bitmapBuilder.crop(bitmap, half, 0, scaleToWidth, height);
                    }
                }
                if (recycleOriginal) {
                    original.recycle();
                }
            }
        }
        return bitmap;
    }

    public void setBitmapBuilder(BitmapBuilder bitmapBuilder) {
        this.bitmapBuilder = bitmapBuilder;
    }

    public void setBase64Utils(Base64Utils base64Utils) {
        this.base64Utils = base64Utils;
    }
}

