/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.view;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.socialize.i18n.LocalizationService;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;
import com.socialize.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class SocializeButton
extends LinearLayout {
    private LocalizationService localizationService;
    private Drawables drawables;
    private Colors colors;
    private DisplayUtils displayUtils;
    private ImageView imageView = null;
    private TextView textView = null;
    private Integer height = 32;
    private Integer width = null;
    private int textSize = 12;
    private int padding = 0;
    private int textColor = -1;
    private int buttonWidth;
    private int buttonHeight;
    private int imagePaddingLeft = 0;
    private int imagePaddingRight = 0;
    @Deprecated
    private String text = "";
    private String textKey;
    private String imageName;
    private boolean bold = false;
    private boolean italic = false;
    private boolean backgroundVisible = true;
    private String bottomColor = "BUTTON_BOTTOM";
    private String topColor = "BUTTON_TOP";
    private String strokeTopColor = "BUTTON_TOP_STROKE";
    private String strokeBottomColor = "BUTTON_BOTTOM_STROKE";
    private String backgroundColor = null;
    private String textAlign = "left";
    private View.OnClickListener customClickListener;
    private List<View.OnClickListener> beforeListeners;
    private List<View.OnClickListener> afterListeners;
    private int textPadding;
    private int cornerRadius = 2;
    private int computedRadius;

    public SocializeButton(Context context) {
        super(context);
    }

    public void init() {
        int dipPadding = 0;
        this.buttonWidth = -2;
        this.buttonHeight = -2;
        if (this.displayUtils != null) {
            dipPadding = this.displayUtils.getDIP(this.padding);
            this.computedRadius = this.displayUtils.getDIP(this.cornerRadius);
            this.textPadding = this.displayUtils.getDIP(4);
            if (this.width == null) {
                this.buttonWidth = -1;
            } else if (this.width > 0) {
                this.buttonWidth = this.displayUtils.getDIP(this.width);
            }
            if (this.height == null) {
                this.buttonHeight = -1;
            } else if (this.height > 0) {
                this.buttonHeight = this.displayUtils.getDIP(this.height);
            }
        }
        View.OnClickListener onClickListener = this.getOnClickListener();
        LinearLayout.LayoutParams fill = this.makeLayoutParams(this.buttonWidth, this.buttonHeight);
        fill.setMargins(dipPadding, dipPadding, dipPadding, dipPadding);
        this.setOrientation(0);
        this.setLayoutParams((ViewGroup.LayoutParams)fill);
        this.setPadding(dipPadding, dipPadding, dipPadding, dipPadding);
        this.setClickable(true);
        TEXT_ALIGN align = TEXT_ALIGN.LEFT;
        if (!StringUtils.isEmpty(this.textAlign)) {
            this.textAlign = this.textAlign.trim().toUpperCase();
            try {
                align = TEXT_ALIGN.valueOf(this.textAlign);
            }
            catch (Exception e) {
                SocializeLogger.w(e.getMessage(), e);
            }
        }
        switch (align) {
            case LEFT: {
                this.setGravity(19);
                break;
            }
            case CENTER: {
                this.setGravity(17);
                break;
            }
            case RIGHT: {
                this.setGravity(21);
            }
        }
        LinearLayout.LayoutParams imageLayout = this.makeLayoutParams(-2, -2);
        LinearLayout.LayoutParams textLayout = this.makeLayoutParams(-2, -2);
        this.textView = this.makeTextView();
        this.textView.setTextColor(this.textColor);
        if (this.bold) {
            if (this.italic) {
                this.textView.setTypeface(Typeface.DEFAULT_BOLD, 3);
            } else {
                this.textView.setTypeface(Typeface.DEFAULT_BOLD);
            }
        } else if (this.italic) {
            this.textView.setTypeface(Typeface.DEFAULT, 2);
        }
        this.setTextSize(this.textSize);
        if (!StringUtils.isEmpty(this.textKey)) {
            this.textView.setText((CharSequence)this.localizationService.getString(this.textKey));
        }
        this.textView.setLayoutParams((ViewGroup.LayoutParams)textLayout);
        if (!StringUtils.isEmpty(this.imageName)) {
            this.imageView = this.makeImageView();
            this.imageView.setImageDrawable(this.drawables.getDrawable(this.imageName));
            this.imageView.setLayoutParams((ViewGroup.LayoutParams)imageLayout);
            if (this.displayUtils != null) {
                this.imageView.setPadding(this.displayUtils.getDIP(this.imagePaddingLeft), 0, this.displayUtils.getDIP(this.imagePaddingRight), 0);
            }
            if (!this.backgroundVisible) {
                this.imageView.setOnClickListener(onClickListener);
            }
            this.addView((View)this.imageView);
            if (!StringUtils.isEmpty(this.text)) {
                this.textView.setPadding(this.textPadding, 0, 0, 0);
            }
        } else {
            this.textView.setPadding(0, 0, 0, 0);
        }
        if (this.backgroundVisible) {
            StateListDrawable state = new StateListDrawable();
            state.addState(new int[]{16842910}, this.makeEnabledBackgroundDrawable());
            state.addState(new int[]{-16842910}, this.makeDisabledBackgroundDrawable());
            CompatUtils.setBackgroundDrawable((View)this, (Drawable)state);
        }
        this.addView((View)this.textView);
        this.setOnClickListener(onClickListener);
    }

    protected Drawable makeEnabledBackgroundDrawable() {
        if (this.colors != null) {
            int bottom = this.colors.getColor(this.bottomColor);
            int top = this.colors.getColor(this.topColor);
            int strokeTop = this.colors.getColor(this.strokeTopColor);
            int strokeBottom = this.colors.getColor(this.strokeBottomColor);
            int bgColor = -16777216;
            if (!StringUtils.isEmpty(this.backgroundColor)) {
                bgColor = this.colors.getColor(this.backgroundColor);
            }
            return this.makeBackgroundDrawable(bgColor, this.computedRadius, strokeBottom, strokeTop, bottom, top);
        }
        return this.makeBackgroundDrawable(0, this.computedRadius, 0, 0, 0, 0);
    }

    protected Drawable makeDisabledBackgroundDrawable() {
        if (this.colors != null) {
            int bottom = this.colors.getColor("BUTTON_DISABLED_BOTTOM");
            int top = this.colors.getColor("BUTTON_DISABLED_TOP");
            int strokeTop = this.colors.getColor("BUTTON_DISABLED_STROKE");
            int strokeBottom = this.colors.getColor("BUTTON_DISABLED_STROKE");
            int bgColor = this.colors.getColor("BUTTON_DISABLED_BACKGROUND");
            return this.makeBackgroundDrawable(bgColor, this.computedRadius, strokeBottom, strokeTop, bottom, top);
        }
        return null;
    }

    protected Drawable makeBackgroundDrawable(int bgColor, float radius, int strokeBottom, int strokeTop, int bottom, int top) {
        GradientDrawable base = this.makeGradient(bgColor, bgColor);
        GradientDrawable stroke = this.makeGradient(strokeBottom, strokeTop);
        if (this.displayUtils != null) {
            base.setCornerRadius(radius + (float)this.displayUtils.getDIP(2));
            stroke.setCornerRadius(radius + (float)this.displayUtils.getDIP(1));
        }
        GradientDrawable background = this.makeGradient(bottom, top);
        background.setCornerRadius(radius);
        LayerDrawable layers = new LayerDrawable(new Drawable[]{base, stroke, background});
        layers.setLayerInset(1, 1, 1, 1, 1);
        layers.setLayerInset(2, 2, 2, 2, 2);
        return layers;
    }

    protected View.OnClickListener getOnClickListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (SocializeButton.this.beforeListeners != null) {
                    for (View.OnClickListener listener : SocializeButton.this.beforeListeners) {
                        listener.onClick(v);
                    }
                }
                if (SocializeButton.this.customClickListener != null) {
                    SocializeButton.this.customClickListener.onClick(v);
                }
                if (SocializeButton.this.afterListeners != null) {
                    for (View.OnClickListener listener : SocializeButton.this.afterListeners) {
                        listener.onClick(v);
                    }
                }
            }
        };
    }

    protected ImageView makeImageView() {
        return new ImageView(this.getContext());
    }

    protected TextView makeTextView() {
        return new TextView(this.getContext());
    }

    protected LinearLayout.LayoutParams makeLayoutParams(int width, int height) {
        return new LinearLayout.LayoutParams(width, height);
    }

    protected GradientDrawable makeGradient(int bottom, int top) {
        return new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{bottom, top});
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public void setTextSize(int textSize) {
        if (this.textView != null) {
            this.textView.setTextSize(1, (float)textSize);
        }
        this.textSize = textSize;
    }

    @Deprecated
    public void setText(String text) {
        if (this.textView != null) {
            this.textView.setText((CharSequence)text);
            this.textView.setPadding(this.textPadding, 0, 0, 0);
        }
        this.text = text;
    }

    public void setTextKey(String textKey) {
        if (this.textView != null) {
            this.textView.setText((CharSequence)this.localizationService.getString(textKey));
            this.textView.setPadding(this.textPadding, 0, 0, 0);
        }
        this.textKey = textKey;
    }

    public void setBottomColor(String bottomColor) {
        this.bottomColor = bottomColor;
    }

    public void setTopColor(String topColor) {
        this.topColor = topColor;
    }

    public void setStrokeTopColor(String strokeTopColor) {
        this.strokeTopColor = strokeTopColor;
    }

    public void setStrokeBottomColor(String strokeBottomColor) {
        this.strokeBottomColor = strokeBottomColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public Integer getButtonHeight() {
        return this.buttonHeight;
    }

    public Integer getButtonWidth() {
        return this.buttonWidth;
    }

    public void setCustomClickListener(View.OnClickListener customClickListener) {
        this.customClickListener = customClickListener;
    }

    public void setImagePaddingLeft(int imagePaddingLeft) {
        this.imagePaddingLeft = imagePaddingLeft;
    }

    public void setImagePaddingRight(int imagePaddingRight) {
        this.imagePaddingRight = imagePaddingRight;
    }

    public void setBackgroundVisible(boolean backgroundVisible) {
        this.backgroundVisible = backgroundVisible;
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    public void addOnClickListenerAfter(View.OnClickListener listener) {
        if (this.afterListeners == null) {
            this.afterListeners = new ArrayList<View.OnClickListener>(3);
        }
        this.afterListeners.add(listener);
    }

    public void addOnClickListenerBefore(View.OnClickListener listener) {
        if (this.beforeListeners == null) {
            this.beforeListeners = new ArrayList<View.OnClickListener>(3);
        }
        this.beforeListeners.add(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textColor = enabled ? -1 : this.colors.getColor("BUTTON_DISABLED_TEXT");
        if (this.textView != null) {
            this.textView.setTextColor(this.textColor);
        }
    }

    public static enum TEXT_ALIGN {
        LEFT,
        CENTER,
        RIGHT;

    }
}

