/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.view;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ViewFlipper;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.i18n.LocalizationService;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.ui.view.BasicLoadingView;
import com.socialize.ui.view.SafeViewFlipper;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;
import com.socialize.util.StringUtils;
import com.socialize.view.BaseView;

public class CustomCheckbox
extends BaseView {
    private LocalizationService localizationService;
    private ImageView checkBox;
    private TextView checkboxLabel;
    private boolean checked = false;
    private boolean enabled = true;
    private boolean changed = false;
    private Drawables drawables;
    private Colors colors;
    private DisplayUtils displayUtils;
    private String imageOn;
    private String imageOff;
    private String textOnKey;
    private String textOffKey;
    private boolean borderOn = true;
    private int padding = 4;
    private int textPadding = 4;
    private int imageMargin = 4;
    private int textSize = 12;
    private View.OnClickListener customClickListener;
    private View.OnClickListener defaultClickListener;
    private IBeanFactory<BasicLoadingView> loadingViewFactory;
    private ViewFlipper iconFlipper;

    public CustomCheckbox(Context context) {
        super(context);
    }

    public void init() {
        int dipPadding = this.displayUtils.getDIP(this.padding);
        int leftPadding = this.displayUtils.getDIP(this.textPadding);
        int margin = this.displayUtils.getDIP(this.imageMargin);
        this.checkboxLabel = new TextView(this.getContext());
        this.checkboxLabel.setTextSize(1, (float)this.textSize);
        this.checkboxLabel.setTextColor(-1);
        this.checkboxLabel.setGravity(19);
        this.checkBox = new ImageView(this.getContext());
        LinearLayout.LayoutParams checkboxMasterLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        LinearLayout.LayoutParams checkboxLabelLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        LinearLayout.LayoutParams checkboxLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        checkboxLayoutParams.setMargins(margin, margin, margin, margin);
        this.checkboxLabel.setLayoutParams((ViewGroup.LayoutParams)checkboxLabelLayoutParams);
        this.checkBox.setLayoutParams((ViewGroup.LayoutParams)checkboxLayoutParams);
        this.checkBox.setPadding(dipPadding, dipPadding, dipPadding, dipPadding);
        this.checkboxLabel.setPadding(leftPadding, dipPadding, dipPadding, dipPadding);
        this.setLayoutParams((ViewGroup.LayoutParams)checkboxMasterLayoutParams);
        this.setGravity(19);
        this.setDisplay();
        this.checkboxLabel.setGravity(19);
        checkboxMasterLayoutParams.gravity = 19;
        checkboxLabelLayoutParams.gravity = 19;
        checkboxLayoutParams.gravity = 19;
        this.setOrientation(0);
        this.defaultClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (CustomCheckbox.this.enabled) {
                    CustomCheckbox.this.changed = true;
                    CustomCheckbox.this.checked = !CustomCheckbox.this.checked;
                    if (CustomCheckbox.this.customClickListener != null) {
                        CustomCheckbox.this.customClickListener.onClick(v);
                    }
                    CustomCheckbox.this.setDisplay();
                }
            }
        };
        BasicLoadingView loadingScreen = (BasicLoadingView)((Object)this.loadingViewFactory.getBean());
        LinearLayout.LayoutParams iconFlipperParams = new LinearLayout.LayoutParams(-2, -2);
        iconFlipperParams.gravity = 17;
        this.iconFlipper = new SafeViewFlipper(this.getContext());
        this.iconFlipper.setLayoutParams((ViewGroup.LayoutParams)iconFlipperParams);
        this.iconFlipper.addView((View)this.checkBox, 0);
        this.iconFlipper.addView((View)loadingScreen, 1);
        this.iconFlipper.setDisplayedChild(0);
        this.addView((View)this.iconFlipper);
        this.addView((View)this.checkboxLabel);
        super.setOnClickListener(this.defaultClickListener);
        if (StringUtils.isEmpty(this.textOnKey) && StringUtils.isEmpty(this.textOffKey)) {
            this.checkboxLabel.setVisibility(8);
        }
        this.checkboxLabel.setTextColor(this.checkboxLabel.getTextColors().withAlpha(255));
        if (this.borderOn) {
            GradientDrawable background = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{this.colors.getColor("CHECKBOX_BORDER_BOTTOM"), this.colors.getColor("CHECKBOX_BORDER_TOP")});
            ColorDrawable topRight = new ColorDrawable(-16777216);
            ColorDrawable bottomLeft = new ColorDrawable(-7829368);
            LayerDrawable bg = new LayerDrawable(new Drawable[]{bottomLeft, topRight, background});
            bg.setLayerInset(0, 1, 0, 0, 1);
            bg.setLayerInset(1, 0, 1, 1, 0);
            bg.setLayerInset(2, 1, 1, 1, 1);
            bg.setAlpha(96);
            CompatUtils.setBackgroundDrawable((View)this, (Drawable)bg);
        }
    }

    protected void setDisplay() {
        if (this.checked) {
            this.setTextOnKey(this.textOnKey);
            this.checkBox.setImageDrawable(this.drawables.getDrawable(this.imageOn));
        } else {
            this.setTextOffKey(this.textOffKey);
            this.checkBox.setImageDrawable(this.drawables.getDrawable(this.imageOff));
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        if (checked != this.checked) {
            this.checked = checked;
            this.setDisplay();
        }
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setImageOn(String imageOn) {
        this.imageOn = imageOn;
    }

    public void setImageOff(String imageOff) {
        this.imageOff = imageOff;
    }

    public void setTextSize(int unit, float size) {
        if (this.checkboxLabel != null) {
            this.checkboxLabel.setTextSize(unit, size);
        }
    }

    @Deprecated
    public void setTextOn(String textOn) {
        this.setText(textOn);
    }

    @Deprecated
    public void setTextOff(String textOff) {
        this.setText(textOff);
    }

    public void setTextOnKey(String key) {
        this.textOnKey = key;
        this.setText(this.localizationService.getString(this.textOnKey));
    }

    public void setTextOffKey(String key) {
        this.textOffKey = key;
        this.setText(this.localizationService.getString(this.textOffKey));
    }

    protected void setText(String text) {
        if (this.checkboxLabel != null) {
            this.checkboxLabel.setText((CharSequence)text);
            this.checkboxLabel.setVisibility(0);
        }
    }

    public void setBorderOn(boolean borderOn) {
        this.borderOn = borderOn;
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.customClickListener = l;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void showLoading() {
        if (this.iconFlipper != null) {
            this.setEnabled(false);
            this.iconFlipper.setDisplayedChild(1);
        }
    }

    public void hideLoading() {
        if (this.iconFlipper != null) {
            this.setEnabled(true);
            this.iconFlipper.setDisplayedChild(0);
        }
    }

    public void setLoadingViewFactory(IBeanFactory<BasicLoadingView> loadingViewFactory) {
        this.loadingViewFactory = loadingViewFactory;
    }

    public String getImageOn() {
        return this.imageOn;
    }

    public String getImageOff() {
        return this.imageOff;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setTextPadding(int textPadding) {
        this.textPadding = textPadding;
    }

    public void setImageMargin(int imageMargin) {
        this.imageMargin = imageMargin;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
        if (this.checkboxLabel != null) {
            this.checkboxLabel.setTextSize(1, (float)textSize);
        }
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        super.setEnabled(enabled);
        this.checkBox.setEnabled(enabled);
        this.checkboxLabel.setEnabled(enabled);
        if (enabled) {
            this.checkboxLabel.setTextColor(this.checkboxLabel.getTextColors().withAlpha(255));
        } else {
            this.checkboxLabel.setTextColor(this.checkboxLabel.getTextColors().withAlpha(128));
        }
    }
}

