/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.view;

import android.view.View;
import com.socialize.android.ioc.IOCContainer;
import com.socialize.api.SocializeSession;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.view.AuthenticatedView;

public class AuthenticatedViewListener
implements SocializeAuthListener {
    protected AuthenticatedView view;
    protected IOCContainer container;

    public AuthenticatedViewListener(AuthenticatedView view, IOCContainer container) {
        this.view = view;
        this.container = container;
    }

    @Override
    public void onAuthFail(SocializeException error) {
        this.onError(error);
    }

    @Override
    public void onError(SocializeException error) {
        this.view.onAfterAuthenticate(this.container);
        View v = this.view.getView();
        this.view.removeAllViews();
        if (v != null) {
            this.view.addView(v);
        } else {
            SocializeLogger.e(this.view.getClass().getSimpleName() + " failed to produce a view");
        }
        this.view.showError(this.view.getContext(), error);
        SocializeLogger.e(error.getMessage(), error);
        if (this.view.getOnErrorListener() != null) {
            this.view.getOnErrorListener().onError(error);
        }
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onAuthSuccess(SocializeSession session) {
        try {
            this.view.onAfterAuthenticate(this.container);
            View v = this.view.getView();
            this.view.removeAllViews();
            if (v != null) {
                this.view.addView(v);
            } else {
                SocializeLogger.e(this.view.getClass().getSimpleName() + " failed to produce a view");
            }
        }
        catch (Throwable e) {
            SocializeLogger.e("", e);
        }
    }
}

