/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import com.socialize.ConfigUtils;
import com.socialize.android.ioc.IOCContainer;
import com.socialize.error.SocializeErrorHandler;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.listener.SocializeListener;
import com.socialize.ui.SocializeBaseView;
import com.socialize.ui.view.AuthenticatedViewListener;

public abstract class AuthenticatedView
extends SocializeBaseView {
    private String consumerKey;
    private String consumerSecret;
    private String fbAppId;
    private SocializeListener onErrorListener;

    public AuthenticatedView(Context context) {
        super(context);
    }

    public AuthenticatedView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public final void onViewLoad(IOCContainer container) {
        super.onViewLoad(container);
        this.setErrorHandler((SocializeErrorHandler)container.getBean("socializeUIErrorHandler"));
        this.consumerKey = this.getConsumerKey(container);
        this.consumerSecret = this.getConsumerSecret(container);
        this.fbAppId = this.getFacebookAppId(container);
        SocializeAuthListener listener = this.getAuthListener(container);
        this.onBeforeAuthenticate(container);
        this.getSocialize().authenticate(container.getContext(), this.consumerKey, this.consumerSecret, listener);
    }

    @Override
    public void onViewUpdate(IOCContainer container) {
        super.onViewUpdate(container);
        if (container != null) {
            this.setErrorHandler((SocializeErrorHandler)container.getBean("socializeUIErrorHandler"));
        }
        this.onAfterAuthenticate(container);
    }

    protected String getConsumerKey(IOCContainer container) {
        return ConfigUtils.getConfig(this.getContext()).getProperty("socialize.consumer.key");
    }

    protected String getConsumerSecret(IOCContainer container) {
        return ConfigUtils.getConfig(this.getContext()).getProperty("socialize.consumer.secret");
    }

    protected String getFacebookAppId(IOCContainer container) {
        return ConfigUtils.getConfig(this.getContext()).getProperty("facebook.app.id");
    }

    public SocializeAuthListener getAuthListener(IOCContainer container) {
        return new AuthenticatedViewListener(this, container);
    }

    protected Context getViewContext() {
        return this.getContext();
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setFbAppId(String fbAppId) {
        this.fbAppId = fbAppId;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getFbAppId() {
        return this.fbAppId;
    }

    public void setOnErrorListener(SocializeListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    public SocializeListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public void onBeforeAuthenticate(IOCContainer container) {
    }

    public void onAfterAuthenticate(IOCContainer container) {
    }

    public abstract View getView();
}

