/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.util;

import android.graphics.Color;
import com.socialize.log.SocializeLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Colors {
    public static final String TITLE = "TITLE";
    public static final String BODY = "BODY";
    public static final String HEADER = "HEADER";
    public static final String COMMENT_TITLE = "COMMENT_TITLE";
    public static final String COMMENT_BODY = "COMMENT_BODY";
    public static final String BUTTON_BOTTOM = "BUTTON_BOTTOM";
    public static final String SOCIALIZE_BLUE = "SOCIALIZE_BLUE";
    public static final String BUTTON_TOP_STROKE = "BUTTON_TOP_STROKE";
    public static final String BUTTON_BOTTOM_STROKE = "BUTTON_BOTTOM_STROKE";
    public static final String BUTTON_TOP = "BUTTON_TOP";
    public static final String TEXT_BG = "TEXT_BG";
    public static final String TEXT_STROKE = "TEXT_STROKE";
    public static final String LIST_ITEM_BG = "LIST_ITEM_BG";
    public static final String APP_BG = "APP_BG";
    public static final String ACTIVITY_BG = "ACTIVITY_BG";
    public static final String LIST_ITEM_TOP = "LIST_ITEM_TOP";
    public static final String LIST_ITEM_BOTTOM = "LIST_ITEM_BOTTOM";
    public static final String STANDARD_BACKGROUND_COLOR = "STANDARD_BACKGROUND_COLOR";
    public static final String LOADING_ITEM_BG = "LOADING_ITEM_BG";
    public static final String ANON_CELL_TITLE = "ANON_CELL_TITLE";
    public static final String ANON_CELL_TEXT = "ANON_CELL_TEXT";
    public static final String AUTH_PANEL_TOP = "AUTH_PANEL_TOP";
    public static final String AUTH_PANEL_BOTTOM = "AUTH_PANEL_BOTTOM";
    public static final String AUTH_PANEL_CANCEL_TEXT = "AUTH_PANEL_CANCEL_TEXT";
    public static final String COMMENT_ENTRY_TOP = "COMMENT_ENTRY_TOP";
    public static final String COMMENT_ENTRY_BOTTOM = "COMMENT_ENTRY_BOTTOM";
    public static final String AUTH_REQUEST_DIALOG_TOP = "AUTH_REQUEST_DIALOG_TOP";
    public static final String AUTH_REQUEST_DIALOG_BOTTOM = "AUTH_REQUEST_DIALOG_BOTTOM";
    public static final String ACTION_BAR_SLIDER_CONTENT = "ACTION_BAR_SLIDER_CONTENT";
    public static final String CHECKBOX_BORDER_BOTTOM = "CHECKBOX_BORDER_BOTTOM";
    public static final String CHECKBOX_BORDER_TOP = "CHECKBOX_BORDER_TOP";
    public static final String CLICKABLE_CELL_STROKE = "CLICKABLE_CELL_STROKE";
    public static final String BUTTON_DISABLED_BOTTOM = "BUTTON_DISABLED_BOTTOM";
    public static final String BUTTON_DISABLED_TOP = "BUTTON_DISABLED_TOP";
    public static final String BUTTON_DISABLED_TEXT = "BUTTON_DISABLED_TEXT";
    public static final String BUTTON_DISABLED_STROKE = "BUTTON_DISABLED_STROKE";
    public static final String BUTTON_DISABLED_BACKGROUND = "BUTTON_DISABLED_BACKGROUND";
    private Map<String, String> colorHexCodes;
    private Map<String, Integer> colors;
    private static Map<String, Integer> parsedColors = new HashMap<String, Integer>();

    public void init() {
        this.colors = new TreeMap<String, Integer>();
        if (this.colorHexCodes != null) {
            Set<Map.Entry<String, String>> entries = this.colorHexCodes.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String hex = entry.getValue().trim().toLowerCase();
                if (!hex.startsWith("#")) {
                    hex = "#" + hex;
                    this.colorHexCodes.put(entry.getKey(), hex);
                }
                try {
                    int color = Color.parseColor((String)entry.getValue());
                    this.colors.put(entry.getKey(), color);
                }
                catch (Exception e) {
                    SocializeLogger.e(e.getMessage(), e);
                }
            }
        }
    }

    public String getHexColor(String name) {
        return this.colorHexCodes.get(name);
    }

    public int getColor(String name) {
        Integer i = this.colors.get(name);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public void setColorHexCodes(Map<String, String> colorHexCodes) {
        this.colorHexCodes = colorHexCodes;
    }

    public static int parseColor(String colorHex) {
        Integer color = parsedColors.get(colorHex);
        if (color != null) {
            return color;
        }
        int icolor = Color.parseColor((String)colorHex);
        parsedColors.put(colorHex, icolor);
        return icolor;
    }
}

