/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.slider;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.FloatMath;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.socialize.ui.slider.ActionBarSliderView;
import com.socialize.ui.slider.ActionBarSliderViewChild;
import com.socialize.ui.util.CompatUtils;
import com.socialize.util.Drawables;
import com.socialize.util.StringUtils;

public class ActionBarSliderHandle
extends ActionBarSliderViewChild {
    private int height;
    private TextView text;
    private LinearLayout closeButton;
    private ImageView icon;
    private Drawables drawables;
    private String title = "";

    public ActionBarSliderHandle(Context context, ActionBarSliderView parent, int height) {
        super(context, parent);
        this.height = height;
    }

    public void init() {
        CompatUtils.setBackgroundDrawable((View)this, this.drawables.getDrawable("toolbar_bg.png", true, false, true));
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, this.height);
        params.setMargins(0, 0, 0, 0);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setPadding(0, 0, 0, 0);
        this.setOrientation(0);
        this.text = new TextView(this.getContext());
        this.text.setText((CharSequence)this.title);
        this.text.setGravity(19);
        this.text.setPadding(4, 0, 4, 0);
        this.text.setTypeface(Typeface.DEFAULT_BOLD);
        this.text.setTextColor(-1);
        this.text.setTextSize(1, 12.0f);
        Drawable drawable2 = this.drawables.getDrawable("toolbar_close.png");
        this.closeButton = new LinearLayout(this.getContext());
        this.closeButton.setPadding(0, 0, 0, 0);
        CompatUtils.setBackgroundDrawable((View)this.closeButton, drawable2);
        this.icon = new ImageView(this.getContext());
        LinearLayout.LayoutParams textParams = new LinearLayout.LayoutParams(-1, -1);
        textParams.weight = 1.0f;
        LinearLayout.LayoutParams closeImageParams = new LinearLayout.LayoutParams(-2, -2);
        closeImageParams.weight = 0.0f;
        closeImageParams.gravity = 21;
        closeImageParams.setMargins(0, 0, 0, 0);
        LinearLayout.LayoutParams iconParams = new LinearLayout.LayoutParams(-2, -2);
        iconParams.weight = 0.0f;
        iconParams.gravity = 19;
        iconParams.setMargins(0, 0, 0, 0);
        this.text.setLayoutParams((ViewGroup.LayoutParams)textParams);
        this.closeButton.setLayoutParams((ViewGroup.LayoutParams)closeImageParams);
        this.icon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
        this.addView((View)this.icon);
        this.addView((View)this.text);
        this.addView((View)this.closeButton);
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setTitle(String str) {
        if (this.text != null) {
            this.text.setText((CharSequence)str);
        }
        this.title = str;
    }

    public void setIconImage(String imageName) {
        if (StringUtils.isEmpty(imageName)) {
            this.icon.setVisibility(8);
        } else {
            this.icon.setImageDrawable(this.drawables.getDrawable(imageName));
            this.icon.setVisibility(0);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        Rect rect = new Rect();
        this.closeButton.getHitRect(rect);
        this.adjustHitRect(rect);
        if (rect.contains((int)FloatMath.ceil((float)ev.getX()), (int)FloatMath.ceil((float)ev.getY()))) {
            this.getSlider().close();
        } else {
            this.getSlider().slide();
        }
        return true;
    }
}

