/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.share;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.view.View;
import com.socialize.ShareUtils;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.api.action.ShareType;
import com.socialize.api.action.share.ShareOptions;
import com.socialize.entity.Entity;
import com.socialize.entity.Share;
import com.socialize.error.SocializeException;
import com.socialize.listener.share.ShareAddListener;
import com.socialize.networks.SocialNetwork;
import com.socialize.ui.actionbar.ActionBarView;
import com.socialize.ui.actionbar.OnActionBarEventListener;
import com.socialize.ui.dialog.AlertDialogFactory;
import com.socialize.ui.dialog.ProgressDialogFactory;
import com.socialize.ui.share.ShareInfoProvider;

public class ShareClickListener
implements View.OnClickListener {
    private ShareType shareType;
    private Activity context;
    private Entity entity;
    private ShareInfoProvider provider;
    private ProgressDialogFactory progressDialogFactory;
    private AlertDialogFactory alertDialogFactory;
    private OnActionBarEventListener onActionBarEventListener;
    private ActionBarView actionBarView;

    public ShareClickListener(Activity context) {
        this.context = context;
    }

    public ShareClickListener(Activity context, Entity entity, ShareType shareType, ShareInfoProvider provider, OnActionBarEventListener onActionBarEventListener, ActionBarView actionBarView) {
        this(context);
        this.shareType = shareType;
        this.entity = entity;
        this.provider = provider;
        this.onActionBarEventListener = onActionBarEventListener;
        this.actionBarView = actionBarView;
    }

    public void onClick(View view) {
        final ProgressDialog dialog = this.progressDialogFactory.show(view.getContext(), "socialize_share_dialog", "socialize_share_dialog_message " + this.shareType.getDisplayName() + "...");
        ShareOptions shareOptions = ShareUtils.getUserShareOptions((Context)this.context);
        shareOptions.setText(this.provider.getShareText());
        ShareUtils.registerShare(this.context, this.entity, shareOptions, new ShareAddListener(){

            @Override
            public void onError(SocializeException error) {
                dialog.dismiss();
                ShareClickListener.this.alertDialogFactory.showToast((Context)ShareClickListener.this.context, "Share failed.  Please try again");
            }

            @Override
            public void onCreate(Share share) {
                dialog.dismiss();
                if (ShareClickListener.this.onActionBarEventListener != null) {
                    ShareClickListener.this.onActionBarEventListener.onPostShare(ShareClickListener.this.actionBarView, share);
                }
            }
        }, SocialNetwork.valueOf(this.shareType));
    }

    public void setProgressDialogFactory(ProgressDialogFactory progressDialogFactory) {
        this.progressDialogFactory = progressDialogFactory;
    }

    public void setAlertDialogFactory(AlertDialogFactory alertDialogFactory) {
        this.alertDialogFactory = alertDialogFactory;
    }

    public void setShareType(ShareType shareType) {
        this.shareType = shareType;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public void setProvider(ShareInfoProvider provider) {
        this.provider = provider;
    }

    public void setOnActionBarEventListener(OnActionBarEventListener onActionBarEventListener) {
        this.onActionBarEventListener = onActionBarEventListener;
    }

    public void setActionBarView(ActionBarView actionBarView) {
        this.actionBarView = actionBarView;
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }
}

