/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.profile.activity;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.socialize.ActionUtils;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.entity.ListResult;
import com.socialize.entity.SocializeAction;
import com.socialize.error.SocializeException;
import com.socialize.listener.activity.ActionListListener;
import com.socialize.ui.profile.activity.UserActivityListItem;
import com.socialize.ui.view.LoadingItemView;
import com.socialize.view.BaseView;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class UserActivityView
extends BaseView {
    private LoadingItemView<UserActivityListItem> itemView;
    private int numItems = 10;
    private IBeanFactory<UserActivityListItem> userActivityListItemFactory;
    private IBeanFactory<LoadingItemView<UserActivityListItem>> loadingItemViewFactory;

    public UserActivityView(Context context) {
        super(context);
    }

    public void init() {
        this.itemView = (LoadingItemView)this.loadingItemViewFactory.getBean();
        this.itemView.setEmptyText("No other recent activity");
        this.addView((View)this.itemView);
    }

    public void clearUserActivity() {
        this.itemView.clear();
        this.itemView.showEmptyText();
    }

    public void loadUserActivity(long userId, final SocializeAction current) {
        this.itemView.showLoading();
        ActionUtils.getActionsByUser(this.getActivity(), userId, 0, this.numItems, new ActionListListener(){

            @Override
            public void onList(ListResult<SocializeAction> entities) {
                if (entities != null) {
                    Date now = new Date();
                    List<SocializeAction> items = entities.getItems();
                    if (items != null && current != null) {
                        items.remove(current);
                    }
                    if (items != null && items.size() > 0) {
                        ArrayList<UserActivityListItem> views = new ArrayList<UserActivityListItem>(items.size());
                        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
                        params.setMargins(0, 8, 0, 0);
                        for (SocializeAction item : items) {
                            UserActivityListItem view = (UserActivityListItem)((Object)UserActivityView.this.userActivityListItemFactory.getBean());
                            view.setAction(UserActivityView.this.getContext(), item, now);
                            view.setLayoutParams((ViewGroup.LayoutParams)params);
                            views.add(view);
                        }
                        UserActivityView.this.itemView.setItems(views);
                        UserActivityView.this.itemView.showList();
                    } else {
                        UserActivityView.this.itemView.clear();
                        UserActivityView.this.itemView.showEmptyText();
                    }
                } else {
                    UserActivityView.this.itemView.clear();
                    UserActivityView.this.itemView.showEmptyText();
                }
            }

            @Override
            public void onError(SocializeException error) {
                UserActivityView.this.itemView.clear();
                UserActivityView.this.itemView.showEmptyText();
            }
        });
    }

    public LoadingItemView<UserActivityListItem> getItemView() {
        return this.itemView;
    }

    public void setNumItems(int numItems) {
        this.numItems = numItems;
    }

    public void setLoadingItemViewFactory(IBeanFactory<LoadingItemView<UserActivityListItem>> loadingListViewFactory) {
        this.loadingItemViewFactory = loadingListViewFactory;
    }

    public void setUserActivityListItemFactory(IBeanFactory<UserActivityListItem> userActivityListItemFactory) {
        this.userActivityListItemFactory = userActivityListItemFactory;
    }
}

