/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.profile.activity;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.socialize.Socialize;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.entity.SocializeAction;
import com.socialize.ui.SocializeEntityLoader;
import com.socialize.ui.profile.activity.UserActivityAction;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.ui.util.DateUtils;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;
import java.util.Date;

public class UserActivityListItem
extends TableLayout {
    private TextView date;
    private ImageView icon;
    private ImageView locationIcon;
    private UserActivityAction actionText;
    private Drawable background;
    private DisplayUtils displayUtils;
    private Colors colors;
    private Drawables drawables;
    private DateUtils dateUtils;
    private int padding;
    private int bgColor;
    private int topColor;
    private int bottomColor;
    private int contentFontSize = 12;
    private int titleFontSize = 11;
    private IBeanFactory<UserActivityAction> userActivityActionTextFactory;

    public UserActivityListItem(Context context) {
        super(context);
    }

    public UserActivityListItem(Context context, boolean singleLine) {
        super(context);
    }

    public void init() {
        this.padding = this.displayUtils.getDIP(4);
        this.bgColor = this.colors.getColor("LIST_ITEM_BG");
        this.topColor = this.colors.getColor("LIST_ITEM_TOP");
        this.bottomColor = this.colors.getColor("LIST_ITEM_BOTTOM");
        int contentMargin = this.displayUtils.getDIP(4);
        this.setOrientation(0);
        this.setGravity(48);
        this.setPadding(this.padding, this.padding, this.padding, this.padding);
        this.setColumnStretchable(2, true);
        this.setColumnShrinkable(2, true);
        TableRow firstRow = new TableRow(this.getContext());
        TableRow secondRow = new TableRow(this.getContext());
        View location = this.createLocation();
        View icon = this.createIcon();
        View content = this.createTitle();
        View date = this.createDate();
        icon.setPadding(this.padding, this.padding, this.padding, this.padding);
        content.setPadding(this.padding, this.padding, this.padding, this.padding);
        date.setPadding(this.padding, this.padding, this.padding, this.padding);
        location.setPadding(this.padding, this.padding, this.padding, this.padding);
        TableRow.LayoutParams iconParams = new TableRow.LayoutParams();
        TableRow.LayoutParams locationIconParams = new TableRow.LayoutParams();
        TableRow.LayoutParams contentParams = new TableRow.LayoutParams();
        TableRow.LayoutParams dateParams = new TableRow.LayoutParams();
        iconParams.column = 1;
        iconParams.gravity = 51;
        contentParams.column = 2;
        contentParams.gravity = 51;
        contentParams.setMargins(0, contentMargin, 0, 0);
        locationIconParams.column = 3;
        locationIconParams.gravity = 53;
        dateParams.width = -1;
        dateParams.gravity = 85;
        dateParams.span = 4;
        location.setLayoutParams((ViewGroup.LayoutParams)locationIconParams);
        icon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
        content.setLayoutParams((ViewGroup.LayoutParams)contentParams);
        date.setLayoutParams((ViewGroup.LayoutParams)dateParams);
        firstRow.addView(icon);
        firstRow.addView(content);
        firstRow.addView(location);
        secondRow.addView(date);
        this.addView((View)firstRow);
        this.addView((View)secondRow);
    }

    protected View createTitle() {
        this.actionText = (UserActivityAction)this.userActivityActionTextFactory.getBean();
        return (View)this.actionText;
    }

    protected View createIcon() {
        this.icon = new ImageView(this.getContext());
        return this.icon;
    }

    protected View createLocation() {
        this.locationIcon = new ImageView(this.getContext());
        this.locationIcon.setImageDrawable(this.drawables.getDrawable("icon_location_pin.png"));
        return this.locationIcon;
    }

    protected View createDate() {
        this.date = new TextView(this.getContext());
        this.date.setTextSize(1, 10.0f);
        this.date.setTextColor(-3355444);
        this.date.setGravity(85);
        return this.date;
    }

    public void setAction(Context context, final SocializeAction action, Date now) {
        if (this.background == null) {
            this.background = this.makeDefaultBackground();
        }
        CompatUtils.setBackgroundDrawable((View)this, this.background);
        this.actionText.setTitleFontSize(this.titleFontSize);
        this.actionText.setContentFontSize(this.contentFontSize);
        this.actionText.setAction(context, action);
        Long actionDate = action.getDate();
        if (actionDate != null && actionDate > 0L) {
            long diff = now.getTime() - actionDate;
            this.date.setText((CharSequence)(this.dateUtils.getTimeString(diff) + " "));
        } else {
            this.date.setText((CharSequence)"");
        }
        if (!action.isLocationShared()) {
            this.locationIcon.setVisibility(8);
        }
        switch (action.getActionType()) {
            case COMMENT: {
                this.icon.setImageDrawable(this.drawables.getDrawable("icon_comment.png"));
                break;
            }
            case LIKE: {
                this.icon.setImageDrawable(this.drawables.getDrawable("icon_like_hi.png"));
                break;
            }
            case SHARE: {
                this.icon.setImageDrawable(this.drawables.getDrawable("icon_share.png"));
            }
        }
        final SocializeEntityLoader entityLoader = Socialize.getSocialize().getEntityLoader();
        if (entityLoader != null && entityLoader.canLoad(this.getContext(), action.getEntity())) {
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    entityLoader.loadEntity((Activity)UserActivityListItem.this.getContext(), action.getEntity());
                }
            });
        }
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setDateUtils(DateUtils dateUtils) {
        this.dateUtils = dateUtils;
    }

    public void setUserActivityActionTextFactory(IBeanFactory<UserActivityAction> userActivityActionTextFactory) {
        this.userActivityActionTextFactory = userActivityActionTextFactory;
    }

    public void setBackground(Drawable background) {
        this.background = background;
    }

    protected Drawable makeDefaultBackground() {
        ColorDrawable shadow = this.makeColorDrawable(this.bottomColor);
        ColorDrawable highlight = this.makeColorDrawable(this.topColor);
        ColorDrawable surface = this.makeColorDrawable(this.bgColor);
        LayerDrawable layers = new LayerDrawable(new Drawable[]{shadow, highlight, surface});
        layers.setLayerInset(0, 0, 0, 0, 0);
        layers.setLayerInset(1, 1, 0, 0, 1);
        layers.setLayerInset(2, 1, 1, 1, 1);
        return layers;
    }

    public void setContentFontSize(int contentFontSize) {
        this.contentFontSize = contentFontSize;
    }

    public void setTitleFontSize(int titleFontSize) {
        this.titleFontSize = titleFontSize;
    }

    protected ColorDrawable makeColorDrawable(int color) {
        return new ColorDrawable(color);
    }
}

