/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.profile.activity;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.text.SpannableString;
import android.text.style.TextAppearanceSpan;
import android.view.View;
import android.widget.TextView;
import com.socialize.Socialize;
import com.socialize.api.action.ActionType;
import com.socialize.entity.SocializeAction;
import com.socialize.entity.User;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.SocializeEntityLoader;
import com.socialize.ui.profile.activity.UserActivityAction;
import com.socialize.ui.util.Colors;
import com.socialize.util.DisplayUtils;
import com.socialize.util.StringUtils;

public class UserActivityActionText
extends TextView
implements UserActivityAction {
    private Colors colors;
    private int contentFontSize = 12;
    private int titleFontSize = 11;
    private DisplayUtils displayUtils;
    private SocializeLogger logger;

    public UserActivityActionText(Context context) {
        super(context);
    }

    @Override
    public void init() {
        this.setBackgroundColor(0);
    }

    @Override
    public void setAction(Context context, SocializeAction action) {
        try {
            this.doSetAction(action);
        }
        catch (Exception e) {
            this.setText("Error!");
            if (this.logger != null) {
                this.logger.error("Error rendering action text", (Throwable)e);
            }
            SocializeLogger.e(e.getMessage(), e);
        }
    }

    protected void doSetAction(final SocializeAction action) {
        TextAppearanceSpan textAppearanceSpan;
        int contentFontSizeDip = this.displayUtils.getDIP(this.contentFontSize);
        StringBuilder builder = new StringBuilder();
        boolean canLoad = false;
        final SocializeEntityLoader entityLoader = Socialize.getSocialize().getEntityLoader();
        if (entityLoader != null && (canLoad = entityLoader.canLoad(this.getContext(), action.getEntity()))) {
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    entityLoader.loadEntity((Activity)UserActivityActionText.this.getContext(), action.getEntity());
                }
            });
        }
        this.setTextSize(1, this.titleFontSize);
        String name = "";
        User user = action.getUser();
        if (user != null) {
            name = user.getFirstName();
            if (StringUtils.isEmpty(name)) {
                name = user.getDisplayName();
            }
            if (name == null) {
                name = "";
            }
        }
        builder.append(name);
        String actionText = null;
        switch (action.getActionType()) {
            case COMMENT: {
                builder.append(" commented on ");
                actionText = StringUtils.replaceNewLines(action.getDisplayText(), 3, 2);
                break;
            }
            case LIKE: {
                builder.append(" liked ");
                break;
            }
            case SHARE: {
                actionText = action.getDisplayText();
                builder.append(" shared ");
            }
        }
        String textSoFar = builder.toString();
        String entityName = StringUtils.ellipsis(action.getEntityDisplayName(), 30);
        entityName = !StringUtils.isEmpty(entityName) ? StringUtils.encodeUtf8(entityName) : "";
        int entityNameStartIndex = textSoFar.length();
        int entityNameEndIndex = entityNameStartIndex + entityName.length();
        int actionTextStartIndex = 0;
        int actionTextEndIndex = 0;
        builder.append(entityName);
        if (actionText != null) {
            actionText = StringUtils.encodeUtf8(actionText);
            builder.append("\n\n");
            actionTextStartIndex = entityNameEndIndex + 2;
            if (action.getActionType().equals((Object)ActionType.COMMENT)) {
                builder.append("\"");
                builder.append(actionText);
                builder.append("\"");
                actionTextEndIndex = actionTextStartIndex + actionText.length() + 2;
            } else {
                builder.append(actionText);
                actionTextEndIndex = actionTextStartIndex + actionText.length();
            }
        }
        SpannableString spannable = new SpannableString((CharSequence)builder.toString());
        if (canLoad) {
            ColorStateList linkColor = new ColorStateList((int[][])new int[][]{{16842919}, new int[0]}, new int[]{-12303292, this.colors.getColor("SOCIALIZE_BLUE")});
            textAppearanceSpan = new TextAppearanceSpan("sans", 1, contentFontSizeDip, linkColor, linkColor);
            spannable.setSpan((Object)textAppearanceSpan, entityNameStartIndex, entityNameEndIndex, 33);
        }
        if (actionText != null) {
            ColorStateList bodyColor = new ColorStateList((int[][])new int[][]{{16842919}, new int[0]}, new int[]{-12303292, this.colors.getColor("BODY")});
            textAppearanceSpan = new TextAppearanceSpan("serif", 2, contentFontSizeDip, bodyColor, bodyColor);
            spannable.setSpan((Object)textAppearanceSpan, actionTextStartIndex, actionTextEndIndex, 33);
        }
        this.setText((CharSequence)spannable);
    }

    @Override
    public void setContentFontSize(int contentFontSize) {
        this.contentFontSize = contentFontSize;
    }

    @Override
    public void setTitleFontSize(int titleFontSize) {
        this.titleFontSize = titleFontSize;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

