/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.profile;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.socialize.UserUtils;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.entity.User;
import com.socialize.error.SocializeException;
import com.socialize.listener.user.UserGetListener;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.dialog.ProgressDialogFactory;
import com.socialize.ui.header.SocializeHeader;
import com.socialize.ui.profile.ProfileContentView;
import com.socialize.ui.profile.UserSettings;
import com.socialize.util.BitmapUtils;
import com.socialize.util.DisplayUtils;
import com.socialize.view.BaseView;

public class ProfileLayoutView
extends BaseView {
    private String userId;
    private IBeanFactory<SocializeHeader> profileHeaderFactory;
    private IBeanFactory<ProfileContentView> profileContentViewFactory;
    private SocializeHeader header;
    private ProfileContentView content;
    private ProgressDialog dialog = null;
    private ProgressDialogFactory progressDialogFactory;
    private BitmapUtils bitmapUtils;
    private DisplayUtils displayUtils;

    public ProfileLayoutView(Activity context, String userId) {
        this((Context)context);
        this.userId = userId;
        if (this.userId != null) {
            this.userId = this.userId.trim();
        }
    }

    public ProfileLayoutView(Context context) {
        super(context);
    }

    public void init() {
        LinearLayout.LayoutParams fill = new LinearLayout.LayoutParams(-1, -1);
        this.setOrientation(1);
        this.setLayoutParams((ViewGroup.LayoutParams)fill);
        this.setPadding(0, 0, 0, 0);
        boolean landscape = false;
        if (this.displayUtils != null) {
            landscape = this.displayUtils.isLandscape();
        }
        if (!landscape) {
            this.header = (SocializeHeader)((Object)this.profileHeaderFactory.getBean());
            this.addView((View)this.header);
        }
        this.content = (ProfileContentView)this.profileContentViewFactory.getBean(new Object[]{this});
        this.addView((View)this.content);
    }

    @Override
    public void onViewLoad() {
        super.onViewLoad();
        if (this.getSocialize().isAuthenticated()) {
            this.doGetUserProfile();
        } else {
            this.showError(this.getContext(), new SocializeException("Socialize not authenticated"));
        }
    }

    public void doGetUserProfile() {
        long id = Long.parseLong(this.userId);
        this.dialog = this.progressDialogFactory.show(this.getContext(), "socialize_loading", "socialize_please_wait");
        UserUtils.getUser(this.getContext(), id, new UserGetListener(){

            @Override
            public void onGet(User user) {
                try {
                    UserSettings settings = UserUtils.getUserSettings(ProfileLayoutView.this.getContext());
                    User currentUser = UserUtils.getCurrentUser(ProfileLayoutView.this.getContext());
                    if (currentUser.getId().equals(user.getId())) {
                        currentUser.update(user);
                        settings.update(user);
                        user = currentUser;
                    }
                    ProfileLayoutView.this.setUserDetails(user, settings);
                }
                catch (Exception e) {
                    SocializeLogger.e("Error getting user", e);
                }
                if (ProfileLayoutView.this.dialog != null) {
                    ProfileLayoutView.this.dialog.dismiss();
                }
            }

            @Override
            public void onError(SocializeException error) {
                ProfileLayoutView.this.showError(ProfileLayoutView.this.getContext(), error);
                if (ProfileLayoutView.this.dialog != null) {
                    ProfileLayoutView.this.dialog.dismiss();
                }
            }
        });
    }

    public void onImageChange(Bitmap bitmap) {
        if (bitmap != null) {
            Bitmap scaled = this.bitmapUtils.getScaledBitmap(bitmap, 200, 200);
            this.content.onProfilePictureChange(scaled);
        }
    }

    public void setUserDetails(User user, UserSettings settings) {
        this.content.setUserDetails(user, settings);
    }

    public void setUserId(String entityKey) {
        this.userId = entityKey;
    }

    public void setProgressDialogFactory(ProgressDialogFactory progressDialogFactory) {
        this.progressDialogFactory = progressDialogFactory;
    }

    public void setProfileHeaderFactory(IBeanFactory<SocializeHeader> profileHeaderFactory) {
        this.profileHeaderFactory = profileHeaderFactory;
    }

    public void setProfileContentViewFactory(IBeanFactory<ProfileContentView> profileContentViewFactory) {
        this.profileContentViewFactory = profileContentViewFactory;
    }

    public void setBitmapUtils(BitmapUtils bitmapUtils) {
        this.bitmapUtils = bitmapUtils;
    }

    public void setDisplayUtils(DisplayUtils displayUtils) {
        this.displayUtils = displayUtils;
    }
}

